/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.reduce;

import org.apache.nifi.attribute.expression.language.EvaluationContext;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.StringEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.StringQueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.reduce.ReduceEvaluator;

public class JoinEvaluator
extends StringEvaluator
implements ReduceEvaluator<String> {
    private final Evaluator<String> subjectEvaluator;
    private final Evaluator<String> delimiterEvaluator;

    public JoinEvaluator(Evaluator<String> subject, Evaluator<String> delimiter) {
        this.subjectEvaluator = subject;
        this.delimiterEvaluator = delimiter;
    }

    @Override
    public QueryResult<String> evaluate(EvaluationContext evaluationContext) {
        String subject = this.subjectEvaluator.evaluate(evaluationContext).getValue();
        if (subject == null) {
            subject = "";
        }
        String delimiter = this.delimiterEvaluator.evaluate(evaluationContext).getValue();
        State state = evaluationContext.getEvaluatorState().getState(this, State.class);
        if (state == null) {
            state = new State();
            evaluationContext.getEvaluatorState().putState(this, state);
        }
        if (state.evalCount > 0) {
            state.sb.append(delimiter);
        }
        state.sb.append(subject);
        ++state.evalCount;
        return new StringQueryResult(state.sb.toString());
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return this.subjectEvaluator;
    }

    private class State {
        private final StringBuilder sb = new StringBuilder();
        private int evalCount = 0;

        private State() {
        }
    }
}

