/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.evtx.parser.bxml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.nifi.processors.evtx.parser.BinaryReader;
import org.apache.nifi.processors.evtx.parser.BxmlNodeVisitor;
import org.apache.nifi.processors.evtx.parser.ChunkHeader;
import org.apache.nifi.processors.evtx.parser.NumberUtil;
import org.apache.nifi.processors.evtx.parser.bxml.BxmlNode;
import org.apache.nifi.processors.evtx.parser.bxml.ValueNode;
import org.apache.nifi.processors.evtx.parser.bxml.value.VariantTypeNode;
import org.apache.nifi.processors.evtx.parser.bxml.value.VariantTypeNodeFactory;

public class RootNode
extends BxmlNode {
    private final int substitutionCount;
    private final List<VariantTypeNode> substitutions;

    public RootNode(BinaryReader binaryReader, ChunkHeader chunkHeader, BxmlNode parent) throws IOException {
        super(binaryReader, chunkHeader, parent);
        this.init();
        this.substitutionCount = NumberUtil.intValueMax(binaryReader.readDWord(), Integer.MAX_VALUE, "Invalid substitution count.", new Object[0]);
        ArrayList<VariantTypeSizeAndFactory> substitutionVariantFactories = new ArrayList<VariantTypeSizeAndFactory>(this.substitutionCount);
        for (long i = 0L; i < (long)this.substitutionCount; ++i) {
            try {
                int substitutionSize = binaryReader.readWord();
                int substitutionType = binaryReader.readWord();
                substitutionVariantFactories.add(new VariantTypeSizeAndFactory(substitutionSize, ValueNode.factories.get(substitutionType)));
                continue;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        ArrayList<VariantTypeNode> substitutions = new ArrayList<VariantTypeNode>();
        for (VariantTypeSizeAndFactory substitutionVariantFactory : substitutionVariantFactories) {
            substitutions.add(substitutionVariantFactory.factory.create(binaryReader, chunkHeader, this, substitutionVariantFactory.size));
        }
        this.substitutions = Collections.unmodifiableList(substitutions);
    }

    @Override
    public void accept(BxmlNodeVisitor bxmlNodeVisitor) throws IOException {
        bxmlNodeVisitor.visit(this);
    }

    public List<VariantTypeNode> getSubstitutions() {
        return this.substitutions;
    }

    public String toString() {
        return "RootNode{" + this.getChildren() + "}";
    }

    public class VariantTypeSizeAndFactory {
        private final int size;
        private final VariantTypeNodeFactory factory;

        public VariantTypeSizeAndFactory(int size, VariantTypeNodeFactory factory) {
            this.size = size;
            this.factory = factory;
        }
    }
}

