/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.event.transport.netty.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.DatagramPacket;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.List;
import org.apache.nifi.event.transport.message.ByteArrayMessage;

public class DatagramByteArrayMessageDecoder
extends MessageToMessageDecoder<DatagramPacket> {
    protected void decode(ChannelHandlerContext channelHandlerContext, DatagramPacket datagramPacket, List<Object> decoded) {
        ByteBuf content = (ByteBuf)datagramPacket.content();
        int readableBytes = content.readableBytes();
        byte[] bytes = new byte[readableBytes];
        content.readBytes(bytes);
        InetAddress packetAddress = ((InetSocketAddress)datagramPacket.sender()).getAddress();
        String address = packetAddress.getHostAddress();
        ByteArrayMessage message = new ByteArrayMessage(bytes, address);
        decoded.add(message);
    }
}

