/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.event.transport.netty.channel;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.net.SocketAddress;
import org.apache.nifi.logging.ComponentLog;

@ChannelHandler.Sharable
public class LogExceptionChannelHandler
extends ChannelInboundHandlerAdapter {
    private final ComponentLog log;

    public LogExceptionChannelHandler(ComponentLog log) {
        this.log = log;
    }

    public void exceptionCaught(ChannelHandlerContext context, Throwable exception) {
        SocketAddress remoteAddress = context.channel().remoteAddress();
        this.log.warn("Communication Failed with Remote Address [{}]", new Object[]{remoteAddress, exception});
    }
}

