/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors;

import com.maxmind.geoip2.DatabaseReader;
import com.maxmind.geoip2.exception.GeoIp2Exception;
import com.maxmind.geoip2.model.IspResponse;
import java.io.IOException;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.behavior.EventDriven;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processors.AbstractEnrichIP;
import org.apache.nifi.util.StopWatch;

@EventDriven
@SideEffectFree
@SupportsBatching
@Tags(value={"ISP", "enrich", "ip", "maxmind"})
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@CapabilityDescription(value="Looks up ISP information for an IP address and adds the information to FlowFile attributes. The ISP data is provided as a MaxMind ISP database. (Note that this is NOT the same as the GeoLite database utilized by some geo enrichment tools). The attribute that contains the IP address to lookup is provided by the 'IP Address Attribute' property. If the name of the attribute provided is 'X', then the the attributes added by enrichment will take the form X.isp.<fieldName>")
@WritesAttributes(value={@WritesAttribute(attribute="X.isp.lookup.micros", description="The number of microseconds that the geo lookup took"), @WritesAttribute(attribute="X.isp.asn", description="The Autonomous System Number (ASN) identified for the IP address"), @WritesAttribute(attribute="X.isp.asn.organization", description="The Organization Associated with the ASN identified"), @WritesAttribute(attribute="X.isp.name", description="The name of the ISP associated with the IP address provided"), @WritesAttribute(attribute="X.isp.organization", description="The Organization associated with the IP address provided")})
public class ISPEnrichIP
extends AbstractEnrichIP {
    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        String organisation;
        String ispName;
        String asnOrg;
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        DatabaseReader dbReader = (DatabaseReader)this.databaseReaderRef.get();
        String ipAttributeName = context.getProperty(IP_ADDRESS_ATTRIBUTE).evaluateAttributeExpressions(flowFile).getValue();
        String ipAttributeValue = flowFile.getAttribute(ipAttributeName);
        if (StringUtils.isEmpty((CharSequence)ipAttributeName)) {
            session.transfer(flowFile, REL_NOT_FOUND);
            this.getLogger().warn("FlowFile '{}' attribute '{}' was empty. Routing to failure", new Object[]{flowFile, IP_ADDRESS_ATTRIBUTE.getDisplayName()});
            return;
        }
        InetAddress inetAddress = null;
        IspResponse response = null;
        try {
            inetAddress = InetAddress.getByName(ipAttributeValue);
        }
        catch (IOException ioe) {
            session.transfer(flowFile, REL_NOT_FOUND);
            this.getLogger().warn("Could not resolve the IP for value '{}', contained within the attribute '{}' in FlowFile '{}'. This is usually caused by issue resolving the appropriate DNS record or providing the processor with an invalid IP address ", new Object[]{ipAttributeValue, IP_ADDRESS_ATTRIBUTE.getDisplayName(), flowFile, ioe});
            return;
        }
        StopWatch stopWatch = new StopWatch(true);
        try {
            response = dbReader.isp(inetAddress);
            stopWatch.stop();
        }
        catch (GeoIp2Exception | IOException ex) {
            session.transfer(flowFile, REL_NOT_FOUND);
            this.getLogger().warn("Failure while trying to find enrichment data for {} due to {}", new Object[]{flowFile, ex, ex});
            return;
        }
        if (response == null) {
            session.transfer(flowFile, REL_NOT_FOUND);
            return;
        }
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put(ipAttributeName + ".isp.lookup.micros", String.valueOf(stopWatch.getDuration(TimeUnit.MICROSECONDS)));
        if (response.getAutonomousSystemNumber() != null) {
            attrs.put(ipAttributeName + ".isp.asn", String.valueOf(response.getAutonomousSystemNumber()));
        }
        if ((asnOrg = response.getAutonomousSystemOrganization()) != null) {
            attrs.put(ipAttributeName + ".isp.asn.organization", asnOrg);
        }
        if ((ispName = response.getIsp()) != null) {
            attrs.put(ipAttributeName + ".isp.name", ispName);
        }
        if ((organisation = response.getOrganization()) != null) {
            attrs.put(ipAttributeName + ".isp.organization", organisation);
        }
        flowFile = session.putAllAttributes(flowFile, attrs);
        session.transfer(flowFile, REL_FOUND);
    }
}

