/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.email;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.mail.util.MimeMessageParser;
import org.apache.nifi.annotation.behavior.EventDriven;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.FlowFileHandlingException;
import org.apache.nifi.processor.io.InputStreamCallback;
import org.apache.nifi.processor.io.OutputStreamCallback;

@SupportsBatching
@EventDriven
@SideEffectFree
@Tags(value={"split", "email"})
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@CapabilityDescription(value="Extract attachments from a mime formatted email file, splitting them into individual flowfiles.")
@WritesAttributes(value={@WritesAttribute(attribute="filename ", description="The filename of the attachment"), @WritesAttribute(attribute="email.attachment.parent.filename ", description="The filename of the parent FlowFile"), @WritesAttribute(attribute="email.attachment.parent.uuid", description="The UUID of the original FlowFile."), @WritesAttribute(attribute="mime.type", description="The mime type of the attachment.")})
public class ExtractEmailAttachments
extends AbstractProcessor {
    public static final String ATTACHMENT_ORIGINAL_FILENAME = "email.attachment.parent.filename";
    public static final String ATTACHMENT_ORIGINAL_UUID = "email.attachment.parent.uuid";
    public static final Relationship REL_ATTACHMENTS = new Relationship.Builder().name("attachments").description("Each individual attachment will be routed to the attachments relationship").build();
    public static final Relationship REL_ORIGINAL = new Relationship.Builder().name("original").description("The original file").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("Flowfiles that could not be parsed").build();
    private Set<Relationship> relationships;
    private List<PropertyDescriptor> descriptors;

    protected void init(ProcessorInitializationContext context) {
        HashSet<Relationship> relationships = new HashSet<Relationship>();
        relationships.add(REL_ATTACHMENTS);
        relationships.add(REL_ORIGINAL);
        relationships.add(REL_FAILURE);
        this.relationships = Collections.unmodifiableSet(relationships);
        ArrayList descriptors = new ArrayList();
        this.descriptors = Collections.unmodifiableList(descriptors);
    }

    public void onTrigger(ProcessContext context, final ProcessSession session) {
        final ComponentLog logger = this.getLogger();
        final FlowFile originalFlowFile = session.get();
        if (originalFlowFile == null) {
            return;
        }
        final ArrayList attachmentsList = new ArrayList();
        final ArrayList invalidFlowFilesList = new ArrayList();
        final ArrayList originalFlowFilesList = new ArrayList();
        String requireStrictAddresses = "false";
        session.read(originalFlowFile, new InputStreamCallback(){

            public void process(InputStream rawIn) throws IOException {
                block13: {
                    try (BufferedInputStream in = new BufferedInputStream(rawIn);){
                        Properties props = new Properties();
                        props.put("mail.mime.address.strict", "false");
                        Session mailSession = Session.getInstance((Properties)props);
                        MimeMessage originalMessage = new MimeMessage(mailSession, (InputStream)in);
                        MimeMessageParser parser = new MimeMessageParser(originalMessage).parse();
                        Address[] from = originalMessage.getFrom();
                        if (from == null) {
                            throw new MessagingException("Message failed RFC-2822 validation: No Sender");
                        }
                        originalFlowFilesList.add(originalFlowFile);
                        if (!parser.hasAttachments()) break block13;
                        String originalFlowFileName = originalFlowFile.getAttribute(CoreAttributes.FILENAME.key());
                        try {
                            for (final DataSource data : parser.getAttachmentList()) {
                                FlowFile split = session.create(originalFlowFile);
                                HashMap<String, String> attributes = new HashMap<String, String>();
                                if (StringUtils.isNotBlank((CharSequence)data.getName())) {
                                    attributes.put(CoreAttributes.FILENAME.key(), data.getName());
                                }
                                if (StringUtils.isNotBlank((CharSequence)data.getContentType())) {
                                    attributes.put(CoreAttributes.MIME_TYPE.key(), data.getContentType());
                                }
                                String parentUuid = originalFlowFile.getAttribute(CoreAttributes.UUID.key());
                                attributes.put(ExtractEmailAttachments.ATTACHMENT_ORIGINAL_UUID, parentUuid);
                                attributes.put(ExtractEmailAttachments.ATTACHMENT_ORIGINAL_FILENAME, originalFlowFileName);
                                split = session.append(split, new OutputStreamCallback(){

                                    public void process(OutputStream out) throws IOException {
                                        IOUtils.copy((InputStream)data.getInputStream(), (OutputStream)out);
                                    }
                                });
                                split = session.putAllAttributes(split, attributes);
                                attachmentsList.add(split);
                            }
                        }
                        catch (FlowFileHandlingException e) {
                            session.remove((Collection)attachmentsList);
                            originalFlowFilesList.remove(originalFlowFile);
                            logger.error("Flowfile {} triggered error {} while processing message removing generated FlowFiles from sessions", new Object[]{originalFlowFile, e});
                            invalidFlowFilesList.add(originalFlowFile);
                        }
                    }
                    catch (Exception e) {
                        originalFlowFilesList.remove(originalFlowFile);
                        logger.error("Could not parse the flowfile {} as an email, treating as failure", new Object[]{originalFlowFile, e});
                        invalidFlowFilesList.add(originalFlowFile);
                    }
                }
            }
        });
        session.transfer(attachmentsList, REL_ATTACHMENTS);
        session.transfer(invalidFlowFilesList, REL_FAILURE);
        session.transfer(originalFlowFilesList, REL_ORIGINAL);
        if (attachmentsList.size() > 10) {
            logger.info("Split {} into {} files", new Object[]{originalFlowFile, attachmentsList.size()});
        } else if (attachmentsList.size() > 1) {
            logger.info("Split {} into {} files: {}", new Object[]{originalFlowFile, attachmentsList.size(), attachmentsList});
        }
    }

    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    public final List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.descriptors;
    }
}

