/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.elasticsearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.elasticsearch.ElasticSearchClientService;
import org.apache.nifi.elasticsearch.ElasticsearchException;
import org.apache.nifi.elasticsearch.SearchResponse;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.elasticsearch.ElasticsearchRestProcessor;
import org.apache.nifi.processors.elasticsearch.api.JsonQueryParameters;
import org.apache.nifi.util.StopWatch;
import org.apache.nifi.util.StringUtils;

public abstract class AbstractJsonQueryElasticsearch<Q extends JsonQueryParameters>
extends AbstractProcessor
implements ElasticsearchRestProcessor {
    public static final Relationship REL_ORIGINAL = new Relationship.Builder().name("original").description("All original flowfiles that don't cause an error to occur go to this relationship.").build();
    public static final Relationship REL_HITS = new Relationship.Builder().name("hits").description("Search hits are routed to this relationship.").build();
    public static final Relationship REL_AGGREGATIONS = new Relationship.Builder().name("aggregations").description("Aggregations are routed to this relationship.").build();
    public static final AllowableValue FLOWFILE_PER_HIT = new AllowableValue("splitUp-yes", "Per Hit", "Flowfile per hit.");
    public static final AllowableValue FLOWFILE_PER_RESPONSE = new AllowableValue("splitUp-no", "Per Response", "Flowfile per response.");
    public static final PropertyDescriptor SEARCH_RESULTS_SPLIT = new PropertyDescriptor.Builder().name("el-rest-split-up-hits").displayName("Search Results Split").description("Output a flowfile containing all hits or one flowfile for each individual hit.").allowableValues(new AllowableValue[]{FLOWFILE_PER_RESPONSE, FLOWFILE_PER_HIT}).defaultValue(FLOWFILE_PER_RESPONSE.getValue()).required(true).expressionLanguageSupported(ExpressionLanguageScope.NONE).build();
    public static final PropertyDescriptor AGGREGATION_RESULTS_SPLIT = new PropertyDescriptor.Builder().name("el-rest-split-up-aggregations").displayName("Aggregation Results Split").description("Output a flowfile containing all aggregations or one flowfile for each individual aggregation.").allowableValues(new AllowableValue[]{FLOWFILE_PER_RESPONSE, FLOWFILE_PER_HIT}).defaultValue(FLOWFILE_PER_RESPONSE.getValue()).required(true).expressionLanguageSupported(ExpressionLanguageScope.NONE).build();
    public static final PropertyDescriptor OUTPUT_NO_HITS = new PropertyDescriptor.Builder().name("el-rest-output-no-hits").displayName("Output No Hits").description("Output a \"" + REL_HITS.getName() + "\" flowfile even if no hits found for query. If true, an empty \"" + REL_HITS.getName() + "\" flowfile will be output even if \"" + REL_AGGREGATIONS.getName() + "\" are output.").allowableValues(new String[]{"true", "false"}).defaultValue("false").required(true).expressionLanguageSupported(ExpressionLanguageScope.NONE).build();
    private static final Set<Relationship> relationships;
    private static final List<PropertyDescriptor> propertyDescriptors;
    String splitUpHits;
    private String splitUpAggregations;
    private boolean outputNoHits;
    final ObjectMapper mapper = new ObjectMapper();
    final AtomicReference<ElasticSearchClientService> clientService = new AtomicReference<Object>(null);

    boolean getOutputNoHits() {
        return this.outputNoHits;
    }

    public Set<Relationship> getRelationships() {
        return relationships;
    }

    public List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return propertyDescriptors;
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().name(propertyDescriptorName).required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).dynamic(true).build();
    }

    @Override
    public boolean isIndexNotExistSuccessful() {
        return false;
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) {
        this.clientService.set((ElasticSearchClientService)context.getProperty(CLIENT_SERVICE).asControllerService(ElasticSearchClientService.class));
        this.splitUpHits = context.getProperty(SEARCH_RESULTS_SPLIT).getValue();
        this.splitUpAggregations = context.getProperty(AGGREGATION_RESULTS_SPLIT).getValue();
        this.outputNoHits = context.getProperty(OUTPUT_NO_HITS).asBoolean();
    }

    @OnStopped
    public void onStopped() {
        this.clientService.set(null);
    }

    public void onTrigger(ProcessContext context, ProcessSession session) {
        FlowFile input = null;
        if (context.hasIncomingConnection() && (input = session.get()) == null && context.hasNonLoopConnection()) {
            return;
        }
        try {
            Q queryJsonParameters = this.buildJsonQueryParameters(input, context, session);
            ArrayList<FlowFile> hitsFlowFiles = new ArrayList<FlowFile>();
            StopWatch stopWatch = new StopWatch(true);
            SearchResponse response = this.doQuery(queryJsonParameters, hitsFlowFiles, session, context, input, stopWatch);
            this.finishQuery(input, queryJsonParameters, session, context, response);
        }
        catch (ElasticsearchException ese) {
            String msg = String.format("Encountered a server-side problem with Elasticsearch. %s", ese.isElastic() ? "Routing to retry." : "Routing to failure");
            this.getLogger().error(msg, (Throwable)ese);
            if (input != null) {
                session.penalize(input);
                input = session.putAttribute(input, "elasticsearch.query.error", ese.getMessage());
                session.transfer(input, ese.isElastic() ? REL_RETRY : REL_FAILURE);
            }
        }
        catch (Exception ex) {
            this.getLogger().error("Could not query documents.", (Throwable)ex);
            if (input != null) {
                input = session.putAttribute(input, "elasticsearch.query.error", ex.getMessage());
                session.transfer(input, REL_FAILURE);
            }
            context.yield();
        }
    }

    abstract Q buildJsonQueryParameters(FlowFile var1, ProcessContext var2, ProcessSession var3) throws IOException;

    void populateCommonJsonQueryParameters(Q queryJsonParameters, FlowFile input, ProcessContext context, ProcessSession session) throws IOException {
        String query = this.getQuery(input, context, session);
        String index = context.getProperty(INDEX).evaluateAttributeExpressions(input).getValue();
        String type = context.getProperty(TYPE).evaluateAttributeExpressions(input).getValue();
        String queryAttr = context.getProperty(QUERY_ATTRIBUTE).isSet() ? context.getProperty(QUERY_ATTRIBUTE).evaluateAttributeExpressions(input).getValue() : null;
        ((JsonQueryParameters)queryJsonParameters).setQuery(query);
        ((JsonQueryParameters)queryJsonParameters).setIndex(index);
        ((JsonQueryParameters)queryJsonParameters).setType(type);
        ((JsonQueryParameters)queryJsonParameters).setQueryAttr(queryAttr);
    }

    abstract SearchResponse doQuery(Q var1, List<FlowFile> var2, ProcessSession var3, ProcessContext var4, FlowFile var5, StopWatch var6) throws IOException;

    abstract void finishQuery(FlowFile var1, Q var2, ProcessSession var3, ProcessContext var4, SearchResponse var5) throws IOException;

    FlowFile createChildFlowFile(ProcessSession session, FlowFile parent) {
        return parent != null ? session.create(parent) : session.create();
    }

    private FlowFile writeAggregationFlowFileContents(final String name, final Integer number, String json, ProcessSession session, FlowFile aggFlowFile, Map<String, String> attributes) {
        FlowFile ff = session.write(aggFlowFile, out -> out.write(json.getBytes()));
        ff = session.putAllAttributes(ff, (Map)new HashMap<String, String>(){
            {
                if (name != null) {
                    this.put("aggregation.name", name);
                }
                if (number != null) {
                    this.put("aggregation.number", number.toString());
                }
            }
        });
        return session.putAllAttributes(ff, attributes);
    }

    private void handleAggregations(Map<String, Object> aggregations, ProcessSession session, FlowFile parent, Map<String, String> attributes, String transitUri, StopWatch stopWatch) throws IOException {
        if (aggregations != null && !aggregations.isEmpty()) {
            ArrayList<FlowFile> aggsFlowFiles = new ArrayList<FlowFile>();
            if (this.splitUpAggregations.equals(FLOWFILE_PER_HIT.getValue())) {
                int aggCount = 0;
                for (Map.Entry<String, Object> agg : aggregations.entrySet()) {
                    FlowFile aggFlowFile = this.createChildFlowFile(session, parent);
                    String aggJson = this.mapper.writeValueAsString(agg.getValue());
                    aggsFlowFiles.add(this.writeAggregationFlowFileContents(agg.getKey(), ++aggCount, aggJson, session, aggFlowFile, attributes));
                }
            } else {
                FlowFile aggFlowFile = this.createChildFlowFile(session, parent);
                String json = this.mapper.writeValueAsString(aggregations);
                aggsFlowFiles.add(this.writeAggregationFlowFileContents(null, null, json, session, aggFlowFile, attributes));
            }
            if (!aggsFlowFiles.isEmpty()) {
                session.transfer(aggsFlowFiles, REL_AGGREGATIONS);
                aggsFlowFiles.forEach(ff -> session.getProvenanceReporter().receive(ff, transitUri, stopWatch.getElapsed(TimeUnit.MILLISECONDS)));
            }
        }
    }

    FlowFile writeHitFlowFile(int count, String json, ProcessSession session, FlowFile hitFlowFile, Map<String, String> attributes) {
        FlowFile ff = session.write(hitFlowFile, out -> out.write(json.getBytes()));
        attributes.put("hit.count", Integer.toString(count));
        return session.putAllAttributes(ff, attributes);
    }

    List<FlowFile> handleHits(List<Map<String, Object>> hits, boolean newQuery, Q queryJsonParameters, ProcessSession session, FlowFile parent, Map<String, String> attributes, List<FlowFile> hitsFlowFiles, String transitUri, StopWatch stopWatch) throws IOException {
        if (hits != null && !hits.isEmpty()) {
            if (FLOWFILE_PER_HIT.getValue().equals(this.splitUpHits)) {
                for (Map<String, Object> hit : hits) {
                    FlowFile hitFlowFile = this.createChildFlowFile(session, parent);
                    String json = this.mapper.writeValueAsString(hit);
                    hitsFlowFiles.add(this.writeHitFlowFile(1, json, session, hitFlowFile, attributes));
                }
            } else {
                FlowFile hitFlowFile = this.createChildFlowFile(session, parent);
                String json = this.mapper.writeValueAsString(hits);
                hitsFlowFiles.add(this.writeHitFlowFile(hits.size(), json, session, hitFlowFile, attributes));
            }
        } else if (newQuery && this.outputNoHits) {
            FlowFile hitFlowFile = this.createChildFlowFile(session, parent);
            hitsFlowFiles.add(this.writeHitFlowFile(0, "", session, hitFlowFile, attributes));
        }
        this.transferResultFlowFiles(session, hitsFlowFiles, transitUri, stopWatch);
        return hitsFlowFiles;
    }

    private void transferResultFlowFiles(ProcessSession session, List<FlowFile> hitsFlowFiles, String transitUri, StopWatch stopWatch) {
        if (!hitsFlowFiles.isEmpty()) {
            session.transfer(hitsFlowFiles, REL_HITS);
            hitsFlowFiles.forEach(ff -> session.getProvenanceReporter().receive(ff, transitUri, stopWatch.getElapsed(TimeUnit.MILLISECONDS)));
            hitsFlowFiles.clear();
        }
    }

    List<FlowFile> handleResponse(SearchResponse response, boolean newQuery, Q queryJsonParameters, List<FlowFile> hitsFlowFiles, ProcessSession session, FlowFile input, StopWatch stopWatch) throws IOException {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put(CoreAttributes.MIME_TYPE.key(), "application/json");
        if (StringUtils.isNotBlank((String)((JsonQueryParameters)queryJsonParameters).getQueryAttr())) {
            attributes.put(((JsonQueryParameters)queryJsonParameters).getQueryAttr(), ((JsonQueryParameters)queryJsonParameters).getQuery());
        }
        String transitUri = this.clientService.get().getTransitUrl(((JsonQueryParameters)queryJsonParameters).getIndex(), ((JsonQueryParameters)queryJsonParameters).getType());
        if (newQuery) {
            this.handleAggregations(response.getAggregations(), session, input, attributes, transitUri, stopWatch);
        }
        List<FlowFile> resultFlowFiles = this.handleHits(response.getHits(), newQuery, queryJsonParameters, session, input, attributes, hitsFlowFiles, transitUri, stopWatch);
        ((JsonQueryParameters)queryJsonParameters).addHitCount(response.getHits().size());
        return resultFlowFiles;
    }

    static {
        HashSet<Relationship> rels = new HashSet<Relationship>();
        rels.add(REL_ORIGINAL);
        rels.add(REL_FAILURE);
        rels.add(REL_HITS);
        rels.add(REL_AGGREGATIONS);
        relationships = Collections.unmodifiableSet(rels);
        ArrayList<PropertyDescriptor> descriptors = new ArrayList<PropertyDescriptor>();
        descriptors.add(QUERY);
        descriptors.add(QUERY_ATTRIBUTE);
        descriptors.add(INDEX);
        descriptors.add(TYPE);
        descriptors.add(CLIENT_SERVICE);
        descriptors.add(SEARCH_RESULTS_SPLIT);
        descriptors.add(AGGREGATION_RESULTS_SPLIT);
        descriptors.add(OUTPUT_NO_HITS);
        propertyDescriptors = Collections.unmodifiableList(descriptors);
    }
}

