/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.elasticsearch;

import java.util.List;
import java.util.Map;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.Validator;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.VerifiableControllerService;
import org.apache.nifi.elasticsearch.AuthorizationScheme;
import org.apache.nifi.elasticsearch.DeleteOperationResponse;
import org.apache.nifi.elasticsearch.IndexOperationRequest;
import org.apache.nifi.elasticsearch.IndexOperationResponse;
import org.apache.nifi.elasticsearch.SearchResponse;
import org.apache.nifi.elasticsearch.UpdateOperationResponse;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.proxy.ProxyConfiguration;
import org.apache.nifi.proxy.ProxySpec;
import org.apache.nifi.ssl.SSLContextService;

public interface ElasticSearchClientService
extends ControllerService,
VerifiableControllerService {
    public static final PropertyDescriptor HTTP_HOSTS = new PropertyDescriptor.Builder().name("el-cs-http-hosts").displayName("HTTP Hosts").description("A comma-separated list of HTTP hosts that host Elasticsearch query nodes. Note that the Host is included in requests as a header (typically including domain and port, e.g. elasticsearch:9200).").required(true).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor PROP_SSL_CONTEXT_SERVICE = new PropertyDescriptor.Builder().name("el-cs-ssl-context-service").displayName("SSL Context Service").description("The SSL Context Service used to provide client certificate information for TLS/SSL connections. This service only applies if the Elasticsearch endpoint(s) have been secured with TLS/SSL.").required(false).identifiesControllerService(SSLContextService.class).addValidator(Validator.VALID).build();
    public static final PropertyDescriptor PROXY_CONFIGURATION_SERVICE = ProxyConfiguration.createProxyConfigPropertyDescriptor((boolean)false, (ProxySpec[])new ProxySpec[]{ProxySpec.HTTP});
    public static final PropertyDescriptor AUTHORIZATION_SCHEME = new PropertyDescriptor.Builder().name("authorization-scheme").displayName("Authorization Scheme").description("Authorization Scheme used for optional authentication to Elasticsearch.").allowableValues(AuthorizationScheme.class).defaultValue(AuthorizationScheme.BASIC.getValue()).required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor USERNAME = new PropertyDescriptor.Builder().name("el-cs-username").displayName("Username").description("The username to use with XPack security.").dependsOn(AUTHORIZATION_SCHEME, (DescribedValue)AuthorizationScheme.BASIC, new DescribedValue[0]).required(false).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor PASSWORD = new PropertyDescriptor.Builder().name("el-cs-password").displayName("Password").description("The password to use with XPack security.").dependsOn(AUTHORIZATION_SCHEME, (DescribedValue)AuthorizationScheme.BASIC, new DescribedValue[0]).required(false).sensitive(true).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor API_KEY_ID = new PropertyDescriptor.Builder().name("api-key-id").displayName("API Key ID").description("Unique identifier of the API key.").dependsOn(AUTHORIZATION_SCHEME, (DescribedValue)AuthorizationScheme.API_KEY, new DescribedValue[0]).required(false).sensitive(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor API_KEY = new PropertyDescriptor.Builder().name("api-key").displayName("API Key").description("Encoded API key.").dependsOn(AUTHORIZATION_SCHEME, (DescribedValue)AuthorizationScheme.API_KEY, new DescribedValue[0]).required(false).sensitive(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor CONNECT_TIMEOUT = new PropertyDescriptor.Builder().name("el-cs-connect-timeout").displayName("Connect timeout").description("Controls the amount of time, in milliseconds, before a timeout occurs when trying to connect.").required(true).defaultValue("5000").addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).build();
    public static final PropertyDescriptor SOCKET_TIMEOUT = new PropertyDescriptor.Builder().name("el-cs-socket-timeout").displayName("Read timeout").description("Controls the amount of time, in milliseconds, before a timeout occurs when waiting for a response.").required(true).defaultValue("60000").addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).build();
    @Deprecated
    public static final PropertyDescriptor RETRY_TIMEOUT = new PropertyDescriptor.Builder().name("el-cs-retry-timeout").displayName("Retry timeout").description("Controls the amount of time, in milliseconds, before a timeout occurs when retrying the operation.").required(true).defaultValue("60000").addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).build();
    public static final PropertyDescriptor CHARSET = new PropertyDescriptor.Builder().name("el-cs-charset").displayName("Charset").description("The charset to use for interpreting the response from Elasticsearch.").required(true).defaultValue("UTF-8").addValidator(StandardValidators.NON_BLANK_VALIDATOR).build();
    public static final AllowableValue ALWAYS_SUPPRESS = new AllowableValue("always-suppress", "Always Suppress", "Fields that are missing (present in the schema but not in the record), or that have a value of null/empty, will not be written out");
    public static final AllowableValue NEVER_SUPPRESS = new AllowableValue("never-suppress", "Never Suppress", "Fields that are missing (present in the schema but not in the record), or that have a value of null/empty, will be written out as a null/empty value");
    public static final PropertyDescriptor SUPPRESS_NULLS = new PropertyDescriptor.Builder().name("el-cs-suppress-nulls").displayName("Suppress Null/Empty Values").description("Specifies how the writer should handle null and empty fields (including objects and arrays)").allowableValues(new AllowableValue[]{NEVER_SUPPRESS, ALWAYS_SUPPRESS}).defaultValue(ALWAYS_SUPPRESS.getValue()).required(true).build();
    public static final PropertyDescriptor COMPRESSION = new PropertyDescriptor.Builder().name("el-cs-enable-compression").displayName("Enable Compression").description("Whether the REST client should compress requests using gzip content encoding and add the \"Accept-Encoding: gzip\" header to receive compressed responses").allowableValues(new String[]{"true", "false"}).defaultValue("false").required(true).build();
    public static final PropertyDescriptor SEND_META_HEADER = new PropertyDescriptor.Builder().name("el-cs-send-meta-header").displayName("Send Meta Header").description("Whether to send a \"X-Elastic-Client-Meta\" header that describes the runtime environment. It contains information that is similar to what could be found in User-Agent. Using a separate header allows applications to use User-Agent for their own needs, e.g. to identify application version or other environment information").allowableValues(new String[]{"true", "false"}).defaultValue("true").required(true).build();
    public static final PropertyDescriptor STRICT_DEPRECATION = new PropertyDescriptor.Builder().name("el-cs-strict-deprecation").displayName("Strict Deprecation").description("Whether the REST client should return any response containing at least one warning header as a failure").allowableValues(new String[]{"true", "false"}).defaultValue("false").required(true).build();
    public static final AllowableValue NODE_SELECTOR_ANY = new AllowableValue("ANY", "Any", "Select any Elasticsearch node to handle requests");
    public static final AllowableValue NODE_SELECTOR_SKIP_DEDICATED_MASTERS = new AllowableValue("SKIP_DEDICATED_MASTERS", "Skip Dedicated Masters", "Skip dedicated Elasticsearch master nodes for handling request");
    public static final PropertyDescriptor NODE_SELECTOR = new PropertyDescriptor.Builder().name("el-cs-node-selector").displayName("Node Selector").description("Selects Elasticsearch nodes that can receive requests. Used to keep requests away from dedicated Elasticsearch master nodes").allowableValues(new AllowableValue[]{NODE_SELECTOR_ANY, NODE_SELECTOR_SKIP_DEDICATED_MASTERS}).defaultValue(NODE_SELECTOR_ANY.getValue()).required(true).build();
    public static final PropertyDescriptor PATH_PREFIX = new PropertyDescriptor.Builder().name("el-cs-path-prefix").displayName("Path Prefix").description("Sets the path's prefix for every request used by the http client. For example, if this is set to \"/my/path\", then any client request will become \"/my/path/\" + endpoint. In essence, every request's endpoint is prefixed by this pathPrefix. The path prefix is useful for when Elasticsearch is behind a proxy that provides a base path or a proxy that requires all paths to start with '/'; it is not intended for other purposes and it should not be supplied in other scenarios").addValidator(StandardValidators.NON_BLANK_VALIDATOR).build();
    public static final PropertyDescriptor SNIFF_CLUSTER_NODES = new PropertyDescriptor.Builder().name("el-cs-sniff-cluster-nodes").displayName("Sniff Cluster Nodes").description("Periodically sniff for nodes within the Elasticsearch cluster via the Elasticsearch Node Info API. If Elasticsearch security features are enabled (default to \"true\" for 8.x+), the Elasticsearch user must have the \"monitor\" or \"manage\" cluster privilege to use this API.Note that all " + HTTP_HOSTS.getDisplayName() + " (and those that may be discovered within the cluster using the Sniffer) must use the same protocol, e.g. http or https, and be contactable using the same client settings. Finally the Elasticsearch \"network.publish_host\" must match one of the \"network.bind_host\" list entries see https://www.elastic.co/guide/en/elasticsearch/reference/current/modules-network.html for more information").allowableValues(new String[]{"true", "false"}).defaultValue("false").required(true).build();
    public static final PropertyDescriptor SNIFF_ON_FAILURE = new PropertyDescriptor.Builder().name("el-cs-sniff-failure").displayName("Sniff on Failure").description("Enable sniffing on failure, meaning that after each failure the Elasticsearch nodes list gets updated straightaway rather than at the following ordinary sniffing round").dependsOn(SNIFF_CLUSTER_NODES, "true", new String[0]).allowableValues(new String[]{"true", "false"}).defaultValue("false").required(true).build();
    public static final PropertyDescriptor SNIFFER_INTERVAL = new PropertyDescriptor.Builder().name("el-cs-sniffer-interval").displayName("Sniffer Interval").description("Interval between Cluster sniffer operations").dependsOn(SNIFF_CLUSTER_NODES, "true", new String[0]).defaultValue("5 mins").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).required(true).build();
    public static final PropertyDescriptor SNIFFER_REQUEST_TIMEOUT = new PropertyDescriptor.Builder().name("el-cs-sniffer-request-timeout").displayName("Sniffer Request Timeout").description("Cluster sniffer timeout for node info requests").dependsOn(SNIFF_CLUSTER_NODES, "true", new String[0]).defaultValue("1 sec").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).required(true).build();
    public static final PropertyDescriptor SNIFFER_FAILURE_DELAY = new PropertyDescriptor.Builder().name("el-cs-sniffer-failure-delay").displayName("Sniffer Failure Delay").description("Delay between an Elasticsearch request failure and updating available Cluster nodes using the Sniffer").dependsOn(SNIFF_ON_FAILURE, "true", new String[0]).defaultValue("1 min").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).required(true).build();

    public IndexOperationResponse add(IndexOperationRequest var1, Map<String, String> var2);

    public IndexOperationResponse bulk(List<IndexOperationRequest> var1, Map<String, String> var2);

    public Long count(String var1, String var2, String var3, Map<String, String> var4);

    public DeleteOperationResponse deleteById(String var1, String var2, String var3, Map<String, String> var4);

    public DeleteOperationResponse deleteById(String var1, String var2, List<String> var3, Map<String, String> var4);

    public DeleteOperationResponse deleteByQuery(String var1, String var2, String var3, Map<String, String> var4);

    public UpdateOperationResponse updateByQuery(String var1, String var2, String var3, Map<String, String> var4);

    public void refresh(String var1, Map<String, String> var2);

    public boolean exists(String var1, Map<String, String> var2);

    public boolean documentExists(String var1, String var2, String var3, Map<String, String> var4);

    public Map<String, Object> get(String var1, String var2, String var3, Map<String, String> var4);

    public SearchResponse search(String var1, String var2, String var3, Map<String, String> var4);

    public SearchResponse scroll(String var1);

    public String initialisePointInTime(String var1, String var2);

    public DeleteOperationResponse deletePointInTime(String var1);

    public DeleteOperationResponse deleteScroll(String var1);

    public String getTransitUrl(String var1, String var2);
}

