/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.elasticsearch;

import java.util.List;
import java.util.Map;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.Validator;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.VerifiableControllerService;
import org.apache.nifi.elasticsearch.AuthorizationScheme;
import org.apache.nifi.elasticsearch.DeleteOperationResponse;
import org.apache.nifi.elasticsearch.IndexOperationRequest;
import org.apache.nifi.elasticsearch.IndexOperationResponse;
import org.apache.nifi.elasticsearch.SearchResponse;
import org.apache.nifi.elasticsearch.UpdateOperationResponse;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.proxy.ProxyConfiguration;
import org.apache.nifi.proxy.ProxySpec;
import org.apache.nifi.ssl.SSLContextService;

@Tags(value={"elasticsearch", "client"})
@CapabilityDescription(value="A controller service for accessing an Elasticsearch client.")
public interface ElasticSearchClientService
extends ControllerService,
VerifiableControllerService {
    public static final PropertyDescriptor HTTP_HOSTS = new PropertyDescriptor.Builder().name("el-cs-http-hosts").displayName("HTTP Hosts").description("A comma-separated list of HTTP hosts that host Elasticsearch query nodes.").required(true).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor PROP_SSL_CONTEXT_SERVICE = new PropertyDescriptor.Builder().name("el-cs-ssl-context-service").displayName("SSL Context Service").description("The SSL Context Service used to provide client certificate information for TLS/SSL connections. This service only applies if the Elasticsearch endpoint(s) have been secured with TLS/SSL.").required(false).identifiesControllerService(SSLContextService.class).addValidator(Validator.VALID).build();
    public static final PropertyDescriptor PROXY_CONFIGURATION_SERVICE = ProxyConfiguration.createProxyConfigPropertyDescriptor((boolean)false, (ProxySpec[])new ProxySpec[]{ProxySpec.HTTP});
    public static final PropertyDescriptor AUTHORIZATION_SCHEME = new PropertyDescriptor.Builder().name("authorization-scheme").displayName("Authorization Scheme").description("Authorization Scheme used for optional authentication to Elasticsearch.").allowableValues(AuthorizationScheme.class).defaultValue(AuthorizationScheme.BASIC.getValue()).required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor USERNAME = new PropertyDescriptor.Builder().name("el-cs-username").displayName("Username").description("The username to use with XPack security.").dependsOn(AUTHORIZATION_SCHEME, (DescribedValue)AuthorizationScheme.BASIC, new DescribedValue[0]).required(false).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor PASSWORD = new PropertyDescriptor.Builder().name("el-cs-password").displayName("Password").description("The password to use with XPack security.").dependsOn(AUTHORIZATION_SCHEME, (DescribedValue)AuthorizationScheme.BASIC, new DescribedValue[0]).required(false).sensitive(true).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor API_KEY_ID = new PropertyDescriptor.Builder().name("api-key-id").displayName("API Key ID").description("Unique identifier of the API key.").dependsOn(AUTHORIZATION_SCHEME, (DescribedValue)AuthorizationScheme.API_KEY, new DescribedValue[0]).required(false).sensitive(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor API_KEY = new PropertyDescriptor.Builder().name("api-key").displayName("API Key").description("Encoded API key.").dependsOn(AUTHORIZATION_SCHEME, (DescribedValue)AuthorizationScheme.API_KEY, new DescribedValue[0]).required(false).sensitive(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor CONNECT_TIMEOUT = new PropertyDescriptor.Builder().name("el-cs-connect-timeout").displayName("Connect timeout").description("Controls the amount of time, in milliseconds, before a timeout occurs when trying to connect.").required(true).defaultValue("5000").addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).build();
    public static final PropertyDescriptor SOCKET_TIMEOUT = new PropertyDescriptor.Builder().name("el-cs-socket-timeout").displayName("Read timeout").description("Controls the amount of time, in milliseconds, before a timeout occurs when waiting for a response.").required(true).defaultValue("60000").addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).build();
    @Deprecated
    public static final PropertyDescriptor RETRY_TIMEOUT = new PropertyDescriptor.Builder().name("el-cs-retry-timeout").displayName("Retry timeout").description("Controls the amount of time, in milliseconds, before a timeout occurs when retrying the operation.").required(true).defaultValue("60000").addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).build();
    public static final PropertyDescriptor CHARSET = new PropertyDescriptor.Builder().name("el-cs-charset").displayName("Charset").description("The charset to use for interpreting the response from Elasticsearch.").required(true).defaultValue("UTF-8").addValidator(StandardValidators.NON_BLANK_VALIDATOR).build();
    public static final AllowableValue ALWAYS_SUPPRESS = new AllowableValue("always-suppress", "Always Suppress", "Fields that are missing (present in the schema but not in the record), or that have a value of null/empty, will not be written out");
    public static final AllowableValue NEVER_SUPPRESS = new AllowableValue("never-suppress", "Never Suppress", "Fields that are missing (present in the schema but not in the record), or that have a value of null/empty, will be written out as a null/empty value");
    public static final PropertyDescriptor SUPPRESS_NULLS = new PropertyDescriptor.Builder().name("el-cs-suppress-nulls").displayName("Suppress Null/Empty Values").description("Specifies how the writer should handle null and empty fields (including objects and arrays)").allowableValues(new AllowableValue[]{NEVER_SUPPRESS, ALWAYS_SUPPRESS}).defaultValue(ALWAYS_SUPPRESS.getValue()).required(true).build();

    public IndexOperationResponse add(IndexOperationRequest var1, Map<String, String> var2);

    public IndexOperationResponse bulk(List<IndexOperationRequest> var1, Map<String, String> var2);

    public Long count(String var1, String var2, String var3, Map<String, String> var4);

    public DeleteOperationResponse deleteById(String var1, String var2, String var3, Map<String, String> var4);

    public DeleteOperationResponse deleteById(String var1, String var2, List<String> var3, Map<String, String> var4);

    public DeleteOperationResponse deleteByQuery(String var1, String var2, String var3, Map<String, String> var4);

    public UpdateOperationResponse updateByQuery(String var1, String var2, String var3, Map<String, String> var4);

    public void refresh(String var1, Map<String, String> var2);

    public boolean exists(String var1, Map<String, String> var2);

    public Map<String, Object> get(String var1, String var2, String var3, Map<String, String> var4);

    public SearchResponse search(String var1, String var2, String var3, Map<String, String> var4);

    public SearchResponse scroll(String var1);

    public String initialisePointInTime(String var1, String var2);

    public DeleteOperationResponse deletePointInTime(String var1);

    public DeleteOperationResponse deleteScroll(String var1);

    public String getTransitUrl(String var1, String var2);
}

