/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.kafka.pubsub;

import java.io.Closeable;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.nifi.components.ConfigVerificationResult;
import org.apache.nifi.kafka.shared.property.PublishStrategy;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processors.kafka.pubsub.PublisherLease;
import org.apache.nifi.serialization.RecordSetWriterFactory;

public class PublisherPool
implements Closeable {
    private final ComponentLog logger;
    private final BlockingQueue<PublisherLease> publisherQueue;
    private final Map<String, Object> kafkaProperties;
    private final int maxMessageSize;
    private final long maxAckWaitMillis;
    private final boolean useTransactions;
    private final Pattern attributeNameRegex;
    private final Charset headerCharacterSet;
    private final PublishStrategy publishStrategy;
    private final RecordSetWriterFactory recordKeyWriterFactory;
    private Supplier<String> transactionalIdSupplier;
    private volatile boolean closed = false;

    PublisherPool(Map<String, Object> kafkaProperties, ComponentLog logger, int maxMessageSize, long maxAckWaitMillis, boolean useTransactions, Supplier<String> transactionalIdSupplier, Pattern attributeNameRegex, Charset headerCharacterSet, PublishStrategy publishStrategy, RecordSetWriterFactory recordKeyWriterFactory) {
        this.logger = logger;
        this.publisherQueue = new LinkedBlockingQueue<PublisherLease>();
        this.kafkaProperties = kafkaProperties;
        this.maxMessageSize = maxMessageSize;
        this.maxAckWaitMillis = maxAckWaitMillis;
        this.useTransactions = useTransactions;
        this.attributeNameRegex = attributeNameRegex;
        this.headerCharacterSet = headerCharacterSet;
        this.publishStrategy = publishStrategy;
        this.recordKeyWriterFactory = recordKeyWriterFactory;
        this.transactionalIdSupplier = transactionalIdSupplier;
    }

    public PublisherLease obtainPublisher() {
        if (this.isClosed()) {
            throw new IllegalStateException("Connection Pool is closed");
        }
        PublisherLease lease = (PublisherLease)this.publisherQueue.poll();
        if (lease != null) {
            return lease;
        }
        lease = this.createLease();
        return lease;
    }

    private PublisherLease createLease() {
        HashMap<String, Object> properties = new HashMap<String, Object>(this.kafkaProperties);
        if (this.useTransactions) {
            properties.put("transactional.id", this.transactionalIdSupplier.get());
        }
        KafkaProducer producer = new KafkaProducer(properties);
        PublisherLease lease = new PublisherLease((Producer)producer, this.maxMessageSize, this.maxAckWaitMillis, this.logger, this.useTransactions, this.attributeNameRegex, this.headerCharacterSet, this.publishStrategy, this.recordKeyWriterFactory, (Producer)producer){
            private volatile boolean closed;
            final /* synthetic */ Producer val$producer;
            {
                this.val$producer = producer2;
                super((Producer<byte[], byte[]>)producer, maxMessageSize, maxAckWaitMillis, logger, useTransactions, attributeNameRegex, headerCharacterSet, publishStrategy, recordKeyWriterFactory);
                this.closed = false;
            }

            @Override
            public void close() {
                if (this.isPoisoned() && PublisherPool.this.useTransactions && !this.closed) {
                    try {
                        this.val$producer.abortTransaction();
                    }
                    catch (Exception e) {
                        PublisherPool.this.logger.error("Failed to abort producer transaction", (Throwable)e);
                    }
                }
                if (this.isPoisoned() || PublisherPool.this.isClosed()) {
                    if (this.closed) {
                        return;
                    }
                    this.closed = true;
                    super.close();
                } else {
                    PublisherPool.this.publisherQueue.offer(this);
                }
            }
        };
        return lease;
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    @Override
    public synchronized void close() {
        PublisherLease lease;
        this.closed = true;
        while ((lease = (PublisherLease)this.publisherQueue.poll()) != null) {
            lease.close();
        }
    }

    protected int available() {
        return this.publisherQueue.size();
    }

    public List<ConfigVerificationResult> verifyConfiguration(String topic) {
        try (PublisherLease lease = this.obtainPublisher();){
            List<ConfigVerificationResult> list = lease.verifyConfiguration(topic);
            return list;
        }
    }
}

