/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.hive;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.FireEventRequest;
import org.apache.hadoop.hive.metastore.api.FireEventRequestData;
import org.apache.hadoop.hive.metastore.api.InsertEventRequestData;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.messaging.EventMessage;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.utils.StringUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.DeprecationNotice;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.resource.ResourceCardinality;
import org.apache.nifi.components.resource.ResourceType;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.hadoop.SecurityUtil;
import org.apache.nifi.kerberos.KerberosUserService;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.security.krb.KerberosLoginException;
import org.apache.nifi.security.krb.KerberosUser;
import org.apache.nifi.util.hive.AuthenticationFailedException;
import org.apache.nifi.util.hive.HiveConfigurator;
import org.apache.nifi.util.hive.ValidationResources;
import org.apache.thrift.TException;

@DeprecationNotice(reason="Support for Apache Hive 3 is deprecated for removal in Apache NiFi 2.0")
@Tags(value={"hive", "metastore", "notification", "insert", "delete", "partition", "event"})
@CapabilityDescription(value="The processor is capable to trigger different type of events in the HiveMetaStore and generate notifications. The metastore action to be executed is determined from the incoming path and event type attributes. The supported event type values are 'put' in case of data insertion or 'delete' in case of data removal. The notifications should be enabled in the metastore configuration to generate them e.g.: the 'hive.metastore.transactional.event.listeners' should have a proper listener configured, for instance 'org.apache.hive.hcatalog.listener.DbNotificationListener'.")
@WritesAttributes(value={@WritesAttribute(attribute="metastore.notification.event", description="The event type of the triggered notification.")})
public class TriggerHiveMetaStoreEvent
extends AbstractProcessor {
    public static final String METASTORE_NOTIFICATION_EVENT = "metastore.notification.event";
    private final HiveConfigurator hiveConfigurator = new HiveConfigurator();
    private Configuration hiveConfig;
    private final AtomicReference<KerberosUser> kerberosUserReference = new AtomicReference();
    private volatile UserGroupInformation ugi;
    private final AtomicReference<ValidationResources> validationResourceHolder = new AtomicReference();
    static final PropertyDescriptor METASTORE_URI = new PropertyDescriptor.Builder().name("hive-metastore-uri").displayName("Hive Metastore URI").description("The URI location(s) for the Hive metastore. This is a comma-separated list of Hive metastore URIs; note that this is not the location of the Hive Server. The default port for the Hive metastore is 9043. If this field is not set, then the 'hive.metastore.uris' property from any provided configuration resources will be used, and if none are provided, then the default value from a default hive-site.xml will be used (usually thrift://localhost:9083).").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.URI_LIST_VALIDATOR).build();
    static final PropertyDescriptor HIVE_CONFIGURATION_RESOURCES = new PropertyDescriptor.Builder().name("hive-config-resources").displayName("Hive Configuration Resources").description("A file or comma separated list of files which contains the Hive configuration (hive-site.xml, e.g.). Without this, Hadoop will search the classpath for a 'hive-site.xml' file or will revert to a default configuration. Note that to enable authentication with Kerberos e.g., the appropriate properties must be set in the configuration files. Please see the Hive documentation for more details.").identifiesExternalResource(ResourceCardinality.MULTIPLE, ResourceType.FILE, new ResourceType[0]).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    static final PropertyDescriptor EVENT_TYPE = new PropertyDescriptor.Builder().name("event-type").displayName("Event Type").description("The type of the event. The acceptable values are 'put' in case of data insert or 'delete' in case of data removal.").required(true).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).defaultValue("${event.type}").build();
    static final PropertyDescriptor PATH = new PropertyDescriptor.Builder().name("path").displayName("Path").description("The path of the file or folder located in the file system.").required(true).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).defaultValue("${path}").build();
    static final PropertyDescriptor CATALOG_NAME = new PropertyDescriptor.Builder().name("catalog-name").displayName("Catalog Name").description("The name of the catalog.").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_BLANK_VALIDATOR).build();
    static final PropertyDescriptor DATABASE_NAME = new PropertyDescriptor.Builder().name("database-name").displayName("Database Name").description("The name of the database.").required(true).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    static final PropertyDescriptor TABLE_NAME = new PropertyDescriptor.Builder().name("table-name").displayName("Table Name").description("The name of the table.").required(true).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    static final PropertyDescriptor KERBEROS_USER_SERVICE = new PropertyDescriptor.Builder().name("kerberos-user-service").displayName("Kerberos User Service").description("Specifies the Kerberos User Controller Service that should be used for authenticating with Kerberos.").identifiesControllerService(KerberosUserService.class).build();
    static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("A FlowFile is routed to this relationship after the data ingestion was successful.").build();
    static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("A FlowFile is routed to this relationship if the data ingestion failed and retrying the operation will also fail, such as an invalid data or schema.").build();
    private static final List<PropertyDescriptor> PROPERTIES = Collections.unmodifiableList(Arrays.asList(METASTORE_URI, HIVE_CONFIGURATION_RESOURCES, EVENT_TYPE, PATH, CATALOG_NAME, DATABASE_NAME, TABLE_NAME, KERBEROS_USER_SERVICE));
    public static final Set<Relationship> RELATIONSHIPS = Collections.unmodifiableSet(new HashSet<Relationship>(Arrays.asList(REL_SUCCESS, REL_FAILURE)));

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTIES;
    }

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        ArrayList<ValidationResult> problems = new ArrayList<ValidationResult>();
        boolean confFileProvided = validationContext.getProperty(HIVE_CONFIGURATION_RESOURCES).isSet();
        if (confFileProvided) {
            boolean kerberosUserServiceIsSet = validationContext.getProperty(KERBEROS_USER_SERVICE).isSet();
            String configFiles = validationContext.getProperty(HIVE_CONFIGURATION_RESOURCES).evaluateAttributeExpressions().getValue();
            Configuration config = this.hiveConfigurator.getConfigurationForValidation(this.validationResourceHolder, configFiles, this.getLogger());
            boolean securityEnabled = SecurityUtil.isSecurityEnabled((Configuration)config);
            if (securityEnabled && !kerberosUserServiceIsSet) {
                problems.add(new ValidationResult.Builder().subject(KERBEROS_USER_SERVICE.getDisplayName()).valid(false).explanation("Security authentication is set to 'kerberos' in the configuration files but no KerberosUserService is configured.").build());
            }
        }
        return problems;
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) {
        KerberosUserService kerberosUserService;
        String configFiles = context.getProperty(HIVE_CONFIGURATION_RESOURCES).evaluateAttributeExpressions().getValue();
        this.hiveConfig = this.hiveConfigurator.getConfigurationFromFiles(configFiles);
        if (context.getProperty(METASTORE_URI).isSet()) {
            this.hiveConfig.set(MetastoreConf.ConfVars.THRIFT_URIS.getHiveName(), context.getProperty(METASTORE_URI).evaluateAttributeExpressions().getValue());
        }
        if ((kerberosUserService = (KerberosUserService)context.getProperty(KERBEROS_USER_SERVICE).asControllerService(KerberosUserService.class)) != null) {
            this.kerberosUserReference.set(kerberosUserService.createKerberosUser());
            try {
                this.ugi = this.hiveConfigurator.authenticate(this.hiveConfig, this.kerberosUserReference.get());
            }
            catch (AuthenticationFailedException e) {
                this.getLogger().error(e.getMessage(), (Throwable)e);
                throw new ProcessException((Throwable)e);
            }
        }
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        KerberosUser kerberosUser = this.kerberosUserReference.get();
        if (kerberosUser == null) {
            this.doOnTrigger(context, session, flowFile);
        } else {
            try {
                this.getUgi().doAs(() -> {
                    this.doOnTrigger(context, session, flowFile);
                    return null;
                });
            }
            catch (Exception e) {
                this.getLogger().error("Privileged action failed with kerberos user " + kerberosUser, (Throwable)e);
                session.transfer(flowFile, REL_FAILURE);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void doOnTrigger(ProcessContext context, ProcessSession session, FlowFile flowFile) throws ProcessException {
        catalogName = context.getProperty(TriggerHiveMetaStoreEvent.CATALOG_NAME).isSet() != false ? context.getProperty(TriggerHiveMetaStoreEvent.CATALOG_NAME).evaluateAttributeExpressions().getValue() : MetaStoreUtils.getDefaultCatalog((Configuration)this.hiveConfig);
        eventType = context.getProperty(TriggerHiveMetaStoreEvent.EVENT_TYPE).evaluateAttributeExpressions(flowFile).getValue();
        databaseName = context.getProperty(TriggerHiveMetaStoreEvent.DATABASE_NAME).evaluateAttributeExpressions(flowFile).getValue();
        tableName = context.getProperty(TriggerHiveMetaStoreEvent.TABLE_NAME).evaluateAttributeExpressions(flowFile).getValue();
        path = context.getProperty(TriggerHiveMetaStoreEvent.PATH).evaluateAttributeExpressions(flowFile).getValue();
        try {
            metaStoreClient = new HiveMetaStoreClient(this.hiveConfig);
            try {
                table = metaStoreClient.getTable(catalogName, databaseName, tableName);
                isPartitioned = table.getPartitionKeys().isEmpty() == false;
                var12_15 = eventType.toLowerCase().trim();
                var13_16 = -1;
                switch (var12_15.hashCode()) {
                    case 111375: {
                        if (!var12_15.equals("put")) break;
                        var13_16 = 0;
                        break;
                    }
                    case -1335458389: {
                        if (!var12_15.equals("delete")) break;
                        var13_16 = 1;
                    }
                }
                switch (var13_16) {
                    case 0: {
                        if (isPartitioned) {
                            eventMessageType = this.handlePartitionedInsert(metaStoreClient, catalogName, databaseName, tableName, path);
                            flowFile = session.putAttribute(flowFile, "metastore.notification.event", eventMessageType.toString());
                            ** break;
lbl27:
                            // 1 sources

                        } else {
                            this.handleFileInsert(metaStoreClient, catalogName, databaseName, tableName, path, null);
                            flowFile = session.putAttribute(flowFile, "metastore.notification.event", EventMessage.EventType.INSERT.toString());
                            ** break;
                        }
lbl31:
                        // 1 sources

                        break;
                    }
                    case 1: {
                        if (isPartitioned) {
                            this.handleDropPartition(metaStoreClient, catalogName, databaseName, tableName, path);
                            flowFile = session.putAttribute(flowFile, "metastore.notification.event", EventMessage.EventType.DROP_PARTITION.toString());
                            ** break;
lbl37:
                            // 1 sources

                        } else {
                            this.getLogger().warn("The target table '{}' is not partitioned. No metastore action was executed.", new Object[]{tableName});
                            ** break;
                        }
lbl40:
                        // 1 sources

                        break;
                    }
                    default: {
                        this.getLogger().error("Unknown event type '{}'", new Object[]{eventType});
                        session.transfer(flowFile, TriggerHiveMetaStoreEvent.REL_FAILURE);
                        return;
                    }
                }
            }
            finally {
                metaStoreClient.close();
            }
        }
        catch (Exception e) {
            this.getLogger().error("Error occurred while metastore event processing", (Throwable)e);
            session.transfer(flowFile, TriggerHiveMetaStoreEvent.REL_FAILURE);
            return;
        }
        session.transfer(flowFile, TriggerHiveMetaStoreEvent.REL_SUCCESS);
    }

    private EventMessage.EventType handlePartitionedInsert(HiveMetaStoreClient metaStoreClient, String catalogName, String databaseName, String tableName, String path) throws TException {
        List<String> partitionValues = this.getPartitionValuesFromPath(path);
        try {
            metaStoreClient.getPartition(databaseName, tableName, partitionValues);
            this.getLogger().debug("Creating file insert for partition with values {}", new Object[]{partitionValues});
            this.handleFileInsert(metaStoreClient, catalogName, databaseName, tableName, path, partitionValues);
            return EventMessage.EventType.INSERT;
        }
        catch (Exception e) {
            if (e instanceof NoSuchObjectException) {
                this.getLogger().debug("Partition with values {} does not exists. Trying to append new partition", new Object[]{partitionValues, e});
                try {
                    metaStoreClient.appendPartition(catalogName, databaseName, tableName, partitionValues);
                    return EventMessage.EventType.ADD_PARTITION;
                }
                catch (TException ex) {
                    throw new TException("Failed to append partition with values " + partitionValues, (Throwable)ex);
                }
            }
            throw new TException("Error occurred during partitioned file insertion with values " + partitionValues, (Throwable)e);
        }
    }

    private List<String> getPartitionValuesFromPath(String path) {
        String[] pathParts = path.split("/");
        ArrayList<String> partitionValues = new ArrayList<String>();
        for (String pathPart : pathParts) {
            if (!pathPart.contains("=")) continue;
            String[] partitionParts = pathPart.split("=");
            partitionValues.add(partitionParts[1]);
        }
        this.getLogger().debug("The following partition values were processed from path '{}': {}", new Object[]{path, partitionValues});
        return partitionValues;
    }

    private void handleFileInsert(HiveMetaStoreClient metaStoreClient, String catalogName, String databaseName, String tableName, String path, List<String> partitionValues) throws IOException, TException {
        InsertEventRequestData insertEventRequestData = new InsertEventRequestData();
        insertEventRequestData.setReplace(false);
        insertEventRequestData.addToFilesAdded(path);
        insertEventRequestData.addToFilesAddedChecksum(this.checksumFor(path));
        FireEventRequestData fireEventRequestData = new FireEventRequestData();
        fireEventRequestData.setInsertData(insertEventRequestData);
        FireEventRequest fireEventRequest = new FireEventRequest(true, fireEventRequestData);
        fireEventRequest.setCatName(catalogName);
        fireEventRequest.setDbName(databaseName);
        fireEventRequest.setTableName(tableName);
        if (partitionValues != null) {
            fireEventRequest.setPartitionVals(partitionValues);
        }
        metaStoreClient.fireListenerEvent(fireEventRequest);
    }

    private void handleDropPartition(HiveMetaStoreClient metaStoreClient, String catalogName, String databaseName, String tableName, String path) throws TException {
        List<String> partitionValues = this.getPartitionValuesFromPath(path);
        try {
            metaStoreClient.dropPartition(catalogName, databaseName, tableName, partitionValues, true);
        }
        catch (TException e) {
            if (e instanceof NoSuchObjectException) {
                this.getLogger().error("Failed to drop partition. Partition with values {} does not exists.", new Object[]{partitionValues, e});
            }
            throw new TException((Throwable)e);
        }
    }

    private String checksumFor(String filePath) throws IOException {
        Path path = new Path(filePath);
        FileSystem fileSystem = path.getFileSystem(this.hiveConfig);
        FileChecksum checksum = fileSystem.getFileChecksum(path);
        if (checksum != null) {
            return StringUtils.byteToHexString((byte[])checksum.getBytes(), (int)0, (int)checksum.getLength());
        }
        return "";
    }

    private UserGroupInformation getUgi() {
        KerberosUser kerberosUser = this.kerberosUserReference.get();
        try {
            kerberosUser.checkTGTAndRelogin();
        }
        catch (KerberosLoginException e) {
            throw new ProcessException("Unable to re-login with kerberos credentials for " + kerberosUser.getPrincipal(), (Throwable)e);
        }
        return this.ugi;
    }
}

