/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.io.orc.CompressionKind;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcStruct;
import org.apache.hadoop.hive.ql.io.orc.OrcUnion;
import org.apache.hadoop.hive.ql.io.orc.Writer;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.SettableStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.serde2.typeinfo.UnionTypeInfo;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.type.ArrayDataType;
import org.apache.nifi.serialization.record.type.ChoiceDataType;
import org.apache.nifi.serialization.record.type.DecimalDataType;
import org.apache.nifi.serialization.record.type.MapDataType;
import org.apache.nifi.serialization.record.type.RecordDataType;
import org.apache.orc.MemoryManager;
import org.apache.orc.OrcConf;
import org.apache.orc.OrcFile;
import org.apache.orc.impl.MemoryManagerImpl;

public class NiFiOrcUtils {
    private static MemoryManager memoryManager = null;

    public static Object convertToORCObject(TypeInfo typeInfo, Object o, boolean hiveFieldNames) {
        if (o != null) {
            if (typeInfo instanceof UnionTypeInfo) {
                int index;
                OrcUnion union = new OrcUnion();
                TypeInfo objectTypeInfo = TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)ObjectInspectorFactory.getReflectionObjectInspector(o.getClass(), (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA));
                List unionTypeInfos = ((UnionTypeInfo)typeInfo).getAllUnionObjectTypeInfos();
                for (index = 0; index < unionTypeInfos.size() && !((TypeInfo)unionTypeInfos.get(index)).equals((Object)objectTypeInfo); ++index) {
                }
                if (index >= unionTypeInfos.size()) {
                    throw new IllegalArgumentException("Object Type for class " + o.getClass().getName() + " not in Union declaration");
                }
                union.set((byte)index, NiFiOrcUtils.convertToORCObject(objectTypeInfo, o, hiveFieldNames));
                return union;
            }
            if (o instanceof Integer) {
                return new IntWritable(((Integer)o).intValue());
            }
            if (o instanceof Boolean) {
                return new BooleanWritable(((Boolean)o).booleanValue());
            }
            if (o instanceof Long) {
                return new LongWritable(((Long)o).longValue());
            }
            if (o instanceof Float) {
                return new FloatWritable(((Float)o).floatValue());
            }
            if (o instanceof Double) {
                return new DoubleWritable(((Double)o).doubleValue());
            }
            if (o instanceof BigDecimal) {
                return new HiveDecimalWritable(HiveDecimal.create((BigDecimal)((BigDecimal)o)));
            }
            if (o instanceof String) {
                return new Text(o.toString());
            }
            if (o instanceof ByteBuffer) {
                return new BytesWritable(((ByteBuffer)o).array());
            }
            if (o instanceof Timestamp) {
                Timestamp t = (Timestamp)o;
                org.apache.hadoop.hive.common.type.Timestamp timestamp = new org.apache.hadoop.hive.common.type.Timestamp();
                timestamp.setTimeInMillis(t.getTime(), t.getNanos());
                return new TimestampWritableV2(timestamp);
            }
            if (o instanceof Date) {
                Date d = (Date)o;
                org.apache.hadoop.hive.common.type.Date date = new org.apache.hadoop.hive.common.type.Date();
                date.setTimeInMillis(d.getTime());
                return new DateWritableV2(date);
            }
            if (o instanceof Object[]) {
                Object[] objArray = (Object[])o;
                if (TypeInfoFactory.binaryTypeInfo.equals((Object)typeInfo)) {
                    byte[] dest = new byte[objArray.length];
                    for (int i2 = 0; i2 < objArray.length; ++i2) {
                        dest[i2] = (Byte)objArray[i2];
                    }
                    return new BytesWritable(dest);
                }
                TypeInfo listTypeInfo = ((ListTypeInfo)typeInfo).getListElementTypeInfo();
                return Arrays.stream(objArray).map(o1 -> NiFiOrcUtils.convertToORCObject(listTypeInfo, o1, hiveFieldNames)).collect(Collectors.toList());
            }
            if (o instanceof int[]) {
                int[] intArray = (int[])o;
                return Arrays.stream(intArray).mapToObj(element -> NiFiOrcUtils.convertToORCObject((TypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"int"), element, hiveFieldNames)).collect(Collectors.toList());
            }
            if (o instanceof long[]) {
                long[] longArray = (long[])o;
                return Arrays.stream(longArray).mapToObj(element -> NiFiOrcUtils.convertToORCObject((TypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"bigint"), element, hiveFieldNames)).collect(Collectors.toList());
            }
            if (o instanceof float[]) {
                float[] floatArray = (float[])o;
                return IntStream.range(0, floatArray.length).mapToDouble(i -> floatArray[i]).mapToObj(element -> NiFiOrcUtils.convertToORCObject((TypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"float"), Float.valueOf((float)element), hiveFieldNames)).collect(Collectors.toList());
            }
            if (o instanceof double[]) {
                double[] doubleArray = (double[])o;
                return Arrays.stream(doubleArray).mapToObj(element -> NiFiOrcUtils.convertToORCObject((TypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"double"), element, hiveFieldNames)).collect(Collectors.toList());
            }
            if (o instanceof boolean[]) {
                boolean[] booleanArray = (boolean[])o;
                return IntStream.range(0, booleanArray.length).map(i -> booleanArray[i] ? 1 : 0).mapToObj(element -> NiFiOrcUtils.convertToORCObject((TypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"boolean"), element == 1, hiveFieldNames)).collect(Collectors.toList());
            }
            if (o instanceof List) {
                return o;
            }
            if (o instanceof Record) {
                Record record = (Record)o;
                TypeInfo recordSchema = NiFiOrcUtils.getOrcSchema(record.getSchema(), hiveFieldNames);
                List recordFields = record.getSchema().getFields();
                if (recordFields != null) {
                    Object[] fieldObjects = new Object[recordFields.size()];
                    for (int i3 = 0; i3 < recordFields.size(); ++i3) {
                        RecordField field = (RecordField)recordFields.get(i3);
                        DataType dataType = field.getDataType();
                        Object fieldObject = record.getValue(field);
                        fieldObjects[i3] = NiFiOrcUtils.convertToORCObject(NiFiOrcUtils.getOrcField(dataType, hiveFieldNames), fieldObject, hiveFieldNames);
                    }
                    return NiFiOrcUtils.createOrcStruct(recordSchema, fieldObjects);
                }
                return null;
            }
            if (o instanceof Map) {
                HashMap map = new HashMap();
                MapTypeInfo mapTypeInfo = (MapTypeInfo)typeInfo;
                TypeInfo keyInfo = mapTypeInfo.getMapKeyTypeInfo();
                TypeInfo valueInfo = mapTypeInfo.getMapValueTypeInfo();
                ((Map)o).forEach((key, value) -> {
                    Object keyObject = NiFiOrcUtils.convertToORCObject(keyInfo, key, hiveFieldNames);
                    Object valueObject = NiFiOrcUtils.convertToORCObject(valueInfo, value, hiveFieldNames);
                    if (keyObject == null) {
                        throw new IllegalArgumentException("Maps' key cannot be null");
                    }
                    map.put(keyObject, valueObject);
                });
                return map;
            }
            throw new IllegalArgumentException("Error converting object of type " + o.getClass().getName() + " to ORC type " + typeInfo.getTypeName());
        }
        return null;
    }

    public static OrcStruct createOrcStruct(TypeInfo typeInfo, Object ... objs) {
        SettableStructObjectInspector oi = (SettableStructObjectInspector)OrcStruct.createObjectInspector((TypeInfo)typeInfo);
        List fields = oi.getAllStructFieldRefs();
        OrcStruct result = (OrcStruct)oi.create();
        result.setNumFields(fields.size());
        for (int i = 0; i < fields.size(); ++i) {
            oi.setStructFieldData((Object)result, (StructField)fields.get(i), objs[i]);
        }
        return result;
    }

    public static String normalizeHiveTableName(String name) {
        return name.replaceAll("[\\. ]", "_");
    }

    public static String generateHiveDDL(RecordSchema recordSchema, String tableName, boolean hiveFieldNames) {
        StringBuilder sb = new StringBuilder("CREATE EXTERNAL TABLE IF NOT EXISTS ");
        String[] tableSections = tableName.split("\\.");
        String quotedTableName = Arrays.stream(tableSections).map(section -> "`" + section + "`").collect(Collectors.joining("."));
        sb.append(quotedTableName);
        sb.append(" (");
        ArrayList hiveColumns = new ArrayList();
        List fields = recordSchema.getFields();
        if (fields != null) {
            hiveColumns.addAll(fields.stream().map(field -> "`" + (hiveFieldNames ? field.getFieldName().toLowerCase() : field.getFieldName()) + "` " + NiFiOrcUtils.getHiveTypeFromFieldType(field.getDataType(), hiveFieldNames)).collect(Collectors.toList()));
        }
        sb.append(StringUtils.join(hiveColumns, (String)", "));
        sb.append(") STORED AS ORC");
        return sb.toString();
    }

    public static TypeInfo getOrcSchema(RecordSchema recordSchema, boolean hiveFieldNames) throws IllegalArgumentException {
        List recordFields = recordSchema.getFields();
        if (recordFields != null) {
            ArrayList orcFieldNames = new ArrayList(recordFields.size());
            ArrayList orcFields = new ArrayList(recordFields.size());
            recordFields.forEach(recordField -> {
                String fieldName = hiveFieldNames ? recordField.getFieldName().toLowerCase() : recordField.getFieldName();
                orcFieldNames.add(fieldName);
                orcFields.add(NiFiOrcUtils.getOrcField(recordField.getDataType(), hiveFieldNames));
            });
            return TypeInfoFactory.getStructTypeInfo(orcFieldNames, orcFields);
        }
        return null;
    }

    public static TypeInfo getOrcField(DataType dataType, boolean hiveFieldNames) throws IllegalArgumentException {
        if (dataType == null) {
            return null;
        }
        RecordFieldType fieldType = dataType.getFieldType();
        if (RecordFieldType.INT.equals((Object)fieldType) || RecordFieldType.LONG.equals((Object)fieldType) || RecordFieldType.BOOLEAN.equals((Object)fieldType) || RecordFieldType.DOUBLE.equals((Object)fieldType) || RecordFieldType.FLOAT.equals((Object)fieldType) || RecordFieldType.STRING.equals((Object)fieldType) || RecordFieldType.ENUM.equals((Object)fieldType)) {
            return NiFiOrcUtils.getPrimitiveOrcTypeFromPrimitiveFieldType(dataType);
        }
        if (RecordFieldType.DECIMAL.equals((Object)fieldType)) {
            DecimalDataType decimalDataType = (DecimalDataType)dataType;
            return TypeInfoFactory.getDecimalTypeInfo((int)decimalDataType.getPrecision(), (int)decimalDataType.getScale());
        }
        if (RecordFieldType.DATE.equals((Object)fieldType)) {
            return TypeInfoFactory.dateTypeInfo;
        }
        if (RecordFieldType.TIME.equals((Object)fieldType)) {
            return TypeInfoFactory.intTypeInfo;
        }
        if (RecordFieldType.TIMESTAMP.equals((Object)fieldType)) {
            return TypeInfoFactory.timestampTypeInfo;
        }
        if (RecordFieldType.ARRAY.equals((Object)fieldType)) {
            ArrayDataType arrayDataType = (ArrayDataType)dataType;
            if (RecordFieldType.BYTE.getDataType().equals((Object)arrayDataType.getElementType())) {
                return TypeInfoFactory.getPrimitiveTypeInfo((String)"binary");
            }
            return TypeInfoFactory.getListTypeInfo((TypeInfo)NiFiOrcUtils.getOrcField(arrayDataType.getElementType(), hiveFieldNames));
        }
        if (RecordFieldType.CHOICE.equals((Object)fieldType)) {
            ChoiceDataType choiceDataType = (ChoiceDataType)dataType;
            List unionFieldSchemas = choiceDataType.getPossibleSubTypes();
            if (unionFieldSchemas != null) {
                List orcFields = unionFieldSchemas.stream().map(it -> NiFiOrcUtils.getOrcField(it, hiveFieldNames)).collect(Collectors.toList());
                if (orcFields.size() == 1) {
                    return (TypeInfo)orcFields.get(0);
                }
                return TypeInfoFactory.getUnionTypeInfo(orcFields);
            }
            return null;
        }
        if (RecordFieldType.MAP.equals((Object)fieldType)) {
            MapDataType mapDataType = (MapDataType)dataType;
            return TypeInfoFactory.getMapTypeInfo((TypeInfo)NiFiOrcUtils.getPrimitiveOrcTypeFromPrimitiveFieldType(RecordFieldType.STRING.getDataType()), (TypeInfo)NiFiOrcUtils.getOrcField(mapDataType.getValueType(), hiveFieldNames));
        }
        if (RecordFieldType.RECORD.equals((Object)fieldType)) {
            RecordDataType recordDataType = (RecordDataType)dataType;
            List recordFields = recordDataType.getChildSchema().getFields();
            if (recordFields != null) {
                ArrayList orcFieldNames = new ArrayList(recordFields.size());
                ArrayList orcFields = new ArrayList(recordFields.size());
                recordFields.forEach(recordField -> {
                    String fieldName = hiveFieldNames ? recordField.getFieldName().toLowerCase() : recordField.getFieldName();
                    orcFieldNames.add(fieldName);
                    orcFields.add(NiFiOrcUtils.getOrcField(recordField.getDataType(), hiveFieldNames));
                });
                return TypeInfoFactory.getStructTypeInfo(orcFieldNames, orcFields);
            }
            return null;
        }
        throw new IllegalArgumentException("Did not recognize field type " + fieldType.name());
    }

    public static TypeInfo getPrimitiveOrcTypeFromPrimitiveFieldType(DataType rawDataType) throws IllegalArgumentException {
        if (rawDataType == null) {
            throw new IllegalArgumentException("Avro type is null");
        }
        RecordFieldType fieldType = rawDataType.getFieldType();
        if (RecordFieldType.INT.equals((Object)fieldType)) {
            return TypeInfoFactory.getPrimitiveTypeInfo((String)"int");
        }
        if (RecordFieldType.LONG.equals((Object)fieldType)) {
            return TypeInfoFactory.getPrimitiveTypeInfo((String)"bigint");
        }
        if (RecordFieldType.BOOLEAN.equals((Object)fieldType)) {
            return TypeInfoFactory.getPrimitiveTypeInfo((String)"boolean");
        }
        if (RecordFieldType.DOUBLE.equals((Object)fieldType)) {
            return TypeInfoFactory.getPrimitiveTypeInfo((String)"double");
        }
        if (RecordFieldType.FLOAT.equals((Object)fieldType)) {
            return TypeInfoFactory.getPrimitiveTypeInfo((String)"float");
        }
        if (RecordFieldType.STRING.equals((Object)fieldType) || RecordFieldType.ENUM.equals((Object)fieldType)) {
            return TypeInfoFactory.getPrimitiveTypeInfo((String)"string");
        }
        throw new IllegalArgumentException("Field type " + fieldType.name() + " is not a primitive type");
    }

    public static String getHiveSchema(RecordSchema recordSchema, boolean hiveFieldNames) throws IllegalArgumentException {
        List recordFields = recordSchema.getFields();
        if (recordFields != null) {
            ArrayList hiveFields = new ArrayList(recordFields.size());
            recordFields.forEach(recordField -> hiveFields.add((hiveFieldNames ? recordField.getFieldName().toLowerCase() : recordField.getFieldName()) + ":" + NiFiOrcUtils.getHiveTypeFromFieldType(recordField.getDataType(), hiveFieldNames)));
            return "STRUCT<" + StringUtils.join(hiveFields, (String)", ") + ">";
        }
        return null;
    }

    public static String getHiveTypeFromFieldType(DataType rawDataType, boolean hiveFieldNames) {
        if (rawDataType == null) {
            throw new IllegalArgumentException("Field type is null");
        }
        RecordFieldType dataType = rawDataType.getFieldType();
        if (RecordFieldType.INT.equals((Object)dataType)) {
            return "INT";
        }
        if (RecordFieldType.LONG.equals((Object)dataType)) {
            return "BIGINT";
        }
        if (RecordFieldType.BOOLEAN.equals((Object)dataType)) {
            return "BOOLEAN";
        }
        if (RecordFieldType.DOUBLE.equals((Object)dataType)) {
            return "DOUBLE";
        }
        if (RecordFieldType.FLOAT.equals((Object)dataType)) {
            return "FLOAT";
        }
        if (RecordFieldType.DECIMAL.equals((Object)dataType)) {
            return "DECIMAL";
        }
        if (RecordFieldType.STRING.equals((Object)dataType) || RecordFieldType.ENUM.equals((Object)dataType)) {
            return "STRING";
        }
        if (RecordFieldType.DATE.equals((Object)dataType)) {
            return "DATE";
        }
        if (RecordFieldType.TIME.equals((Object)dataType)) {
            return "INT";
        }
        if (RecordFieldType.TIMESTAMP.equals((Object)dataType)) {
            return "TIMESTAMP";
        }
        if (RecordFieldType.ARRAY.equals((Object)dataType)) {
            ArrayDataType arrayDataType = (ArrayDataType)rawDataType;
            if (RecordFieldType.BYTE.getDataType().equals((Object)arrayDataType.getElementType())) {
                return "BINARY";
            }
            return "ARRAY<" + NiFiOrcUtils.getHiveTypeFromFieldType(arrayDataType.getElementType(), hiveFieldNames) + ">";
        }
        if (RecordFieldType.MAP.equals((Object)dataType)) {
            MapDataType mapDataType = (MapDataType)rawDataType;
            return "MAP<STRING, " + NiFiOrcUtils.getHiveTypeFromFieldType(mapDataType.getValueType(), hiveFieldNames) + ">";
        }
        if (RecordFieldType.CHOICE.equals((Object)dataType)) {
            ChoiceDataType choiceDataType = (ChoiceDataType)rawDataType;
            List unionFieldSchemas = choiceDataType.getPossibleSubTypes();
            if (unionFieldSchemas != null) {
                List hiveFields = unionFieldSchemas.stream().map(it -> NiFiOrcUtils.getHiveTypeFromFieldType(it, hiveFieldNames)).collect(Collectors.toList());
                return hiveFields.size() == 1 ? (String)hiveFields.get(0) : "UNIONTYPE<" + StringUtils.join(hiveFields, (String)", ") + ">";
            }
            return null;
        }
        if (RecordFieldType.RECORD.equals((Object)dataType)) {
            RecordDataType recordDataType = (RecordDataType)rawDataType;
            List recordFields = recordDataType.getChildSchema().getFields();
            if (recordFields != null) {
                List hiveFields = recordFields.stream().map(recordField -> "`" + (hiveFieldNames ? recordField.getFieldName().toLowerCase() : recordField.getFieldName()) + "`:" + NiFiOrcUtils.getHiveTypeFromFieldType(recordField.getDataType(), hiveFieldNames)).collect(Collectors.toList());
                return "STRUCT<" + StringUtils.join(hiveFields, (String)", ") + ">";
            }
            return null;
        }
        throw new IllegalArgumentException("Error converting Avro type " + dataType.name() + " to Hive type");
    }

    public static Writer createWriter(Path path, Configuration conf, TypeInfo orcSchema, long stripeSize, CompressionKind compress, int bufferSize) throws IOException {
        int rowIndexStride = (int)OrcConf.ROW_INDEX_STRIDE.getLong(conf);
        boolean addBlockPadding = OrcConf.BLOCK_PADDING.getBoolean(conf);
        String versionName = OrcConf.WRITE_FORMAT.getString(conf);
        OrcFile.Version versionValue = versionName == null ? OrcFile.Version.CURRENT : OrcFile.Version.byName((String)versionName);
        String enString = OrcConf.ENCODING_STRATEGY.getString(conf);
        OrcFile.EncodingStrategy encodingStrategy = enString == null ? OrcFile.EncodingStrategy.SPEED : OrcFile.EncodingStrategy.valueOf((String)enString);
        double paddingTolerance = OrcConf.BLOCK_PADDING_TOLERANCE.getDouble(conf);
        long blockSizeValue = OrcConf.BLOCK_SIZE.getLong(conf);
        double bloomFilterFpp = OrcConf.BLOOM_FILTER_FPP.getDouble(conf);
        ObjectInspector inspector = OrcStruct.createObjectInspector((TypeInfo)orcSchema);
        OrcFile.WriterOptions writerOptions = OrcFile.writerOptions((Configuration)conf).rowIndexStride(rowIndexStride).blockPadding(addBlockPadding).version(versionValue).encodingStrategy(encodingStrategy).paddingTolerance(paddingTolerance).blockSize(blockSizeValue).bloomFilterFpp(bloomFilterFpp).memory(NiFiOrcUtils.getMemoryManager(conf)).inspector(inspector).stripeSize(stripeSize).bufferSize(bufferSize).compress(compress);
        return OrcFile.createWriter((Path)path, (OrcFile.WriterOptions)writerOptions);
    }

    private static synchronized MemoryManager getMemoryManager(Configuration conf) {
        if (memoryManager == null) {
            memoryManager = new MemoryManagerImpl(conf);
        }
        return memoryManager;
    }
}

