/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.hive;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hive.streaming.HiveRecordWriter;
import org.apache.hive.streaming.HiveStreamingConnection;
import org.apache.hive.streaming.RecordWriter;
import org.apache.hive.streaming.StreamingConnection;
import org.apache.hive.streaming.StreamingException;
import org.apache.nifi.annotation.behavior.RequiresInstanceClassLoading;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.resource.ResourceCardinality;
import org.apache.nifi.components.resource.ResourceType;
import org.apache.nifi.expression.AttributeExpression;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.hadoop.SecurityUtil;
import org.apache.nifi.kerberos.KerberosCredentialsService;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processor.util.pattern.RollbackOnFailure;
import org.apache.nifi.security.krb.KerberosKeytabUser;
import org.apache.nifi.security.krb.KerberosLoginException;
import org.apache.nifi.security.krb.KerberosPasswordUser;
import org.apache.nifi.security.krb.KerberosUser;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.RecordReaderFactory;
import org.apache.nifi.util.hive.AuthenticationFailedException;
import org.apache.nifi.util.hive.HiveConfigurator;
import org.apache.nifi.util.hive.HiveOptions;
import org.apache.nifi.util.hive.ValidationResources;

@Tags(value={"hive", "streaming", "put", "database", "store"})
@CapabilityDescription(value="This processor uses Hive Streaming to send flow file records to an Apache Hive 3.0+ table. If 'Static Partition Values' is not set, then the partition values are expected to be the 'last' fields of each record, so if the table is partitioned on column A for example, then the last field in each record should be field A. If 'Static Partition Values' is set, those values will be used as the partition values, and any record fields corresponding to partition columns will be ignored.")
@WritesAttributes(value={@WritesAttribute(attribute="hivestreaming.record.count", description="This attribute is written on the flow files routed to the 'success' and 'failure' relationships, and contains the number of records from the incoming flow file. All records in a flow file are committed as a single transaction."), @WritesAttribute(attribute="query.output.tables", description="This attribute is written on the flow files routed to the 'success' and 'failure' relationships, and contains the target table name in 'databaseName.tableName' format.")})
@RequiresInstanceClassLoading
public class PutHive3Streaming
extends AbstractProcessor {
    public static final String HIVE_STREAMING_RECORD_COUNT_ATTR = "hivestreaming.record.count";
    private static final String CLIENT_CACHE_DISABLED_PROPERTY = "hcatalog.hive.client.cache.disabled";
    static final PropertyDescriptor RECORD_READER = new PropertyDescriptor.Builder().name("record-reader").displayName("Record Reader").description("The service for reading records from incoming flow files.").identifiesControllerService(RecordReaderFactory.class).required(true).build();
    static final PropertyDescriptor METASTORE_URI = new PropertyDescriptor.Builder().name("hive3-stream-metastore-uri").displayName("Hive Metastore URI").description("The URI location(s) for the Hive metastore. This is a comma-separated list of Hive metastore URIs; note that this is not the location of the Hive Server. The default port for the Hive metastore is 9043. If this field is not set, then the 'hive.metastore.uris' property from any provided configuration resources will be used, and if none are provided, then the default value from a default hive-site.xml will be used (usually thrift://localhost:9083).").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.URI_LIST_VALIDATOR).build();
    static final PropertyDescriptor HIVE_CONFIGURATION_RESOURCES = new PropertyDescriptor.Builder().name("hive3-config-resources").displayName("Hive Configuration Resources").description("A file or comma separated list of files which contains the Hive configuration (hive-site.xml, e.g.). Without this, Hadoop will search the classpath for a 'hive-site.xml' file or will revert to a default configuration. Note that to enable authentication with Kerberos e.g., the appropriate properties must be set in the configuration files. Also note that if Max Concurrent Tasks is set to a number greater than one, the 'hcatalog.hive.client.cache.disabled' property will be forced to 'true' to avoid concurrency issues. Please see the Hive documentation for more details.").required(false).identifiesExternalResource(ResourceCardinality.MULTIPLE, ResourceType.FILE, new ResourceType[0]).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    static final PropertyDescriptor DB_NAME = new PropertyDescriptor.Builder().name("hive3-stream-database-name").displayName("Database Name").description("The name of the database in which to put the data.").required(true).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    static final PropertyDescriptor TABLE_NAME = new PropertyDescriptor.Builder().name("hive3-stream-table-name").displayName("Table Name").description("The name of the database table in which to put the data.").required(true).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    static final PropertyDescriptor STATIC_PARTITION_VALUES = new PropertyDescriptor.Builder().name("hive3-stream-part-vals").displayName("Static Partition Values").description("Specifies a comma-separated list of the values for the partition columns of the target table. If the incoming records all have the same values for the partition columns, those values can be entered here, resulting in a performance gain. If specified, this property will often contain Expression Language, for example if PartitionRecord is upstream and two partitions 'name' and 'age' are used, then this property can be set to ${name},${age}. If this property is set, the values will be used as the partition values, and any record fields corresponding to partition columns will be ignored. If this property is not set, then the partition values are expected to be the last fields of each record.").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    static final PropertyDescriptor RECORDS_PER_TXN = new PropertyDescriptor.Builder().name("hive3-stream-records-per-transaction").displayName("Records per Transaction").description("Number of records to process before committing the transaction. If set to zero (0), all records will be written in a single transaction.").required(true).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).defaultValue("0").build();
    static final PropertyDescriptor TXNS_PER_BATCH = new PropertyDescriptor.Builder().name("hive3-stream-transactions-per-batch").displayName("Transactions per Batch").description("A hint to Hive Streaming indicating how many transactions the processor task will need. The product of Records per Transaction (if not zero) and Transactions per Batch should be larger than the largest expected number of records in the flow file(s), this will ensure any failed transaction batches cause a full rollback.").required(true).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).defaultValue("1").build();
    static final PropertyDescriptor CALL_TIMEOUT = new PropertyDescriptor.Builder().name("hive3-stream-call-timeout").displayName("Call Timeout").description("The number of seconds allowed for a Hive Streaming operation to complete. A value of 0 indicates the processor should wait indefinitely on operations. Note that although this property supports Expression Language, it will not be evaluated against incoming FlowFile attributes.").defaultValue("0").required(true).addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    static final PropertyDescriptor DISABLE_STREAMING_OPTIMIZATIONS = new PropertyDescriptor.Builder().name("hive3-stream-disable-optimizations").displayName("Disable Streaming Optimizations").description("Whether to disable streaming optimizations. Disabling streaming optimizations will have significant impact to performance and memory consumption.").required(true).addValidator(StandardValidators.BOOLEAN_VALIDATOR).allowableValues(new String[]{"true", "false"}).defaultValue("false").build();
    static final PropertyDescriptor ROLLBACK_ON_FAILURE = RollbackOnFailure.createRollbackOnFailureProperty((String)"NOTE: When an error occurred after a Hive streaming transaction which is derived from the same input FlowFile is already committed, (i.e. a FlowFile contains more records than 'Records per Transaction' and a failure occurred at the 2nd transaction or later) then the succeeded records will be transferred to 'success' relationship while the original input FlowFile stays in incoming queue. Duplicated records can be created for the succeeded ones when the same FlowFile is processed again.");
    static final PropertyDescriptor KERBEROS_CREDENTIALS_SERVICE = new PropertyDescriptor.Builder().name("kerberos-credentials-service").displayName("Kerberos Credentials Service").description("Specifies the Kerberos Credentials Controller Service that should be used for authenticating with Kerberos").identifiesControllerService(KerberosCredentialsService.class).required(false).build();
    static final PropertyDescriptor KERBEROS_PRINCIPAL = new PropertyDescriptor.Builder().name("kerberos-principal").displayName("Kerberos Principal").description("The principal to use when specifying the principal and password directly in the processor for authenticating via Kerberos.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).addValidator(StandardValidators.createAttributeExpressionLanguageValidator((AttributeExpression.ResultType)AttributeExpression.ResultType.STRING)).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    static final PropertyDescriptor KERBEROS_PASSWORD = new PropertyDescriptor.Builder().name("kerberos-password").displayName("Kerberos Password").description("The password to use when specifying the principal and password directly in the processor for authenticating via Kerberos.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).sensitive(true).build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("A FlowFile containing Avro records routed to this relationship after the record has been successfully transmitted to Hive.").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("A FlowFile containing Avro records routed to this relationship if the record could not be transmitted to Hive.").build();
    public static final Relationship REL_RETRY = new Relationship.Builder().name("retry").description("The incoming FlowFile is routed to this relationship if its records cannot be transmitted to Hive. Note that some records may have been processed successfully, they will be routed (as Avro flow files) to the success relationship. The combination of the retry, success, and failure relationships indicate how many records succeeded and/or failed. This can be used to provide a retry capability since full rollback is not possible.").build();
    private List<PropertyDescriptor> propertyDescriptors;
    private Set<Relationship> relationships;
    protected volatile HiveConfigurator hiveConfigurator = new HiveConfigurator();
    protected volatile UserGroupInformation ugi;
    protected final AtomicReference<KerberosUser> kerberosUserReference = new AtomicReference();
    protected volatile HiveConf hiveConfig;
    protected volatile int callTimeout;
    protected ExecutorService callTimeoutPool;
    protected volatile boolean rollbackOnFailure;
    private final AtomicReference<ValidationResources> validationResourceHolder = new AtomicReference();

    protected void init(ProcessorInitializationContext context) {
        ArrayList<PropertyDescriptor> props = new ArrayList<PropertyDescriptor>();
        props.add(RECORD_READER);
        props.add(METASTORE_URI);
        props.add(HIVE_CONFIGURATION_RESOURCES);
        props.add(DB_NAME);
        props.add(TABLE_NAME);
        props.add(STATIC_PARTITION_VALUES);
        props.add(RECORDS_PER_TXN);
        props.add(TXNS_PER_BATCH);
        props.add(CALL_TIMEOUT);
        props.add(DISABLE_STREAMING_OPTIMIZATIONS);
        props.add(ROLLBACK_ON_FAILURE);
        props.add(KERBEROS_CREDENTIALS_SERVICE);
        props.add(KERBEROS_PRINCIPAL);
        props.add(KERBEROS_PASSWORD);
        this.propertyDescriptors = Collections.unmodifiableList(props);
        HashSet<Relationship> _relationships = new HashSet<Relationship>();
        _relationships.add(REL_SUCCESS);
        _relationships.add(REL_FAILURE);
        _relationships.add(REL_RETRY);
        this.relationships = Collections.unmodifiableSet(_relationships);
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.propertyDescriptors;
    }

    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        String resolvedKeytab;
        boolean confFileProvided = validationContext.getProperty(HIVE_CONFIGURATION_RESOURCES).isSet();
        ArrayList<ValidationResult> problems = new ArrayList<ValidationResult>();
        KerberosCredentialsService credentialsService = (KerberosCredentialsService)validationContext.getProperty(KERBEROS_CREDENTIALS_SERVICE).asControllerService(KerberosCredentialsService.class);
        String explicitPrincipal = validationContext.getProperty(KERBEROS_PRINCIPAL).evaluateAttributeExpressions().getValue();
        String explicitPassword = validationContext.getProperty(KERBEROS_PASSWORD).getValue();
        String resolvedPrincipal = credentialsService != null ? credentialsService.getPrincipal() : explicitPrincipal;
        String string = resolvedKeytab = credentialsService != null ? credentialsService.getKeytab() : null;
        if (confFileProvided) {
            String configFiles = validationContext.getProperty(HIVE_CONFIGURATION_RESOURCES).evaluateAttributeExpressions().getValue();
            problems.addAll(this.hiveConfigurator.validate(configFiles, resolvedPrincipal, resolvedKeytab, explicitPassword, this.validationResourceHolder, this.getLogger()));
        }
        if (credentialsService != null && (explicitPrincipal != null || explicitPassword != null)) {
            problems.add(new ValidationResult.Builder().subject(KERBEROS_CREDENTIALS_SERVICE.getDisplayName()).valid(false).explanation("kerberos principal/password and kerberos credential service cannot be configured at the same time").build());
        }
        return problems;
    }

    @OnScheduled
    public void setup(ProcessContext context) throws IOException {
        ComponentLog log = this.getLogger();
        this.rollbackOnFailure = context.getProperty(ROLLBACK_ON_FAILURE).asBoolean();
        String configFiles = context.getProperty(HIVE_CONFIGURATION_RESOURCES).evaluateAttributeExpressions().getValue();
        this.hiveConfig = this.hiveConfigurator.getConfigurationFromFiles(configFiles);
        if (context.getMaxConcurrentTasks() > 1) {
            this.hiveConfig.setBoolean(CLIENT_CACHE_DISABLED_PROPERTY, true);
        }
        for (Map.Entry entry : context.getProperties().entrySet()) {
            PropertyDescriptor descriptor = (PropertyDescriptor)entry.getKey();
            if (!descriptor.isDynamic()) continue;
            this.hiveConfig.set(descriptor.getName(), (String)entry.getValue());
        }
        this.hiveConfigurator.preload((Configuration)this.hiveConfig);
        if (SecurityUtil.isSecurityEnabled((Configuration)this.hiveConfig)) {
            String resolvedKeytab;
            KerberosCredentialsService credentialsService = (KerberosCredentialsService)context.getProperty(KERBEROS_CREDENTIALS_SERVICE).asControllerService(KerberosCredentialsService.class);
            String explicitPrincipal = context.getProperty(KERBEROS_PRINCIPAL).evaluateAttributeExpressions().getValue();
            String explicitPassword = context.getProperty(KERBEROS_PASSWORD).getValue();
            String resolvedPrincipal = credentialsService != null ? credentialsService.getPrincipal() : explicitPrincipal;
            String string = resolvedKeytab = credentialsService != null ? credentialsService.getKeytab() : null;
            if (resolvedKeytab != null) {
                this.kerberosUserReference.set((KerberosUser)new KerberosKeytabUser(resolvedPrincipal, resolvedKeytab));
                log.info("Hive Security Enabled, logging in as principal {} with keytab {}", new Object[]{resolvedPrincipal, resolvedKeytab});
            } else if (explicitPassword != null) {
                this.kerberosUserReference.set((KerberosUser)new KerberosPasswordUser(resolvedPrincipal, explicitPassword));
                log.info("Hive Security Enabled, logging in as principal {} with password", new Object[]{resolvedPrincipal});
            } else {
                throw new ProcessException("Unable to authenticate with Kerberos, no keytab or password was provided");
            }
            try {
                this.ugi = this.hiveConfigurator.authenticate((Configuration)this.hiveConfig, this.kerberosUserReference.get());
            }
            catch (AuthenticationFailedException ae) {
                log.error(ae.getMessage(), (Throwable)ae);
                throw new ProcessException((Throwable)ae);
            }
            log.info("Successfully logged in as principal " + resolvedPrincipal);
        } else {
            this.ugi = SecurityUtil.loginSimple((Configuration)this.hiveConfig);
            this.kerberosUserReference.set(null);
        }
        this.callTimeout = context.getProperty(CALL_TIMEOUT).evaluateAttributeExpressions().asInteger() * 1000;
        String timeoutName = "put-hive3-streaming-%d";
        this.callTimeoutPool = Executors.newFixedThreadPool(1, new ThreadFactoryBuilder().setNameFormat(timeoutName).build());
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        this.getUgi().doAs(() -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [20[CATCHBLOCK]], but top level block is 9[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }

    StreamingConnection makeStreamingConnection(HiveOptions options, RecordReader reader, int recordsPerTransaction) throws StreamingException {
        return HiveStreamingConnection.newBuilder().withDatabase(options.getDatabaseName()).withTable(options.getTableName()).withStaticPartitionValues(options.getStaticPartitionValues()).withHiveConf(options.getHiveConf()).withRecordWriter((RecordWriter)new HiveRecordWriter(reader, this.getLogger(), recordsPerTransaction)).withTransactionBatchSize(options.getTransactionBatchSize()).withAgentInfo("NiFi " + ((Object)((Object)this)).getClass().getSimpleName() + " [" + this.getIdentifier() + "] thread " + Thread.currentThread().getId() + "[" + Thread.currentThread().getName() + "]").connect();
    }

    @OnStopped
    public void cleanup() {
        this.validationResourceHolder.set(null);
        ComponentLog log = this.getLogger();
        if (this.callTimeoutPool != null) {
            this.callTimeoutPool.shutdown();
            try {
                while (!this.callTimeoutPool.isTerminated()) {
                    this.callTimeoutPool.awaitTermination(this.callTimeout, TimeUnit.MILLISECONDS);
                }
            }
            catch (Throwable t) {
                log.warn("shutdown interrupted on " + this.callTimeoutPool, t);
            }
            this.callTimeoutPool = null;
        }
        this.ugi = null;
        this.kerberosUserReference.set(null);
    }

    private void abortAndCloseConnection(StreamingConnection connection) {
        try {
            this.abortConnection(connection);
            this.closeConnection(connection);
        }
        catch (Exception ie) {
            this.getLogger().warn("unable to close hive connections. ", (Throwable)ie);
        }
    }

    private void abortConnection(StreamingConnection connection) {
        if (connection != null) {
            try {
                connection.abortTransaction();
            }
            catch (Exception e) {
                this.getLogger().error("Failed to abort Hive Streaming transaction " + connection + " due to exception ", (Throwable)e);
            }
        }
    }

    private void closeConnection(StreamingConnection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (Exception e) {
                this.getLogger().error("Failed to close Hive Streaming connection " + connection + " due to exception ", (Throwable)e);
            }
        }
    }

    UserGroupInformation getUgi() {
        this.getLogger().trace("getting UGI instance");
        if (this.kerberosUserReference.get() != null) {
            KerberosUser kerberosUser = this.kerberosUserReference.get();
            this.getLogger().debug("kerberosUser is " + kerberosUser);
            try {
                this.getLogger().debug("checking TGT on kerberosUser [{}]", new Object[]{kerberosUser});
                kerberosUser.checkTGTAndRelogin();
            }
            catch (KerberosLoginException e) {
                throw new ProcessException("Unable to relogin with kerberos credentials for " + kerberosUser.getPrincipal(), (Throwable)e);
            }
        } else {
            this.getLogger().debug("kerberosUser was null, will not refresh TGT with KerberosUser");
        }
        return this.ugi;
    }

    private static class ShouldRetryException
    extends RuntimeException {
        private ShouldRetryException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

