/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.dropbox;

import com.dropbox.core.DbxException;
import com.dropbox.core.v2.DbxClientV2;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.dropbox.DropboxTrait;
import org.apache.nifi.processors.dropbox.ListDropbox;
import org.apache.nifi.proxy.ProxyConfiguration;
import org.apache.nifi.proxy.ProxySpec;

@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"dropbox", "storage", "fetch"})
@CapabilityDescription(value="Fetches files from Dropbox. Designed to be used in tandem with ListDropbox.")
@WritesAttribute(attribute="error.message", description="When a FlowFile is routed to 'failure', this attribute is added indicating why the file could not be fetched from Dropbox.")
@SeeAlso(value={ListDropbox.class})
@WritesAttributes(value={@WritesAttribute(attribute="error.message", description="The error message returned by Dropbox when the fetch of a file fails.")})
public class FetchDropbox
extends AbstractProcessor
implements DropboxTrait {
    public static final String ERROR_MESSAGE_ATTRIBUTE = "error.message";
    public static final PropertyDescriptor FILE = new PropertyDescriptor.Builder().name("file").displayName("File").description("The Dropbox identifier or path of the Dropbox file to fetch. The 'File' should match the following regular expression pattern: /.*|id:.* . When ListDropbox is used for input, either '${dropbox.id}' (identifying files by Dropbox id) or '${path}/${filename}' (identifying files by path) can be used as 'File' value.").required(true).defaultValue("${dropbox.id}").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.createRegexMatchingValidator((Pattern)Pattern.compile("/.*|id:.*"))).build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("A FlowFile will be routed here for each successfully fetched File.").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("A FlowFile will be routed here for each File for which fetch was attempted but failed.").build();
    public static final Set<Relationship> relationships = Collections.unmodifiableSet(new HashSet<Relationship>(Arrays.asList(REL_SUCCESS, REL_FAILURE)));
    private static final List<PropertyDescriptor> PROPERTIES = Collections.unmodifiableList(Arrays.asList(CREDENTIAL_SERVICE, FILE, ProxyConfiguration.createProxyConfigPropertyDescriptor((boolean)false, (ProxySpec[])new ProxySpec[]{ProxySpec.HTTP_AUTH})));
    private DbxClientV2 dropboxApiClient;

    public Set<Relationship> getRelationships() {
        return relationships;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTIES;
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) {
        ProxyConfiguration proxyConfiguration = ProxyConfiguration.getConfiguration((PropertyContext)context);
        String dropboxClientId = String.format("%s-%s", this.getClass().getSimpleName(), this.getIdentifier());
        this.dropboxApiClient = this.getDropboxApiClient(context, proxyConfiguration, dropboxClientId);
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        String fileIdentifier = context.getProperty(FILE).evaluateAttributeExpressions(flowFile).getValue();
        fileIdentifier = this.correctFilePath(fileIdentifier);
        FlowFile outFlowFile = flowFile;
        try {
            this.fetchFile(fileIdentifier, session, outFlowFile);
            session.transfer(outFlowFile, REL_SUCCESS);
        }
        catch (Exception e) {
            this.handleError(session, flowFile, fileIdentifier, e);
        }
    }

    private void fetchFile(String fileId, ProcessSession session, FlowFile outFlowFile) throws DbxException {
        InputStream dropboxInputStream = this.dropboxApiClient.files().download(fileId).getInputStream();
        session.importFrom(dropboxInputStream, outFlowFile);
    }

    private void handleError(ProcessSession session, FlowFile flowFile, String fileId, Exception e) {
        this.getLogger().error("Error while fetching and processing file with id '{}'", new Object[]{fileId, e});
        FlowFile outFlowFile = session.putAttribute(flowFile, ERROR_MESSAGE_ATTRIBUTE, e.getMessage());
        session.transfer(outFlowFile, REL_FAILURE);
    }

    private String correctFilePath(String folderName) {
        return folderName.startsWith("//") ? folderName.replaceFirst("//", "/") : folderName;
    }
}

