/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.distributed.cache.server;

import java.io.File;
import javax.net.ssl.SSLContext;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.distributed.cache.server.CacheServer;
import org.apache.nifi.distributed.cache.server.DistributedCacheServer;
import org.apache.nifi.distributed.cache.server.EvictionPolicy;
import org.apache.nifi.distributed.cache.server.set.StandardSetCacheServer;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.ssl.SSLContextService;

@Tags(value={"distributed", "set", "distinct", "cache", "server"})
@CapabilityDescription(value="Provides a set (collection of unique values) cache that can be accessed over a socket. Interaction with this service is typically accomplished via a DistributedSetCacheClient service.")
public class DistributedSetCacheServer
extends DistributedCacheServer {
    @Override
    protected CacheServer createCacheServer(ConfigurationContext context) {
        int port = context.getProperty(PORT).asInteger();
        String persistencePath = context.getProperty(PERSISTENCE_PATH).getValue();
        SSLContextService sslContextService = (SSLContextService)context.getProperty(SSL_CONTEXT_SERVICE).asControllerService(SSLContextService.class);
        int maxSize = context.getProperty(MAX_CACHE_ENTRIES).asInteger();
        String evictionPolicyName = context.getProperty(EVICTION_POLICY).getValue();
        int maxReadSize = context.getProperty(MAX_READ_SIZE).asDataSize(DataUnit.B).intValue();
        SSLContext sslContext = sslContextService == null ? null : sslContextService.createContext();
        EvictionPolicy evictionPolicy = switch (evictionPolicyName) {
            case "First In, First Out" -> EvictionPolicy.FIFO;
            case "Least Frequently Used" -> EvictionPolicy.LFU;
            case "Least Recently Used" -> EvictionPolicy.LRU;
            default -> throw new IllegalArgumentException("Illegal Eviction Policy: " + evictionPolicyName);
        };
        try {
            File persistenceDir = persistencePath == null ? null : new File(persistencePath);
            return new StandardSetCacheServer(this.getLogger(), this.getIdentifier(), sslContext, port, maxSize, evictionPolicy, persistenceDir, maxReadSize);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

