/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.distributed.cache.server.map;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.nifi.distributed.cache.server.CacheRecord;

public class MapCacheRecord
extends CacheRecord {
    private final ByteBuffer key;
    private final ByteBuffer value;
    private final long revision;

    public MapCacheRecord(ByteBuffer key, ByteBuffer value) {
        this(key, value, -1L);
    }

    public MapCacheRecord(ByteBuffer key, ByteBuffer value, long revision) {
        this.key = key;
        this.value = value;
        this.revision = revision;
    }

    public ByteBuffer getKey() {
        return this.key;
    }

    public ByteBuffer getValue() {
        return this.value;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.key, this.value, this.revision});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof MapCacheRecord) {
            MapCacheRecord that = (MapCacheRecord)obj;
            return this.key.equals(that.key) && this.value.equals(that.value) && this.revision == that.revision;
        }
        return false;
    }

    public long getRevision() {
        return this.revision;
    }
}

