/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.distributed.cache.client;

import java.io.IOException;
import org.apache.nifi.distributed.cache.client.DistributedCacheClient;
import org.apache.nifi.distributed.cache.client.adapter.BooleanInboundAdapter;
import org.apache.nifi.distributed.cache.client.adapter.OutboundAdapter;
import org.apache.nifi.distributed.cache.client.adapter.VoidInboundAdapter;
import org.apache.nifi.distributed.cache.operations.SetOperation;
import org.apache.nifi.remote.VersionNegotiatorFactory;
import org.apache.nifi.ssl.SSLContextService;

public class NettyDistributedSetCacheClient
extends DistributedCacheClient {
    public NettyDistributedSetCacheClient(String hostname, int port, int timeoutMillis, SSLContextService sslContextService, VersionNegotiatorFactory factory, String identifier) {
        super(hostname, port, timeoutMillis, sslContextService, factory, identifier);
    }

    public boolean addIfAbsent(byte[] value) throws IOException {
        OutboundAdapter outboundAdapter = new OutboundAdapter().write(SetOperation.ADD_IF_ABSENT.value()).write(value);
        BooleanInboundAdapter inboundAdapter = new BooleanInboundAdapter();
        this.invoke(outboundAdapter, inboundAdapter);
        return inboundAdapter.getResult();
    }

    public boolean contains(byte[] value) throws IOException {
        OutboundAdapter outboundAdapter = new OutboundAdapter().write(SetOperation.CONTAINS.value()).write(value);
        BooleanInboundAdapter inboundAdapter = new BooleanInboundAdapter();
        this.invoke(outboundAdapter, inboundAdapter);
        return inboundAdapter.getResult();
    }

    public boolean remove(byte[] value) throws IOException {
        OutboundAdapter outboundAdapter = new OutboundAdapter().write(SetOperation.REMOVE.value()).write(value);
        BooleanInboundAdapter inboundAdapter = new BooleanInboundAdapter();
        this.invoke(outboundAdapter, inboundAdapter);
        return inboundAdapter.getResult();
    }

    public void close() throws IOException {
        this.invoke(new OutboundAdapter().write(SetOperation.CLOSE.value()), new VoidInboundAdapter());
        this.closeChannelPool();
    }
}

