/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.distributed.cache.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.annotation.lifecycle.OnShutdown;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.distributed.cache.client.AtomicCacheEntry;
import org.apache.nifi.distributed.cache.client.AtomicDistributedMapCacheClient;
import org.apache.nifi.distributed.cache.client.CacheClientSerde;
import org.apache.nifi.distributed.cache.client.Deserializer;
import org.apache.nifi.distributed.cache.client.NettyDistributedMapCacheClient;
import org.apache.nifi.distributed.cache.client.Serializer;
import org.apache.nifi.distributed.cache.client.adapter.AtomicCacheEntryInboundAdapter;
import org.apache.nifi.distributed.cache.client.adapter.MapInboundAdapter;
import org.apache.nifi.distributed.cache.client.adapter.MapValuesInboundAdapter;
import org.apache.nifi.distributed.cache.client.adapter.SetInboundAdapter;
import org.apache.nifi.distributed.cache.client.adapter.ValueInboundAdapter;
import org.apache.nifi.distributed.cache.protocol.ProtocolVersion;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.remote.StandardVersionNegotiatorFactory;
import org.apache.nifi.remote.VersionNegotiatorFactory;
import org.apache.nifi.ssl.SSLContextService;

@Tags(value={"distributed", "cache", "state", "map", "cluster"})
@SeeAlso(classNames={"org.apache.nifi.distributed.cache.server.map.DistributedMapCacheServer", "org.apache.nifi.ssl.StandardSSLContextService"})
@CapabilityDescription(value="Provides the ability to communicate with a DistributedMapCacheServer. This can be used in order to share a Map between nodes in a NiFi cluster")
public class DistributedMapCacheClientService
extends AbstractControllerService
implements AtomicDistributedMapCacheClient<Long> {
    private static final long DEFAULT_CACHE_REVISION = 0L;
    public static final PropertyDescriptor HOSTNAME = new PropertyDescriptor.Builder().name("Server Hostname").description("The name of the server that is running the DistributedMapCacheServer service").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor PORT = new PropertyDescriptor.Builder().name("Server Port").description("The port on the remote server that is to be used when communicating with the DistributedMapCacheServer service").required(true).addValidator(StandardValidators.PORT_VALIDATOR).defaultValue("4557").build();
    public static final PropertyDescriptor SSL_CONTEXT_SERVICE = new PropertyDescriptor.Builder().name("SSL Context Service").description("If specified, indicates the SSL Context Service that is used to communicate with the remote server. If not specified, communications will not be encrypted").required(false).identifiesControllerService(SSLContextService.class).build();
    public static final PropertyDescriptor COMMUNICATIONS_TIMEOUT = new PropertyDescriptor.Builder().name("Communications Timeout").description("Specifies how long to wait when communicating with the remote server before determining that there is a communications failure if data cannot be sent or received").required(true).addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).defaultValue("30 secs").build();
    private volatile NettyDistributedMapCacheClient cacheClient = null;
    private volatile VersionNegotiatorFactory versionNegotiatorFactory = null;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> descriptors = new ArrayList<PropertyDescriptor>();
        descriptors.add(HOSTNAME);
        descriptors.add(PORT);
        descriptors.add(SSL_CONTEXT_SERVICE);
        descriptors.add(COMMUNICATIONS_TIMEOUT);
        return descriptors;
    }

    @OnEnabled
    public void onEnabled(ConfigurationContext context) {
        this.getLogger().debug("Enabling Map Cache Client Service [{}]", new Object[]{context.getName()});
        this.versionNegotiatorFactory = new StandardVersionNegotiatorFactory(new int[]{ProtocolVersion.V3.value(), ProtocolVersion.V2.value(), ProtocolVersion.V1.value()});
        this.cacheClient = new NettyDistributedMapCacheClient(context.getProperty(HOSTNAME).getValue(), context.getProperty(PORT).asInteger(), context.getProperty(COMMUNICATIONS_TIMEOUT).asTimePeriod(TimeUnit.MILLISECONDS).intValue(), (SSLContextService)context.getProperty(SSL_CONTEXT_SERVICE).asControllerService(SSLContextService.class), this.versionNegotiatorFactory, this.getIdentifier(), this.getLogger());
    }

    @OnShutdown
    @OnDisabled
    public void onDisabled() throws IOException {
        if (this.cacheClient != null) {
            this.cacheClient.close();
        }
        this.versionNegotiatorFactory = null;
        this.cacheClient = null;
    }

    public <K, V> boolean putIfAbsent(K key, V value, Serializer<K> keySerializer, Serializer<V> valueSerializer) throws IOException {
        byte[] bytesKey = CacheClientSerde.serialize(key, keySerializer);
        byte[] bytesValue = CacheClientSerde.serialize(value, valueSerializer);
        return this.cacheClient.putIfAbsent(bytesKey, bytesValue);
    }

    public <K, V> void put(K key, V value, Serializer<K> keySerializer, Serializer<V> valueSerializer) throws IOException {
        byte[] bytesKey = CacheClientSerde.serialize(key, keySerializer);
        byte[] bytesValue = CacheClientSerde.serialize(value, valueSerializer);
        this.cacheClient.put(bytesKey, bytesValue);
    }

    public <K> boolean containsKey(K key, Serializer<K> keySerializer) throws IOException {
        byte[] bytesKey = CacheClientSerde.serialize(key, keySerializer);
        return this.cacheClient.containsKey(bytesKey);
    }

    public <K, V> V getAndPutIfAbsent(K key, V value, Serializer<K> keySerializer, Serializer<V> valueSerializer, Deserializer<V> valueDeserializer) throws IOException {
        byte[] bytesKey = CacheClientSerde.serialize(key, keySerializer);
        byte[] bytesValue = CacheClientSerde.serialize(value, valueSerializer);
        ValueInboundAdapter<V> inboundAdapter = new ValueInboundAdapter<V>(valueDeserializer);
        return this.cacheClient.getAndPutIfAbsent(bytesKey, bytesValue, inboundAdapter);
    }

    public <K, V> V get(K key, Serializer<K> keySerializer, Deserializer<V> valueDeserializer) throws IOException {
        byte[] bytesKey = CacheClientSerde.serialize(key, keySerializer);
        ValueInboundAdapter<V> inboundAdapter = new ValueInboundAdapter<V>(valueDeserializer);
        return this.cacheClient.get(bytesKey, inboundAdapter);
    }

    public <K, V> Map<K, V> subMap(Set<K> keys, Serializer<K> keySerializer, Deserializer<V> valueDeserializer) throws IOException {
        Collection<byte[]> bytesKeys = CacheClientSerde.serialize(keys, keySerializer);
        MapValuesInboundAdapter<K, V> inboundAdapter = new MapValuesInboundAdapter<K, V>(keys, valueDeserializer, new HashMap());
        return this.cacheClient.subMap(bytesKeys, inboundAdapter);
    }

    public <K> boolean remove(K key, Serializer<K> serializer) throws IOException {
        byte[] bytesKey = CacheClientSerde.serialize(key, serializer);
        return this.cacheClient.remove(bytesKey);
    }

    public <K, V> V removeAndGet(K key, Serializer<K> keySerializer, Deserializer<V> valueDeserializer) throws IOException {
        byte[] bytesKey = CacheClientSerde.serialize(key, keySerializer);
        ValueInboundAdapter<V> inboundAdapter = new ValueInboundAdapter<V>(valueDeserializer);
        return this.cacheClient.removeAndGet(bytesKey, inboundAdapter);
    }

    public long removeByPattern(String regex) throws IOException {
        return this.cacheClient.removeByPattern(regex);
    }

    public <K, V> Map<K, V> removeByPatternAndGet(String regex, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) throws IOException {
        MapInboundAdapter<K, V> inboundAdapter = new MapInboundAdapter<K, V>(keyDeserializer, valueDeserializer, new HashMap());
        return this.cacheClient.removeByPatternAndGet(regex, inboundAdapter);
    }

    public <K, V> AtomicCacheEntry<K, V, Long> fetch(K key, Serializer<K> keySerializer, Deserializer<V> valueDeserializer) throws IOException {
        byte[] bytesKey = CacheClientSerde.serialize(key, keySerializer);
        AtomicCacheEntryInboundAdapter<K, V> inboundAdapter = new AtomicCacheEntryInboundAdapter<K, V>(key, valueDeserializer);
        return this.cacheClient.fetch(bytesKey, inboundAdapter);
    }

    public <K, V> boolean replace(AtomicCacheEntry<K, V, Long> entry, Serializer<K> keySerializer, Serializer<V> valueSerializer) throws IOException {
        byte[] bytesKey = CacheClientSerde.serialize(entry.getKey(), keySerializer);
        byte[] bytesValue = CacheClientSerde.serialize(entry.getValue(), valueSerializer);
        long revision = entry.getRevision().orElse(0L);
        return this.cacheClient.replace(bytesKey, bytesValue, revision);
    }

    public <K> Set<K> keySet(Deserializer<K> keyDeserializer) throws IOException {
        SetInboundAdapter<K> inboundAdapter = new SetInboundAdapter<K>(keyDeserializer, new HashSet());
        return this.cacheClient.keySet(inboundAdapter);
    }

    public void close() throws IOException {
        if (this.isEnabled()) {
            this.onDisabled();
        }
    }
}

