/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.distributed.cache.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import java.io.IOException;
import org.apache.nifi.distributed.cache.client.CacheClientHandshakeHandler;
import org.apache.nifi.distributed.cache.client.adapter.InboundAdapter;
import org.apache.nifi.distributed.cache.client.adapter.NullInboundAdapter;
import org.apache.nifi.distributed.cache.client.adapter.OutboundAdapter;

public class CacheClientRequestHandler
extends ChannelInboundHandlerAdapter {
    private InboundAdapter inboundAdapter = new NullInboundAdapter();
    private ChannelPromise channelPromise;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        ByteBuf byteBuf = (ByteBuf)msg;
        try {
            byte[] bytes = new byte[byteBuf.readableBytes()];
            byteBuf.readBytes(bytes);
            this.inboundAdapter.queue(bytes);
        }
        finally {
            byteBuf.release();
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws IOException {
        this.inboundAdapter.dequeue();
        if (this.inboundAdapter.isComplete() && !this.channelPromise.isSuccess()) {
            this.channelPromise.setSuccess();
        }
    }

    public void channelUnregistered(ChannelHandlerContext ctx) {
        if (!this.inboundAdapter.isComplete()) {
            this.channelPromise.setFailure((Throwable)new IOException("Channel unregistered before processing completed: " + ctx.channel().toString()));
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.channelPromise.setFailure(cause);
    }

    public void invoke(Channel channel, OutboundAdapter outboundAdapter, InboundAdapter inboundAdapter) throws IOException {
        CacheClientHandshakeHandler handshakeHandler = (CacheClientHandshakeHandler)channel.pipeline().get(CacheClientHandshakeHandler.class);
        handshakeHandler.waitHandshakeComplete();
        if (handshakeHandler.isSuccess()) {
            if (handshakeHandler.getVersionNegotiator().getVersion() < outboundAdapter.getMinimumVersion()) {
                throw new UnsupportedOperationException("Remote cache server doesn't support protocol version " + outboundAdapter.getMinimumVersion());
            }
            this.inboundAdapter = inboundAdapter;
            this.channelPromise = channel.newPromise();
            channel.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])outboundAdapter.toBytes()));
            this.channelPromise.awaitUninterruptibly();
            this.inboundAdapter = new NullInboundAdapter();
            if (this.channelPromise.cause() != null) {
                throw new IOException("Request invocation failed", this.channelPromise.cause());
            }
        } else {
            throw new IOException("Request invocation failed", handshakeHandler.cause());
        }
    }
}

