/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.distributed.cache.client;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.handler.timeout.WriteTimeoutHandler;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.apache.nifi.distributed.cache.client.CacheClientHandshakeHandler;
import org.apache.nifi.distributed.cache.client.CacheClientRequestHandler;
import org.apache.nifi.event.transport.netty.CloseContextIdleStateHandler;
import org.apache.nifi.remote.VersionNegotiator;
import org.apache.nifi.remote.VersionNegotiatorFactory;

public class CacheClientChannelInitializer
extends ChannelInitializer<Channel> {
    private final SSLContext sslContext;
    private final VersionNegotiatorFactory versionNegotiatorFactory;
    private final Duration idleTimeout;
    private final Duration writeTimeout;

    public CacheClientChannelInitializer(SSLContext sslContext, VersionNegotiatorFactory factory, Duration idleTimeout, Duration writeTimeout) {
        this.sslContext = sslContext;
        this.versionNegotiatorFactory = factory;
        this.idleTimeout = idleTimeout;
        this.writeTimeout = writeTimeout;
    }

    protected void initChannel(Channel channel) {
        ChannelPipeline channelPipeline = channel.pipeline();
        if (this.sslContext != null) {
            SSLEngine sslEngine = this.sslContext.createSSLEngine();
            sslEngine.setUseClientMode(true);
            SslHandler sslHandler = new SslHandler(sslEngine);
            channelPipeline.addLast(new ChannelHandler[]{sslHandler});
        }
        VersionNegotiator versionNegotiator = this.versionNegotiatorFactory.create();
        channelPipeline.addFirst(new ChannelHandler[]{new IdleStateHandler(this.idleTimeout.getSeconds(), this.idleTimeout.getSeconds(), this.idleTimeout.getSeconds(), TimeUnit.SECONDS)});
        channelPipeline.addLast(new ChannelHandler[]{new WriteTimeoutHandler(this.writeTimeout.toMillis(), TimeUnit.MILLISECONDS)});
        channelPipeline.addLast(new ChannelHandler[]{new CacheClientHandshakeHandler(channel, versionNegotiator, this.writeTimeout.toMillis())});
        channelPipeline.addLast(new ChannelHandler[]{new CacheClientRequestHandler()});
        channelPipeline.addLast(new ChannelHandler[]{new CloseContextIdleStateHandler()});
    }
}

