/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.distributed.cache.client;

import io.netty.channel.Channel;
import io.netty.channel.pool.ChannelPool;
import java.io.IOException;
import org.apache.nifi.distributed.cache.client.CacheClientChannelPoolFactory;
import org.apache.nifi.distributed.cache.client.CacheClientRequestHandler;
import org.apache.nifi.distributed.cache.client.adapter.InboundAdapter;
import org.apache.nifi.distributed.cache.client.adapter.OutboundAdapter;
import org.apache.nifi.remote.VersionNegotiatorFactory;
import org.apache.nifi.ssl.SSLContextService;

public class DistributedCacheClient {
    private final ChannelPool channelPool;

    protected DistributedCacheClient(String hostname, int port, int timeoutMillis, SSLContextService sslContextService, VersionNegotiatorFactory factory) {
        this.channelPool = new CacheClientChannelPoolFactory().createChannelPool(hostname, port, timeoutMillis, sslContextService, factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invoke(OutboundAdapter outboundAdapter, InboundAdapter inboundAdapter) throws IOException {
        Channel channel = (Channel)this.channelPool.acquire().syncUninterruptibly().getNow();
        try {
            CacheClientRequestHandler requestHandler = (CacheClientRequestHandler)channel.pipeline().get(CacheClientRequestHandler.class);
            requestHandler.invoke(channel, outboundAdapter, inboundAdapter);
        }
        finally {
            this.channelPool.release(channel).syncUninterruptibly();
        }
    }

    protected void closeChannelPool() {
        this.channelPool.close();
    }
}

