/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.distributed.cache.client;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.pool.ChannelHealthChecker;
import io.netty.channel.pool.ChannelPool;
import io.netty.channel.pool.ChannelPoolHandler;
import io.netty.channel.pool.FixedChannelPool;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.time.Duration;
import javax.net.ssl.SSLContext;
import org.apache.nifi.distributed.cache.client.CacheClientChannelInitializer;
import org.apache.nifi.event.transport.netty.channel.pool.InitializingChannelPoolHandler;
import org.apache.nifi.remote.VersionNegotiatorFactory;
import org.apache.nifi.ssl.SSLContextService;

public class CacheClientChannelPoolFactory {
    private static final int MAX_PENDING_ACQUIRES = 1024;
    private int maxConnections = Runtime.getRuntime().availableProcessors() * 2;

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public ChannelPool createChannelPool(String hostname, int port, int timeoutMillis, SSLContextService sslContextService, VersionNegotiatorFactory factory) {
        SSLContext sslContext = sslContextService == null ? null : sslContextService.createContext();
        NioEventLoopGroup group = new NioEventLoopGroup();
        Bootstrap bootstrap = new Bootstrap();
        CacheClientChannelInitializer initializer = new CacheClientChannelInitializer(sslContext, factory, Duration.ofMillis(timeoutMillis), Duration.ofMillis(timeoutMillis));
        ((Bootstrap)((Bootstrap)bootstrap.group((EventLoopGroup)group)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)timeoutMillis)).remoteAddress(hostname, port).channel(NioSocketChannel.class);
        InitializingChannelPoolHandler channelPoolHandler = new InitializingChannelPoolHandler((ChannelInitializer)initializer);
        return new FixedChannelPool(bootstrap, (ChannelPoolHandler)channelPoolHandler, ChannelHealthChecker.ACTIVE, FixedChannelPool.AcquireTimeoutAction.FAIL, (long)timeoutMillis, this.maxConnections, 1024);
    }
}

