/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.distributed.cache.client.adapter;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.Map;
import org.apache.nifi.distributed.cache.client.Deserializer;
import org.apache.nifi.distributed.cache.client.adapter.InboundAdapter;
import org.apache.nifi.distributed.cache.client.adapter.InboundToken;

public class MapInboundAdapter<K, V>
implements InboundAdapter {
    private final Deserializer<K> deserializerK;
    private final Deserializer<V> deserializerV;
    private final ByteBuf byteBuf;
    private final InboundToken<K> inboundTokenK;
    private final InboundToken<V> inboundTokenV;
    private Integer size;
    private final Map<K, V> result;

    public MapInboundAdapter(Deserializer<K> deserializerK, Deserializer<V> deserializerV, Map<K, V> result) {
        this.deserializerK = deserializerK;
        this.deserializerV = deserializerV;
        this.byteBuf = Unpooled.buffer();
        this.inboundTokenK = new InboundToken();
        this.inboundTokenV = new InboundToken();
        this.size = null;
        this.result = result;
    }

    public Map<K, V> getResult() {
        return this.result;
    }

    @Override
    public boolean isComplete() {
        return this.size != null && this.result.size() >= this.size;
    }

    @Override
    public void queue(byte[] bytes) {
        this.byteBuf.writeBytes(bytes);
    }

    @Override
    public void dequeue() throws IOException {
        if (this.size == null && this.byteBuf.readableBytes() >= 4) {
            this.size = this.byteBuf.readInt();
        }
        while (this.size != null && this.result.size() < this.size) {
            if (!this.inboundTokenK.isComplete()) {
                this.inboundTokenK.update(this.byteBuf, this.deserializerK);
            }
            if (this.inboundTokenK.isComplete() && !this.inboundTokenV.isComplete()) {
                this.inboundTokenV.update(this.byteBuf, this.deserializerV);
            }
            if (!this.inboundTokenK.isComplete() || !this.inboundTokenV.isComplete()) break;
            this.result.put(this.inboundTokenK.getValue(), this.inboundTokenV.getValue());
            this.inboundTokenK.reset();
            this.inboundTokenV.reset();
        }
    }
}

