/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.reporting.datadog;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.DeprecationNotice;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.controller.status.ConnectionStatus;
import org.apache.nifi.controller.status.PortStatus;
import org.apache.nifi.controller.status.ProcessGroupStatus;
import org.apache.nifi.controller.status.ProcessorStatus;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.metrics.jvm.JmxJvmMetrics;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.reporting.AbstractReportingTask;
import org.apache.nifi.reporting.ReportingContext;
import org.apache.nifi.reporting.datadog.DDMetricRegistryBuilder;
import org.apache.nifi.reporting.datadog.metrics.MetricsService;
import org.coursera.metrics.datadog.DynamicTagsCallback;

@Tags(value={"reporting", "datadog", "metrics"})
@DeprecationNotice(reason="This reporting task is deprecated and will be removed in NiFi 2.x.")
@CapabilityDescription(value="Publishes metrics from NiFi to datadog. For accurate and informative reporting, components should have unique names.")
public class DataDogReportingTask
extends AbstractReportingTask {
    static final AllowableValue DATADOG_AGENT = new AllowableValue("Datadog Agent", "Datadog Agent", "Metrics will be sent via locally installed Datadog agent. Datadog agent needs to be installed manually before using this option");
    static final AllowableValue DATADOG_HTTP = new AllowableValue("Datadog HTTP", "Datadog HTTP", "Metrics will be sent via HTTP transport with no need of Agent installed. Datadog API key needs to be set");
    static final PropertyDescriptor DATADOG_TRANSPORT = new PropertyDescriptor.Builder().name("Datadog transport").description("Transport through which metrics will be sent to Datadog").required(true).allowableValues(new AllowableValue[]{DATADOG_AGENT, DATADOG_HTTP}).defaultValue(DATADOG_HTTP.getValue()).build();
    static final PropertyDescriptor API_KEY = new PropertyDescriptor.Builder().name("API key").description("Datadog API key. If specified value is 'agent', local Datadog agent will be used.").required(false).sensitive(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    static final PropertyDescriptor METRICS_PREFIX = new PropertyDescriptor.Builder().name("Metrics prefix").description("Prefix to be added before every metric").required(true).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).defaultValue("nifi").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    static final PropertyDescriptor ENVIRONMENT = new PropertyDescriptor.Builder().name("Environment").description("Environment, dataflow is running in. This property will be included as metrics tag.").required(true).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).defaultValue("dev").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    private MetricsService metricsService;
    private DDMetricRegistryBuilder ddMetricRegistryBuilder;
    private MetricRegistry metricRegistry;
    private String metricsPrefix;
    private String environment;
    private ConcurrentHashMap<String, Double> metricsMap;
    private Map<String, String> defaultTags;
    private volatile JmxJvmMetrics virtualMachineMetrics;

    @OnScheduled
    public void setup(ConfigurationContext context) {
        this.metricsService = this.getMetricsService();
        this.ddMetricRegistryBuilder = this.getMetricRegistryBuilder();
        this.metricRegistry = this.getMetricRegistry();
        this.metricsMap = this.getMetricsMap();
        this.metricsPrefix = METRICS_PREFIX.getDefaultValue();
        this.environment = ENVIRONMENT.getDefaultValue();
        this.virtualMachineMetrics = JmxJvmMetrics.getInstance();
        this.ddMetricRegistryBuilder.setMetricRegistry(this.metricRegistry);
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(METRICS_PREFIX);
        properties.add(ENVIRONMENT);
        properties.add(API_KEY);
        properties.add(DATADOG_TRANSPORT);
        return properties;
    }

    public void onTrigger(ReportingContext context) {
        ProcessGroupStatus status = context.getEventAccess().getControllerStatus();
        this.metricsPrefix = context.getProperty(METRICS_PREFIX).evaluateAttributeExpressions().getValue();
        this.environment = context.getProperty(ENVIRONMENT).evaluateAttributeExpressions().getValue();
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("env", this.environment);
        tags.put("dataflow_id", status.getId());
        this.defaultTags = Collections.unmodifiableMap(tags);
        try {
            this.updateDataDogTransport(context);
        }
        catch (IOException e) {
            this.getLogger().warn("Unable to update data dog transport", (Throwable)e);
        }
        this.updateAllMetricGroups(status);
        this.ddMetricRegistryBuilder.getDatadogReporter().report();
    }

    protected void updateMetrics(Map<String, Double> metrics, Map<String, String> tags) {
        for (Map.Entry<String, Double> entry : metrics.entrySet()) {
            String metricName = this.buildMetricName(entry.getKey());
            this.getLogger().debug("Metric [{}] Value [{}]", new Object[]{metricName, entry.getValue()});
            if (!this.metricsMap.containsKey(metricName)) {
                this.metricsMap.put(metricName, entry.getValue());
                this.metricRegistry.register(metricName, (Metric)new MetricGauge(metricName, tags));
            }
            this.metricsMap.put(metricName, entry.getValue());
        }
    }

    private void updateAllMetricGroups(ProcessGroupStatus processGroupStatus) {
        ArrayList<ProcessorStatus> processorStatuses = new ArrayList<ProcessorStatus>();
        this.populateProcessorStatuses(processGroupStatus, processorStatuses);
        for (ProcessorStatus processorStatus : processorStatuses) {
            HashMap<String, String> hashMap = new HashMap<String, String>(this.defaultTags);
            hashMap.putAll(this.metricsService.getProcessorTags(processorStatus));
            this.updateMetrics(this.metricsService.getProcessorMetrics(processorStatus), hashMap);
        }
        ArrayList<ConnectionStatus> connectionStatuses = new ArrayList<ConnectionStatus>();
        this.populateConnectionStatuses(processGroupStatus, connectionStatuses);
        for (ConnectionStatus connectionStatus : connectionStatuses) {
            this.updateMetrics(this.metricsService.getConnectionStatusMetrics(connectionStatus), this.defaultTags);
        }
        ArrayList<PortStatus> arrayList = new ArrayList<PortStatus>();
        this.populateInputPortStatuses(processGroupStatus, arrayList);
        for (PortStatus portStatus : arrayList) {
            this.updateMetrics(this.metricsService.getPortStatusMetrics(portStatus), this.defaultTags);
        }
        ArrayList<PortStatus> arrayList2 = new ArrayList<PortStatus>();
        this.populateOutputPortStatuses(processGroupStatus, arrayList2);
        for (PortStatus portStatus : arrayList2) {
            this.updateMetrics(this.metricsService.getPortStatusMetrics(portStatus), this.defaultTags);
        }
        this.updateMetrics(this.metricsService.getJVMMetrics(this.virtualMachineMetrics), this.defaultTags);
        this.updateMetrics(this.metricsService.getDataFlowMetrics(processGroupStatus), this.defaultTags);
    }

    private void updateDataDogTransport(ReportingContext context) throws IOException {
        String dataDogTransport = context.getProperty(DATADOG_TRANSPORT).getValue();
        if (dataDogTransport.equalsIgnoreCase(DATADOG_AGENT.getValue())) {
            this.ddMetricRegistryBuilder.build("agent");
        } else if (dataDogTransport.equalsIgnoreCase(DATADOG_HTTP.getValue()) && context.getProperty(API_KEY).isSet()) {
            this.ddMetricRegistryBuilder.build(context.getProperty(API_KEY).getValue());
        }
    }

    private void populateProcessorStatuses(ProcessGroupStatus groupStatus, List<ProcessorStatus> statuses) {
        statuses.addAll(groupStatus.getProcessorStatus());
        for (ProcessGroupStatus childGroupStatus : groupStatus.getProcessGroupStatus()) {
            this.populateProcessorStatuses(childGroupStatus, statuses);
        }
    }

    private void populateConnectionStatuses(ProcessGroupStatus groupStatus, List<ConnectionStatus> statuses) {
        statuses.addAll(groupStatus.getConnectionStatus());
        for (ProcessGroupStatus childGroupStatus : groupStatus.getProcessGroupStatus()) {
            this.populateConnectionStatuses(childGroupStatus, statuses);
        }
    }

    private void populateInputPortStatuses(ProcessGroupStatus groupStatus, List<PortStatus> statuses) {
        statuses.addAll(groupStatus.getInputPortStatus());
        for (ProcessGroupStatus childGroupStatus : groupStatus.getProcessGroupStatus()) {
            this.populateInputPortStatuses(childGroupStatus, statuses);
        }
    }

    private void populateOutputPortStatuses(ProcessGroupStatus groupStatus, List<PortStatus> statuses) {
        statuses.addAll(groupStatus.getOutputPortStatus());
        for (ProcessGroupStatus childGroupStatus : groupStatus.getProcessGroupStatus()) {
            this.populateOutputPortStatuses(childGroupStatus, statuses);
        }
    }

    private String buildMetricName(String metricName) {
        return this.metricsPrefix + "." + metricName;
    }

    protected MetricsService getMetricsService() {
        return new MetricsService();
    }

    protected DDMetricRegistryBuilder getMetricRegistryBuilder() {
        return new DDMetricRegistryBuilder();
    }

    protected MetricRegistry getMetricRegistry() {
        return new MetricRegistry();
    }

    protected ConcurrentHashMap<String, Double> getMetricsMap() {
        return new ConcurrentHashMap<String, Double>();
    }

    private class MetricGauge
    implements Gauge<Object>,
    DynamicTagsCallback {
        private final Map<String, String> tags;
        private final String metricName;

        public MetricGauge(String metricName, Map<String, String> tagsMap) {
            this.tags = tagsMap;
            this.metricName = metricName;
        }

        public Object getValue() {
            return DataDogReportingTask.this.metricsMap.get(this.metricName);
        }

        public List<String> getTags() {
            ArrayList<String> tagsList = new ArrayList<String>();
            for (Map.Entry<String, String> entry : this.tags.entrySet()) {
                tagsList.add(entry.getKey() + ":" + entry.getValue());
            }
            return tagsList;
        }
    }
}

