/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.reporting.datadog;

import com.codahale.metrics.MetricRegistry;
import java.io.IOException;
import java.net.InetAddress;
import org.coursera.metrics.datadog.DatadogReporter;
import org.coursera.metrics.datadog.transport.HttpTransport;
import org.coursera.metrics.datadog.transport.Transport;
import org.coursera.metrics.datadog.transport.UdpTransport;

public class DDMetricRegistryBuilder {
    private MetricRegistry metricRegistry = null;
    private DatadogReporter datadogReporter;
    private String apiKey = "";
    private Transport transport;

    public DDMetricRegistryBuilder setMetricRegistry(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
        return this;
    }

    public DatadogReporter getDatadogReporter() {
        return this.datadogReporter;
    }

    public MetricRegistry build(String apiKey) throws IOException {
        if (this.metricRegistry == null) {
            this.metricRegistry = new MetricRegistry();
        }
        if (this.createTransport(apiKey)) {
            this.datadogReporter = this.createDatadogReporter(this.metricRegistry);
        }
        return this.metricRegistry;
    }

    private boolean createTransport(String apiKey) {
        if (this.apiKey.equals(apiKey)) {
            return false;
        }
        if (apiKey.equals("agent")) {
            this.apiKey = "agent";
            this.transport = new UdpTransport.Builder().build();
            return true;
        }
        this.apiKey = apiKey;
        this.transport = new HttpTransport.Builder().withApiKey(apiKey).build();
        return true;
    }

    private DatadogReporter createDatadogReporter(MetricRegistry metricRegistry) throws IOException {
        DatadogReporter reporter = DatadogReporter.forRegistry((MetricRegistry)metricRegistry).withHost(InetAddress.getLocalHost().getHostName()).withTransport(this.transport).build();
        return reporter;
    }
}

