/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web;

import javax.servlet.http.HttpServletRequest;
import org.apache.nifi.web.HttpServletRequestContext;
import org.apache.nifi.web.NiFiWebConfigurationRequestContext;
import org.apache.nifi.web.Revision;
import org.apache.nifi.web.UiExtensionType;

public class HttpServletConfigurationRequestContext
extends HttpServletRequestContext
implements NiFiWebConfigurationRequestContext {
    private static final String ID_PARAM = "id";
    private static final String CLIENT_ID_PARAM = "clientId";
    private static final String REVISION_PARAM = "revision";
    private static final String DISCONNECTION_ACKNOWLEDGED_PARAM = "disconnectedNodeAcknowledged";
    private final HttpServletRequest request;

    public HttpServletConfigurationRequestContext(UiExtensionType extensionType, HttpServletRequest request) {
        super(extensionType, request);
        this.request = request;
    }

    public Revision getRevision() {
        Long revision;
        String revisionParamVal = this.request.getParameter(REVISION_PARAM);
        try {
            revision = Long.parseLong(revisionParamVal);
        }
        catch (Exception ex) {
            revision = null;
        }
        String clientId = this.request.getParameter(CLIENT_ID_PARAM);
        String componentId = this.request.getParameter(ID_PARAM);
        return new Revision(revision, clientId, componentId);
    }

    public boolean isDisconnectionAcknowledged() {
        String disconnectionAcknowledgedVal = this.request.getParameter(DISCONNECTION_ACKNOWLEDGED_PARAM);
        return Boolean.valueOf(disconnectionAcknowledgedVal);
    }
}

