/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.couchbase;

import com.couchbase.client.core.CouchbaseException;
import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.CouchbaseCluster;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.DeprecationNotice;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.couchbase.CouchbaseClusterControllerService;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.util.StringUtils;

@CapabilityDescription(value="Provides a centralized Couchbase connection and bucket passwords management. Bucket passwords can be specified via dynamic properties.")
@Tags(value={"nosql", "couchbase", "database", "connection"})
@DynamicProperty(name="Bucket Password for BUCKET_NAME", value="bucket password", description="Specify bucket password if necessary. Couchbase Server 5.0 or later should use 'User Name' and 'User Password' instead.")
@DeprecationNotice(reason="This component is deprecated and will be removed in NiFi 2.x.")
public class CouchbaseClusterService
extends AbstractControllerService
implements CouchbaseClusterControllerService {
    public static final PropertyDescriptor CONNECTION_STRING = new PropertyDescriptor.Builder().name("Connection String").description("The hostnames or ip addresses of the bootstraping nodes and optional parameters. Syntax) couchbase://node1,node2,nodeN?param1=value1&param2=value2&paramN=valueN").required(true).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor USER_NAME = new PropertyDescriptor.Builder().name("user-name").displayName("User Name").description("The user name to authenticate NiFi as a Couchbase client. This configuration can be used against Couchbase Server 5.0 or later supporting Roll-Based Access Control.").required(false).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor USER_PASSWORD = new PropertyDescriptor.Builder().name("user-password").displayName("User Password").description("The user password to authenticate NiFi as a Couchbase client. This configuration can be used against Couchbase Server 5.0 or later supporting Roll-Based Access Control.").required(false).sensitive(true).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    private static final List<PropertyDescriptor> properties;
    private static final String DYNAMIC_PROP_BUCKET_PASSWORD = "Bucket Password for ";
    private Map<String, String> bucketPasswords;
    private volatile CouchbaseCluster cluster;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return properties;
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        if (propertyDescriptorName.startsWith(DYNAMIC_PROP_BUCKET_PASSWORD)) {
            return new PropertyDescriptor.Builder().name(propertyDescriptorName).description("Bucket password.").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).dynamic(true).sensitive(true).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
        }
        return null;
    }

    protected Collection<ValidationResult> customValidate(ValidationContext context) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        boolean isUserNameSet = context.getProperty(USER_NAME).isSet();
        boolean isUserPasswordSet = context.getProperty(USER_PASSWORD).isSet();
        if (isUserNameSet && !isUserPasswordSet || !isUserNameSet && isUserPasswordSet) {
            results.add(new ValidationResult.Builder().subject("User Name and Password").explanation("Both User Name and Password are required to use.").build());
        }
        boolean isBucketPasswordSet = context.getProperties().keySet().stream().anyMatch(p -> p.isDynamic() && p.getName().startsWith(DYNAMIC_PROP_BUCKET_PASSWORD));
        if (isUserNameSet && isUserPasswordSet && isBucketPasswordSet) {
            results.add(new ValidationResult.Builder().subject("Authentication methods").explanation("Different authentication methods can not be used at the same time, Use either one of User Name and Password, or Bucket Password.").build());
        }
        return results;
    }

    @OnEnabled
    public void onConfigured(ConfigurationContext context) throws InitializationException {
        this.bucketPasswords = new HashMap<String, String>();
        for (PropertyDescriptor p : context.getProperties().keySet()) {
            if (!p.isDynamic() || !p.getName().startsWith(DYNAMIC_PROP_BUCKET_PASSWORD)) continue;
            String bucketName = p.getName().substring(DYNAMIC_PROP_BUCKET_PASSWORD.length());
            String password = context.getProperty(p).evaluateAttributeExpressions().getValue();
            this.bucketPasswords.put(bucketName, password);
        }
        String userName = context.getProperty(USER_NAME).evaluateAttributeExpressions().getValue();
        String userPassword = context.getProperty(USER_PASSWORD).evaluateAttributeExpressions().getValue();
        try {
            this.cluster = CouchbaseCluster.fromConnectionString((String)context.getProperty(CONNECTION_STRING).evaluateAttributeExpressions().getValue());
            if (!StringUtils.isEmpty((String)userName) && !StringUtils.isEmpty((String)userPassword)) {
                this.cluster.authenticate(userName, userPassword);
            }
        }
        catch (CouchbaseException e) {
            throw new InitializationException((Throwable)e);
        }
    }

    public Bucket openBucket(String bucketName) {
        if (this.bucketPasswords.containsKey(bucketName)) {
            return this.cluster.openBucket(bucketName, this.bucketPasswords.get(bucketName));
        }
        return this.cluster.openBucket(bucketName);
    }

    @OnDisabled
    public void shutdown() {
        if (this.cluster != null) {
            this.cluster.disconnect();
            this.cluster = null;
        }
    }

    static {
        ArrayList<PropertyDescriptor> props = new ArrayList<PropertyDescriptor>();
        props.add(CONNECTION_STRING);
        props.add(USER_NAME);
        props.add(USER_PASSWORD);
        properties = Collections.unmodifiableList(props);
    }
}

