/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.couchbase;

import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.document.Document;
import com.couchbase.client.java.document.LegacyDocument;
import java.nio.charset.StandardCharsets;

public class CouchbaseUtils {
    public static String getStringContent(Bucket bucket, String id) {
        LegacyDocument doc = (LegacyDocument)bucket.get((Document)LegacyDocument.create((String)id));
        if (doc == null) {
            return null;
        }
        Object content = doc.content();
        return CouchbaseUtils.getStringContent(content);
    }

    public static String getStringContent(Object content) {
        if (content instanceof String) {
            return (String)content;
        }
        if (content instanceof byte[]) {
            return new String((byte[])content, StandardCharsets.UTF_8);
        }
        if (content instanceof ByteBuf) {
            ByteBuf byteBuf = (ByteBuf)content;
            byte[] bytes = new byte[byteBuf.readableBytes()];
            byteBuf.readBytes(bytes);
            byteBuf.release();
            return new String(bytes, StandardCharsets.UTF_8);
        }
        return content.toString();
    }
}

