/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.cipher.age;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.components.resource.ResourceReference;
import org.apache.nifi.components.resource.ResourceReferences;
import org.apache.nifi.components.resource.ResourceType;
import org.apache.nifi.components.resource.StandardResourceReferences;
import org.apache.nifi.components.resource.Utf8TextResource;
import org.apache.nifi.processors.cipher.age.AgeKeyIndicator;

public class AgeKeyValidator
implements Validator {
    private static final String FILE_RESOURCE_EXPLANATION = "File resource validation passed";
    private static final String RESOURCE_EXCEPTION = "Read failed: %s";
    private static final String NOT_FOUND_EXPLANATION = "Encoded keys not found";
    private static final String INVALID_EXPLANATION = "Invalid keys found [%d]";
    private static final String VALID_EXPLANATION = "Valid keys found";
    private static final String EXPLANATION_SEPARATOR = " and ";
    private final AgeKeyIndicator ageKeyIndicator;

    public AgeKeyValidator(AgeKeyIndicator ageKeyIndicator) {
        this.ageKeyIndicator = ageKeyIndicator;
    }

    public ValidationResult validate(String subject, String input, ValidationContext context) {
        PropertyValue propertyValue = this.getPropertyValue(subject, context);
        ResourceReferences resources = propertyValue.asResources();
        if (resources == null) {
            Utf8TextResource resourceReference = new Utf8TextResource(input);
            resources = new StandardResourceReferences(Collections.singletonList(resourceReference));
        }
        ValidationResult.Builder builder = new ValidationResult.Builder();
        builder.subject(subject);
        Set results = resources.asList().stream().map(this::validateResource).collect(Collectors.toSet());
        String invalidExplanation = results.stream().filter(result -> !result.isValid()).map(ValidationResult::getExplanation).collect(Collectors.joining(EXPLANATION_SEPARATOR));
        if (invalidExplanation.isEmpty()) {
            builder.explanation(VALID_EXPLANATION).valid(true);
        } else {
            builder.explanation(invalidExplanation).valid(false);
        }
        return builder.build();
    }

    private PropertyValue getPropertyValue(String subject, ValidationContext context) {
        Optional<PropertyDescriptor> propertyFound = context.getProperties().keySet().stream().filter(s -> s.getName().contentEquals(subject)).findFirst();
        String message = String.format("Property [%s] not found", subject);
        PropertyDescriptor propertyDescriptor = propertyFound.orElseThrow(() -> new IllegalArgumentException(message));
        return context.getProperty(propertyDescriptor);
    }

    private ValidationResult validateResource(ResourceReference resource) {
        ValidationResult.Builder builder = new ValidationResult.Builder();
        ResourceType resourceType = resource.getResourceType();
        if (ResourceType.TEXT == resourceType) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(resource.read()));){
                Set prefixedLines = reader.lines().filter(line -> line.startsWith(this.ageKeyIndicator.getPrefix())).collect(Collectors.toSet());
                long invalid = prefixedLines.stream().map(this.ageKeyIndicator.getPattern()::matcher).filter(matcher -> !matcher.matches()).count();
                if (prefixedLines.size() == 0) {
                    builder.explanation(NOT_FOUND_EXPLANATION).valid(false);
                } else if (invalid == 0L) {
                    builder.explanation(VALID_EXPLANATION).valid(true);
                } else {
                    String explanation = String.format(INVALID_EXPLANATION, invalid);
                    builder.explanation(explanation).valid(false);
                }
            }
            catch (Exception e) {
                String explanation = String.format(RESOURCE_EXCEPTION, e.getMessage());
                builder.explanation(explanation).valid(false);
            }
        } else {
            builder.explanation(FILE_RESOURCE_EXPLANATION).valid(true);
        }
        return builder.build();
    }
}

