/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cdc.mysql.event;

import com.github.shyiko.mysql.binlog.BinaryLogClient;
import com.github.shyiko.mysql.binlog.event.Event;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.nifi.cdc.mysql.event.RawBinlogEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinlogEventListener
implements BinaryLogClient.EventListener {
    private static final Logger logger = LoggerFactory.getLogger(BinlogEventListener.class);
    private final AtomicBoolean stopNow = new AtomicBoolean(false);
    private static final int QUEUE_OFFER_TIMEOUT_MSEC = 100;
    private final BlockingQueue<RawBinlogEvent> queue;
    private final BinaryLogClient client;

    public BinlogEventListener(BinaryLogClient client, BlockingQueue<RawBinlogEvent> q) {
        this.client = client;
        this.queue = q;
    }

    public void start() {
        this.stopNow.set(false);
    }

    public void stop() {
        this.stopNow.set(true);
    }

    public void onEvent(Event event) {
        RawBinlogEvent ep = new RawBinlogEvent(event, this.client.getBinlogFilename());
        try {
            while (!this.stopNow.get()) {
                if (!this.queue.offer(ep, 100L, TimeUnit.MILLISECONDS)) continue;
                return;
            }
            logger.info("Stopped while waiting to enqueue event");
        }
        catch (InterruptedException e) {
            logger.warn("Interrupted while adding event to the queue", (Throwable)e);
        }
    }
}

