/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cdc.mysql.event.io;

import java.io.IOException;
import java.io.Serializable;
import org.apache.nifi.cdc.mysql.event.BinlogTableEventInfo;
import org.apache.nifi.cdc.mysql.event.io.AbstractBinlogEventWriter;

public abstract class AbstractBinlogTableEventWriter<T extends BinlogTableEventInfo>
extends AbstractBinlogEventWriter<T> {
    protected Object getWritableObject(Integer type, Serializable value) {
        if (value == null) {
            return null;
        }
        if (type == null) {
            if (value instanceof byte[]) {
                return new String((byte[])value);
            }
            if (value instanceof Number) {
                return value;
            }
            return null;
        }
        if (value instanceof byte[]) {
            return new String((byte[])value);
        }
        if (value instanceof Number) {
            return value;
        }
        return value.toString();
    }

    @Override
    protected void writeJson(T event) throws IOException {
        super.writeJson(event);
        if (event.getDatabaseName() != null) {
            this.jsonGenerator.writeStringField("database", event.getDatabaseName());
        } else {
            this.jsonGenerator.writeNullField("database");
        }
        if (event.getTableName() != null) {
            this.jsonGenerator.writeStringField("table_name", event.getTableName());
        } else {
            this.jsonGenerator.writeNullField("table_name");
        }
        if (event.getTableId() != null) {
            this.jsonGenerator.writeNumberField("table_id", event.getTableId().longValue());
        } else {
            this.jsonGenerator.writeNullField("table_id");
        }
    }
}

