/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cdc.mysql.processors;

import com.github.shyiko.mysql.binlog.BinaryLogClient;
import com.github.shyiko.mysql.binlog.GtidSet;
import com.github.shyiko.mysql.binlog.event.DeleteRowsEventData;
import com.github.shyiko.mysql.binlog.event.EventHeaderV4;
import com.github.shyiko.mysql.binlog.event.EventType;
import com.github.shyiko.mysql.binlog.event.GtidEventData;
import com.github.shyiko.mysql.binlog.event.QueryEventData;
import com.github.shyiko.mysql.binlog.event.RotateEventData;
import com.github.shyiko.mysql.binlog.event.TableMapEventData;
import com.github.shyiko.mysql.binlog.event.UpdateRowsEventData;
import com.github.shyiko.mysql.binlog.event.WriteRowsEventData;
import com.github.shyiko.mysql.binlog.network.SSLMode;
import com.github.shyiko.mysql.binlog.network.SSLSocketFactory;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.PrimaryNodeOnly;
import org.apache.nifi.annotation.behavior.Stateful;
import org.apache.nifi.annotation.behavior.TriggerSerially;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnShutdown;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.annotation.notification.OnPrimaryNodeStateChange;
import org.apache.nifi.annotation.notification.PrimaryNodeState;
import org.apache.nifi.cdc.CDCException;
import org.apache.nifi.cdc.event.ColumnDefinition;
import org.apache.nifi.cdc.event.RowEventException;
import org.apache.nifi.cdc.event.TableInfo;
import org.apache.nifi.cdc.event.TableInfoCacheKey;
import org.apache.nifi.cdc.mysql.event.BeginTransactionEventInfo;
import org.apache.nifi.cdc.mysql.event.BinlogEventListener;
import org.apache.nifi.cdc.mysql.event.BinlogLifecycleListener;
import org.apache.nifi.cdc.mysql.event.CommitTransactionEventInfo;
import org.apache.nifi.cdc.mysql.event.DDLEventInfo;
import org.apache.nifi.cdc.mysql.event.DeleteRowsEventInfo;
import org.apache.nifi.cdc.mysql.event.InsertRowsEventInfo;
import org.apache.nifi.cdc.mysql.event.RawBinlogEvent;
import org.apache.nifi.cdc.mysql.event.UpdateRowsEventInfo;
import org.apache.nifi.cdc.mysql.event.io.BeginTransactionEventWriter;
import org.apache.nifi.cdc.mysql.event.io.CommitTransactionEventWriter;
import org.apache.nifi.cdc.mysql.event.io.DDLEventWriter;
import org.apache.nifi.cdc.mysql.event.io.DeleteRowsWriter;
import org.apache.nifi.cdc.mysql.event.io.InsertRowsWriter;
import org.apache.nifi.cdc.mysql.event.io.UpdateRowsWriter;
import org.apache.nifi.cdc.mysql.processors.ssl.BinaryLogSSLSocketFactory;
import org.apache.nifi.cdc.mysql.processors.ssl.StandardConnectionPropertiesProvider;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.resource.ResourceCardinality;
import org.apache.nifi.components.resource.ResourceType;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.components.state.StateMap;
import org.apache.nifi.distributed.cache.client.Deserializer;
import org.apache.nifi.distributed.cache.client.DistributedMapCacheClient;
import org.apache.nifi.distributed.cache.client.Serializer;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.AbstractSessionFactoryProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessSessionFactory;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.security.util.TlsConfiguration;
import org.apache.nifi.ssl.SSLContextService;
import org.apache.nifi.util.file.classloader.ClassLoaderUtils;

@TriggerSerially
@PrimaryNodeOnly
@InputRequirement(value=InputRequirement.Requirement.INPUT_FORBIDDEN)
@Tags(value={"sql", "jdbc", "cdc", "mysql"})
@CapabilityDescription(value="Retrieves Change Data Capture (CDC) events from a MySQL database. CDC Events include INSERT, UPDATE, DELETE operations. Events are output as individual flow files ordered by the time at which the operation occurred.")
@Stateful(scopes={Scope.CLUSTER}, description="Information such as a 'pointer' to the current CDC event in the database is stored by this processor, such that it can continue from the same location if restarted.")
@WritesAttributes(value={@WritesAttribute(attribute="cdc.sequence.id", description="A sequence identifier (i.e. strictly increasing integer value) specifying the order of the CDC event flow file relative to the other event flow file(s)."), @WritesAttribute(attribute="cdc.event.type", description="A string indicating the type of CDC event that occurred, including (but not limited to) 'begin', 'insert', 'update', 'delete', 'ddl' and 'commit'."), @WritesAttribute(attribute="mime.type", description="The processor outputs flow file content in JSON format, and sets the mime.type attribute to application/json")})
public class CaptureChangeMySQL
extends AbstractSessionFactoryProcessor {
    private static final int DO_NOT_SET = -1000;
    private static final Pattern MULTI_COMMENT_PATTERN = Pattern.compile("/\\*.*?\\*/", 32);
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("Successfully created FlowFile from SQL query result set.").build();
    protected static Set<Relationship> relationships;
    private static final AllowableValue SSL_MODE_DISABLED;
    private static final AllowableValue SSL_MODE_PREFERRED;
    private static final AllowableValue SSL_MODE_REQUIRED;
    private static final AllowableValue SSL_MODE_VERIFY_IDENTITY;
    public static final PropertyDescriptor DATABASE_NAME_PATTERN;
    public static final PropertyDescriptor TABLE_NAME_PATTERN;
    public static final PropertyDescriptor CONNECT_TIMEOUT;
    public static final PropertyDescriptor HOSTS;
    public static final PropertyDescriptor DRIVER_NAME;
    public static final PropertyDescriptor DRIVER_LOCATION;
    public static final PropertyDescriptor USERNAME;
    public static final PropertyDescriptor PASSWORD;
    public static final PropertyDescriptor SERVER_ID;
    public static final PropertyDescriptor DIST_CACHE_CLIENT;
    public static final PropertyDescriptor RETRIEVE_ALL_RECORDS;
    public static final PropertyDescriptor INCLUDE_BEGIN_COMMIT;
    public static final PropertyDescriptor INCLUDE_DDL_EVENTS;
    public static final PropertyDescriptor STATE_UPDATE_INTERVAL;
    public static final PropertyDescriptor INIT_SEQUENCE_ID;
    public static final PropertyDescriptor INIT_BINLOG_FILENAME;
    public static final PropertyDescriptor INIT_BINLOG_POSITION;
    public static final PropertyDescriptor USE_BINLOG_GTID;
    public static final PropertyDescriptor INIT_BINLOG_GTID;
    public static final PropertyDescriptor SSL_MODE;
    public static final PropertyDescriptor SSL_CONTEXT_SERVICE;
    private static final List<PropertyDescriptor> propDescriptors;
    private volatile ProcessSession currentSession;
    private BinaryLogClient binlogClient;
    private BinlogEventListener eventListener;
    private BinlogLifecycleListener lifecycleListener;
    private GtidSet gtidSet;
    private final LinkedBlockingQueue<RawBinlogEvent> queue = new LinkedBlockingQueue();
    private volatile String currentBinlogFile = null;
    private volatile long currentBinlogPosition = 4L;
    private volatile String currentGtidSet = null;
    private volatile String xactBinlogFile = null;
    private volatile long xactBinlogPosition = 4L;
    private volatile long xactSequenceId = 0L;
    private volatile String xactGtidSet = null;
    private volatile TableInfo currentTable = null;
    private volatile String currentDatabase = null;
    private volatile Pattern databaseNamePattern;
    private volatile Pattern tableNamePattern;
    private volatile boolean includeBeginCommit = false;
    private volatile boolean includeDDLEvents = false;
    private volatile boolean useGtid = false;
    private volatile boolean inTransaction = false;
    private volatile boolean skipTable = false;
    private final AtomicBoolean doStop = new AtomicBoolean(false);
    private final AtomicBoolean hasRun = new AtomicBoolean(false);
    private int currentHost = 0;
    private String transitUri = "<unknown>";
    private final AtomicLong currentSequenceId = new AtomicLong(0L);
    private volatile DistributedMapCacheClient cacheClient = null;
    private final Serializer<TableInfoCacheKey> cacheKeySerializer = new TableInfoCacheKey.Serializer();
    private final Serializer<TableInfo> cacheValueSerializer = new TableInfo.Serializer();
    private final Deserializer<TableInfo> cacheValueDeserializer = new TableInfo.Deserializer();
    private JDBCConnectionHolder jdbcConnectionHolder = null;
    private final BeginTransactionEventWriter beginEventWriter = new BeginTransactionEventWriter();
    private final CommitTransactionEventWriter commitEventWriter = new CommitTransactionEventWriter();
    private final DDLEventWriter ddlEventWriter = new DDLEventWriter();
    private final InsertRowsWriter insertRowsWriter = new InsertRowsWriter();
    private final DeleteRowsWriter deleteRowsWriter = new DeleteRowsWriter();
    private final UpdateRowsWriter updateRowsWriter = new UpdateRowsWriter();

    public Set<Relationship> getRelationships() {
        return relationships;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return propDescriptors;
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        Map properties = validationContext.getProperties();
        String sslContextServiceProperty = (String)properties.get(SSL_CONTEXT_SERVICE);
        String sslModeProperty = (String)properties.get(SSL_MODE);
        if (StringUtils.isBlank((CharSequence)sslModeProperty) || SSLMode.DISABLED.toString().equals(sslModeProperty)) {
            results.add(new ValidationResult.Builder().subject(SSL_MODE.getDisplayName()).valid(true).build());
        } else if (StringUtils.isBlank((CharSequence)sslContextServiceProperty)) {
            String explanation = String.format("SSL Context Service is required for SSL Mode [%s]", sslModeProperty);
            results.add(new ValidationResult.Builder().subject(SSL_CONTEXT_SERVICE.getDisplayName()).valid(false).explanation(explanation).build());
        }
        return results;
    }

    @OnPrimaryNodeStateChange
    public synchronized void onPrimaryNodeChange(PrimaryNodeState state) throws CDCException {
        if (state == PrimaryNodeState.PRIMARY_NODE_REVOKED) {
            this.stop();
        }
    }

    public void setup(ProcessContext context) {
        StateMap stateMap;
        ComponentLog logger = this.getLogger();
        StateManager stateManager = context.getStateManager();
        try {
            stateMap = stateManager.getState(Scope.CLUSTER);
        }
        catch (IOException ioe) {
            logger.error("Failed to retrieve observed maximum values from the State Manager. Will not attempt connection until this is accomplished.", (Throwable)ioe);
            context.yield();
            return;
        }
        PropertyValue dbNameValue = context.getProperty(DATABASE_NAME_PATTERN);
        this.databaseNamePattern = dbNameValue.isSet() ? Pattern.compile(dbNameValue.getValue()) : null;
        PropertyValue tableNameValue = context.getProperty(TABLE_NAME_PATTERN);
        this.tableNamePattern = tableNameValue.isSet() ? Pattern.compile(tableNameValue.getValue()) : null;
        boolean getAllRecords = context.getProperty(RETRIEVE_ALL_RECORDS).asBoolean();
        this.includeBeginCommit = context.getProperty(INCLUDE_BEGIN_COMMIT).asBoolean();
        this.includeDDLEvents = context.getProperty(INCLUDE_DDL_EVENTS).asBoolean();
        this.useGtid = context.getProperty(USE_BINLOG_GTID).asBoolean();
        if (this.useGtid) {
            this.currentGtidSet = stateMap.get("binlog.gtidset");
            if (this.currentGtidSet == null) {
                this.currentGtidSet = !getAllRecords && context.getProperty(INIT_BINLOG_GTID).isSet() ? context.getProperty(INIT_BINLOG_GTID).evaluateAttributeExpressions().getValue() : "";
            }
            this.currentBinlogFile = "";
            this.currentBinlogPosition = -1000L;
        } else {
            String binlogPosition;
            this.currentBinlogFile = stateMap.get("binlog.filename");
            if (this.currentBinlogFile == null) {
                if (!getAllRecords) {
                    if (context.getProperty(INIT_BINLOG_FILENAME).isSet()) {
                        this.currentBinlogFile = context.getProperty(INIT_BINLOG_FILENAME).evaluateAttributeExpressions().getValue();
                    }
                } else {
                    this.currentBinlogFile = "";
                }
            }
            this.currentBinlogPosition = (binlogPosition = stateMap.get("binlog.position")) != null ? Long.valueOf(binlogPosition) : (!getAllRecords ? (context.getProperty(INIT_BINLOG_POSITION).isSet() ? context.getProperty(INIT_BINLOG_POSITION).evaluateAttributeExpressions().asLong() : -1000L) : -1L);
        }
        String seqIdString = stateMap.get("cdc.sequence.id");
        if (StringUtils.isEmpty((CharSequence)seqIdString)) {
            PropertyValue seqIdProp = context.getProperty(INIT_SEQUENCE_ID);
            if (seqIdProp.isSet()) {
                this.currentSequenceId.set(seqIdProp.evaluateAttributeExpressions().asInteger().intValue());
            }
        } else {
            this.currentSequenceId.set(Long.parseLong(seqIdString));
        }
        this.inTransaction = "true".equals(stateMap.get("inTransaction"));
        boolean createEnrichmentConnection = false;
        if (context.getProperty(DIST_CACHE_CLIENT).isSet()) {
            this.cacheClient = (DistributedMapCacheClient)context.getProperty(DIST_CACHE_CLIENT).asControllerService(DistributedMapCacheClient.class);
            createEnrichmentConnection = true;
        } else {
            logger.warn("No Distributed Map Cache Client is specified, so no event enrichment (resolution of column names, e.g.) will be performed.");
            this.cacheClient = null;
        }
        SSLContextService sslContextService = (SSLContextService)context.getProperty(SSL_CONTEXT_SERVICE).asControllerService(SSLContextService.class);
        SSLMode sslMode = SSLMode.valueOf((String)context.getProperty(SSL_MODE).getValue());
        try {
            List<InetSocketAddress> hosts = this.getHosts(context.getProperty(HOSTS).evaluateAttributeExpressions().getValue());
            String username = context.getProperty(USERNAME).evaluateAttributeExpressions().getValue();
            String password = context.getProperty(PASSWORD).evaluateAttributeExpressions().getValue();
            if (password == null) {
                password = "";
            }
            long connectTimeout = context.getProperty(CONNECT_TIMEOUT).evaluateAttributeExpressions().asTimePeriod(TimeUnit.MILLISECONDS);
            String driverLocation = context.getProperty(DRIVER_LOCATION).evaluateAttributeExpressions().getValue();
            String driverName = context.getProperty(DRIVER_NAME).evaluateAttributeExpressions().getValue();
            Long serverId = context.getProperty(SERVER_ID).evaluateAttributeExpressions().asLong();
            this.connect(hosts, username, password, serverId, createEnrichmentConnection, driverLocation, driverName, connectTimeout, sslContextService, sslMode);
        }
        catch (IOException | IllegalStateException e) {
            context.yield();
            this.binlogClient = null;
            throw new ProcessException(e.getMessage(), (Throwable)e);
        }
    }

    public synchronized void onTrigger(ProcessContext context, ProcessSessionFactory sessionFactory) throws ProcessException {
        this.hasRun.set(true);
        ComponentLog log = this.getLogger();
        if (this.binlogClient == null) {
            this.setup(context);
        }
        if (!this.binlogClient.isConnected()) {
            Exception e = this.lifecycleListener.getException();
            if (e != null) {
                log.error("Binlog connector communications failure: " + e.getMessage(), (Throwable)e);
                try {
                    this.stop();
                }
                catch (CDCException ioe) {
                    throw new ProcessException((Throwable)ioe);
                }
            }
            context.yield();
            return;
        }
        if (this.currentSession == null) {
            this.currentSession = sessionFactory.createSession();
        }
        try {
            this.outputEvents(this.currentSession, log);
        }
        catch (IOException ioe) {
            try {
                this.currentBinlogFile = this.xactBinlogFile == null ? "" : this.xactBinlogFile;
                this.currentBinlogPosition = this.xactBinlogPosition;
                this.currentSequenceId.set(this.xactSequenceId);
                this.currentGtidSet = this.xactGtidSet;
                this.inTransaction = false;
                this.stop();
                this.queue.clear();
                this.currentSession.rollback();
            }
            catch (Exception e) {
                log.warn("Error occurred during rollback", (Throwable)e);
            }
            throw new ProcessException((Throwable)ioe);
        }
    }

    @OnStopped
    @OnShutdown
    public void onStopped(ProcessContext context) {
        try {
            this.stop();
        }
        catch (CDCException ioe) {
            throw new ProcessException((Throwable)ioe);
        }
    }

    private List<InetSocketAddress> getHosts(String hostsString) {
        if (hostsString == null) {
            return null;
        }
        String[] hostsSplit = hostsString.split(",");
        ArrayList<InetSocketAddress> hostsList = new ArrayList<InetSocketAddress>();
        for (String item : hostsSplit) {
            String[] addresses = item.split(":");
            if (addresses.length != 2) {
                throw new ArrayIndexOutOfBoundsException("Not in host:port format");
            }
            hostsList.add(new InetSocketAddress(addresses[0].trim(), Integer.parseInt(addresses[1].trim())));
        }
        return hostsList;
    }

    protected void connect(List<InetSocketAddress> hosts, String username, String password, Long serverId, boolean createEnrichmentConnection, String driverLocation, String driverName, long connectTimeout, SSLContextService sslContextService, SSLMode sslMode) throws IOException {
        int connectionAttempts = 0;
        int numHosts = hosts.size();
        InetSocketAddress connectedHost = null;
        Exception lastConnectException = new Exception("Unknown connection error");
        if (createEnrichmentConnection) {
            try {
                this.registerDriver(driverLocation, driverName);
            }
            catch (InitializationException e) {
                throw new RuntimeException("Failed to register JDBC driver. Ensure MySQL Driver Location(s) and MySQL Driver Class Name are configured correctly. " + e, e);
            }
        }
        while (connectedHost == null && connectionAttempts < numHosts) {
            if (this.binlogClient == null) {
                connectedHost = hosts.get(this.currentHost);
                this.binlogClient = this.createBinlogClient(connectedHost.getHostString(), connectedHost.getPort(), username, password);
            }
            if (this.eventListener == null) {
                this.eventListener = this.createBinlogEventListener(this.binlogClient, this.queue);
            }
            this.eventListener.start();
            this.binlogClient.registerEventListener((BinaryLogClient.EventListener)this.eventListener);
            if (this.lifecycleListener == null) {
                this.lifecycleListener = this.createBinlogLifecycleListener();
            }
            this.binlogClient.registerLifecycleListener((BinaryLogClient.LifecycleListener)this.lifecycleListener);
            this.binlogClient.setBinlogFilename(this.currentBinlogFile);
            if (this.currentBinlogPosition != -1000L) {
                this.binlogClient.setBinlogPosition(this.currentBinlogPosition);
            }
            this.binlogClient.setGtidSet(this.currentGtidSet);
            this.binlogClient.setGtidSetFallbackToPurged(true);
            if (serverId != null) {
                this.binlogClient.setServerId(serverId.longValue());
            }
            this.binlogClient.setSSLMode(sslMode);
            if (sslContextService != null) {
                SSLContext sslContext = sslContextService.createContext();
                BinaryLogSSLSocketFactory sslSocketFactory = new BinaryLogSSLSocketFactory(sslContext.getSocketFactory());
                this.binlogClient.setSslSocketFactory((SSLSocketFactory)sslSocketFactory);
            }
            try {
                if (connectTimeout == 0L) {
                    connectTimeout = Long.MAX_VALUE;
                }
                this.binlogClient.connect(connectTimeout);
                this.transitUri = "mysql://" + connectedHost.getHostString() + ":" + connectedHost.getPort();
            }
            catch (IOException | TimeoutException te) {
                connectedHost = null;
                this.transitUri = "<unknown>";
                this.currentHost = (this.currentHost + 1) % numHosts;
                ++connectionAttempts;
                lastConnectException = te;
            }
        }
        if (!this.binlogClient.isConnected()) {
            this.binlogClient.disconnect();
            this.binlogClient = null;
            throw new IOException("Could not connect binlog client to any of the specified hosts due to: " + lastConnectException.getMessage(), lastConnectException);
        }
        if (createEnrichmentConnection) {
            TlsConfiguration tlsConfiguration = sslContextService == null ? null : sslContextService.createTlsConfiguration();
            StandardConnectionPropertiesProvider connectionPropertiesProvider = new StandardConnectionPropertiesProvider(sslMode, tlsConfiguration);
            Map<String, String> jdbcConnectionProperties = connectionPropertiesProvider.getConnectionProperties();
            this.jdbcConnectionHolder = new JDBCConnectionHolder(connectedHost, username, password, jdbcConnectionProperties, connectTimeout);
            try {
                this.getJdbcConnection();
            }
            catch (SQLException e) {
                this.binlogClient.disconnect();
                this.binlogClient = null;
                throw new IOException("Error creating binlog enrichment JDBC connection to any of the specified hosts", e);
            }
        }
        this.gtidSet = new GtidSet(this.binlogClient.getGtidSet());
        this.doStop.set(false);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void outputEvents(ProcessSession session, ComponentLog log) throws IOException {
        while ((rawBinlogEvent = this.queue.poll()) != null && !this.doStop.get()) {
            event = rawBinlogEvent.getEvent();
            header = (EventHeaderV4)event.getHeader();
            timestamp = header.getTimestamp();
            eventType = header.getEventType();
            if (eventType != EventType.ROTATE && eventType != EventType.FORMAT_DESCRIPTION && !this.useGtid) {
                this.currentBinlogPosition = header.getPosition();
            }
            log.debug("Got message event type: {} ", new Object[]{header.getEventType().toString()});
            switch (1.$SwitchMap$com$github$shyiko$mysql$binlog$event$EventType[eventType.ordinal()]) {
                case 1: {
                    data = (TableMapEventData)event.getData();
                    v0 = this.skipTable = this.databaseNamePattern != null && this.databaseNamePattern.matcher(data.getDatabase()).matches() == false || this.tableNamePattern != null && this.tableNamePattern.matcher(data.getTable()).matches() == false;
                    if (!this.skipTable) {
                        key = new TableInfoCacheKey(this.getIdentifier(), data.getDatabase(), data.getTable(), data.getTableId());
                        if (this.cacheClient == null) break;
                        try {
                            this.currentTable = (TableInfo)this.cacheClient.get((Object)key, this.cacheKeySerializer, this.cacheValueDeserializer);
                        }
                        catch (ConnectException ce) {
                            throw new IOException("Could not connect to Distributed Map Cache server to get table information", ce);
                        }
                        if (this.currentTable != null) break;
                        try {
                            this.currentTable = this.loadTableInfo(key);
                            try {
                                this.cacheClient.put((Object)key, (Object)this.currentTable, this.cacheKeySerializer, this.cacheValueSerializer);
                                ** break;
                            }
                            catch (ConnectException ce) {
                                throw new IOException("Could not connect to Distributed Map Cache server to put table information", ce);
lbl29:
                                // 1 sources

                                break;
                            }
                        }
                        catch (SQLException se) {
                            throw new IOException(se.getMessage(), se);
                        }
                    }
                    this.currentTable = null;
                    break;
                }
                case 2: {
                    queryEventData = (QueryEventData)event.getData();
                    this.currentDatabase = queryEventData.getDatabase();
                    sql = queryEventData.getSql();
                    if ("BEGIN".equals(sql)) {
                        if (this.inTransaction) {
                            throw new IOException("BEGIN event received while already processing a transaction. This could indicate that your binlog position is invalid.");
                        }
                        this.xactBinlogFile = this.currentBinlogFile;
                        this.xactBinlogPosition = this.currentBinlogPosition;
                        this.xactSequenceId = this.currentSequenceId.get();
                        this.xactGtidSet = this.currentGtidSet;
                        if (this.includeBeginCommit && (this.databaseNamePattern == null || this.databaseNamePattern.matcher(this.currentDatabase).matches())) {
                            beginEvent = this.useGtid != false ? new BeginTransactionEventInfo(this.currentDatabase, timestamp, this.currentGtidSet) : new BeginTransactionEventInfo(this.currentDatabase, (Long)timestamp, this.currentBinlogFile, this.currentBinlogPosition);
                            this.currentSequenceId.set(this.beginEventWriter.writeEvent(this.currentSession, this.transitUri, beginEvent, this.currentSequenceId.get(), CaptureChangeMySQL.REL_SUCCESS));
                        }
                        this.inTransaction = true;
                        this.updateState(session);
                        break;
                    }
                    if ("COMMIT".equals(sql)) {
                        if (!this.inTransaction) {
                            throw new IOException("COMMIT event received while not processing a transaction (i.e. no corresponding BEGIN event). This could indicate that your binlog position is invalid.");
                        }
                        if (this.includeBeginCommit && (this.databaseNamePattern == null || this.databaseNamePattern.matcher(this.currentDatabase).matches())) {
                            commitTransactionEvent = this.useGtid != false ? new CommitTransactionEventInfo(this.currentDatabase, timestamp, this.currentGtidSet) : new CommitTransactionEventInfo(this.currentDatabase, (Long)timestamp, this.currentBinlogFile, this.currentBinlogPosition);
                            this.currentSequenceId.set(this.commitEventWriter.writeEvent(this.currentSession, this.transitUri, commitTransactionEvent, this.currentSequenceId.get(), CaptureChangeMySQL.REL_SUCCESS));
                        }
                        this.inTransaction = false;
                        this.updateState(session);
                        session.commitAsync();
                        this.currentTable = null;
                        break;
                    }
                    normalizedQuery = this.normalizeQuery(sql);
                    if (!normalizedQuery.startsWith("alter table") && !normalizedQuery.startsWith("alter ignore table") && !normalizedQuery.startsWith("create table") && !normalizedQuery.startsWith("truncate table") && !normalizedQuery.startsWith("rename table") && !normalizedQuery.startsWith("drop table") && !normalizedQuery.startsWith("drop database")) break;
                    if (this.includeDDLEvents && (this.databaseNamePattern == null || this.databaseNamePattern.matcher(this.currentDatabase).matches())) {
                        ddlTableInfo = this.currentTable != null ? this.currentTable : new TableInfo(this.currentDatabase, null, null, null);
                        ddlEvent = this.useGtid != false ? new DDLEventInfo(ddlTableInfo, (Long)timestamp, this.currentGtidSet, sql) : new DDLEventInfo(ddlTableInfo, timestamp, this.currentBinlogFile, this.currentBinlogPosition, sql);
                        this.currentSequenceId.set(this.ddlEventWriter.writeEvent(this.currentSession, this.transitUri, ddlEvent, this.currentSequenceId.get(), CaptureChangeMySQL.REL_SUCCESS));
                    }
                    if (this.cacheClient != null) {
                        this.cacheClient.removeByPattern(this.getIdentifier() + ".*");
                    }
                    if (!this.includeDDLEvents || this.inTransaction) break;
                    this.updateState(session);
                    session.commitAsync();
                    break;
                }
                case 3: {
                    if (!this.inTransaction) {
                        throw new IOException("COMMIT event received while not processing a transaction (i.e. no corresponding BEGIN event). This could indicate that your binlog position is invalid.");
                    }
                    if (this.includeBeginCommit && (this.databaseNamePattern == null || this.databaseNamePattern.matcher(this.currentDatabase).matches())) {
                        commitTransactionEvent = this.useGtid != false ? new CommitTransactionEventInfo(this.currentDatabase, timestamp, this.currentGtidSet) : new CommitTransactionEventInfo(this.currentDatabase, (Long)timestamp, this.currentBinlogFile, this.currentBinlogPosition);
                        this.currentSequenceId.set(this.commitEventWriter.writeEvent(this.currentSession, this.transitUri, commitTransactionEvent, this.currentSequenceId.get(), CaptureChangeMySQL.REL_SUCCESS));
                    }
                    this.inTransaction = false;
                    this.currentBinlogPosition = header.getNextPosition();
                    this.updateState(session);
                    session.commitAsync();
                    this.currentTable = null;
                    this.currentDatabase = null;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    if (this.skipTable) break;
                    if (!this.inTransaction) {
                        log.warn("Table modification event occurred outside of a transaction.");
                        break;
                    }
                    if (this.currentTable == null && this.cacheClient != null) {
                        throw new RowEventException("No table information is available for this event, cannot process further.");
                    }
                    if (eventType == EventType.WRITE_ROWS || eventType == EventType.EXT_WRITE_ROWS || eventType == EventType.PRE_GA_WRITE_ROWS) {
                        eventInfo /* !! */  = this.useGtid != false ? new InsertRowsEventInfo(this.currentTable, (Long)timestamp, this.currentGtidSet, (WriteRowsEventData)event.getData()) : new InsertRowsEventInfo(this.currentTable, timestamp, this.currentBinlogFile, this.currentBinlogPosition, (WriteRowsEventData)event.getData());
                        this.currentSequenceId.set(this.insertRowsWriter.writeEvent(this.currentSession, this.transitUri, eventInfo /* !! */ , this.currentSequenceId.get(), CaptureChangeMySQL.REL_SUCCESS));
                        break;
                    }
                    if (eventType == EventType.DELETE_ROWS || eventType == EventType.EXT_DELETE_ROWS || eventType == EventType.PRE_GA_DELETE_ROWS) {
                        eventInfo /* !! */  = this.useGtid != false ? new DeleteRowsEventInfo(this.currentTable, (Long)timestamp, this.currentGtidSet, (DeleteRowsEventData)event.getData()) : new DeleteRowsEventInfo(this.currentTable, timestamp, this.currentBinlogFile, this.currentBinlogPosition, (DeleteRowsEventData)event.getData());
                        this.currentSequenceId.set(this.deleteRowsWriter.writeEvent(this.currentSession, this.transitUri, (DeleteRowsEventInfo)eventInfo /* !! */ , this.currentSequenceId.get(), CaptureChangeMySQL.REL_SUCCESS));
                        break;
                    }
                    eventInfo /* !! */  = this.useGtid != false ? new UpdateRowsEventInfo(this.currentTable, (Long)timestamp, this.currentGtidSet, (UpdateRowsEventData)event.getData()) : new UpdateRowsEventInfo(this.currentTable, timestamp, this.currentBinlogFile, this.currentBinlogPosition, (UpdateRowsEventData)event.getData());
                    this.currentSequenceId.set(this.updateRowsWriter.writeEvent(this.currentSession, this.transitUri, (UpdateRowsEventInfo)eventInfo /* !! */ , this.currentSequenceId.get(), CaptureChangeMySQL.REL_SUCCESS));
                    break;
                }
                case 13: {
                    if (!this.useGtid) {
                        rotateEventData = (RotateEventData)event.getData();
                        this.currentBinlogFile = rotateEventData.getBinlogFilename();
                        this.currentBinlogPosition = rotateEventData.getBinlogPosition();
                    }
                    this.updateState(session);
                    break;
                }
                case 14: {
                    if (!this.useGtid) break;
                    gtidEventData = (GtidEventData)event.getData();
                    this.gtidSet.add(gtidEventData.getGtid());
                    this.currentGtidSet = this.gtidSet.toString();
                    this.updateState(session);
                    break;
                }
            }
            if (eventType == EventType.ROTATE || eventType == EventType.FORMAT_DESCRIPTION || this.useGtid || eventType == EventType.XID) continue;
            this.currentBinlogPosition = header.getNextPosition();
        }
    }

    protected void clearState() throws IOException {
        if (this.currentSession == null) {
            throw new IllegalStateException("No current session");
        }
        this.currentSession.clearState(Scope.CLUSTER);
    }

    protected String normalizeQuery(String sql) {
        String normalizedQuery = sql.toLowerCase().trim().replaceAll(" {2,}", " ");
        normalizedQuery = MULTI_COMMENT_PATTERN.matcher(normalizedQuery).replaceAll("").trim();
        normalizedQuery = normalizedQuery.replaceAll("#.*", "");
        normalizedQuery = normalizedQuery.replaceAll("-{2}.*", "");
        return normalizedQuery;
    }

    protected void stop() throws CDCException {
        try {
            if (this.binlogClient != null) {
                this.binlogClient.disconnect();
            }
            if (this.eventListener != null) {
                this.eventListener.stop();
                if (this.binlogClient != null) {
                    this.binlogClient.unregisterEventListener((BinaryLogClient.EventListener)this.eventListener);
                }
            }
            if (this.currentSession != null) {
                this.currentSession.commitAsync();
            }
            this.doStop.set(true);
            this.currentBinlogPosition = -1L;
        }
        catch (IOException e) {
            throw new CDCException("Error closing CDC connection", (Throwable)e);
        }
        finally {
            this.binlogClient = null;
            if (this.jdbcConnectionHolder != null) {
                this.jdbcConnectionHolder.close();
            }
        }
    }

    private void updateState(ProcessSession session) throws IOException {
        this.updateState(session, this.currentBinlogFile, this.currentBinlogPosition, this.currentSequenceId.get(), this.currentGtidSet, this.inTransaction);
    }

    private void updateState(ProcessSession session, String binlogFile, long binlogPosition, long sequenceId, String gtidSet, boolean inTransaction) throws IOException {
        HashMap<String, String> newStateMap = new HashMap<String, String>(session.getState(Scope.CLUSTER).toMap());
        if (binlogFile != null) {
            newStateMap.put("binlog.filename", binlogFile);
        }
        newStateMap.put("binlog.position", Long.toString(binlogPosition));
        newStateMap.put("cdc.sequence.id", String.valueOf(sequenceId));
        newStateMap.put("inTransaction", inTransaction ? "true" : "false");
        if (gtidSet != null) {
            newStateMap.put("binlog.gtidset", gtidSet);
        }
        session.setState(newStateMap, Scope.CLUSTER);
    }

    BinlogEventListener createBinlogEventListener(BinaryLogClient client, LinkedBlockingQueue<RawBinlogEvent> q) {
        return new BinlogEventListener(client, q);
    }

    BinlogLifecycleListener createBinlogLifecycleListener() {
        return new BinlogLifecycleListener();
    }

    protected BinaryLogClient createBinlogClient(String hostname, int port, String username, String password) {
        return new BinaryLogClient(hostname, port, username, password);
    }

    protected TableInfo loadTableInfo(TableInfoCacheKey key) throws SQLException {
        TableInfo tableInfo = null;
        if (this.jdbcConnectionHolder != null) {
            try (Statement s = this.getJdbcConnection().createStatement();){
                s.execute("USE `" + key.getDatabaseName() + "`");
                ResultSet rs = s.executeQuery("SELECT * FROM `" + key.getTableName() + "` LIMIT 0");
                ResultSetMetaData rsmd = rs.getMetaData();
                int numCols = rsmd.getColumnCount();
                ArrayList<ColumnDefinition> columnDefinitions = new ArrayList<ColumnDefinition>();
                for (int i = 1; i <= numCols; ++i) {
                    String columnLabel = rsmd.getColumnLabel(i);
                    columnDefinitions.add(new ColumnDefinition(rsmd.getColumnType(i), columnLabel != null ? columnLabel : rsmd.getColumnName(i)));
                }
                tableInfo = new TableInfo(key.getDatabaseName(), key.getTableName(), Long.valueOf(key.getTableId()), columnDefinitions);
            }
        }
        return tableInfo;
    }

    protected Connection getJdbcConnection() throws SQLException {
        return this.jdbcConnectionHolder.getConnection();
    }

    protected void registerDriver(String locationString, String drvName) throws InitializationException {
        if (locationString != null && locationString.length() > 0) {
            try {
                ClassLoader classLoader = ClassLoaderUtils.getCustomClassLoader((String)locationString, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (dir, name) -> name != null && name.endsWith(".jar"));
                Class<?> clazz = Class.forName(drvName, true, classLoader);
                if (clazz == null) {
                    throw new InitializationException("Can't load Database Driver " + drvName);
                }
                Driver driver = (Driver)clazz.newInstance();
                DriverManager.registerDriver(new DriverShim(driver));
            }
            catch (InitializationException e) {
                throw e;
            }
            catch (MalformedURLException e) {
                throw new InitializationException("Invalid Database Driver Jar Url", (Throwable)e);
            }
            catch (Exception e) {
                throw new InitializationException("Can't load Database Driver", (Throwable)e);
            }
        }
    }

    static {
        SSL_MODE_DISABLED = new AllowableValue(SSLMode.DISABLED.toString(), SSLMode.DISABLED.toString(), "Connect without TLS");
        SSL_MODE_PREFERRED = new AllowableValue(SSLMode.PREFERRED.toString(), SSLMode.PREFERRED.toString(), "Connect with TLS when server support enabled, otherwise connect without TLS");
        SSL_MODE_REQUIRED = new AllowableValue(SSLMode.REQUIRED.toString(), SSLMode.REQUIRED.toString(), "Connect with TLS or fail when server support not enabled");
        SSL_MODE_VERIFY_IDENTITY = new AllowableValue(SSLMode.VERIFY_IDENTITY.toString(), SSLMode.VERIFY_IDENTITY.toString(), "Connect with TLS or fail when server support not enabled. Verify server hostname matches presented X.509 certificate names or fail when not matched");
        DATABASE_NAME_PATTERN = new PropertyDescriptor.Builder().name("capture-change-mysql-db-name-pattern").displayName("Database/Schema Name Pattern").description("A regular expression (regex) for matching databases (or schemas, depending on your RDBMS' terminology) against the list of CDC events. The regex must match the database name as it is stored in the RDBMS. If the property is not set, the database name will not be used to filter the CDC events. NOTE: DDL events, even if they affect different databases, are associated with the database used by the session to execute the DDL. This means if a connection is made to one database, but the DDL is issued against another, then the connected database will be the one matched against the specified pattern.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
        TABLE_NAME_PATTERN = new PropertyDescriptor.Builder().name("capture-change-mysql-name-pattern").displayName("Table Name Pattern").description("A regular expression (regex) for matching CDC events affecting matching tables. The regex must match the table name as it is stored in the database. If the property is not set, no events will be filtered based on table name.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
        CONNECT_TIMEOUT = new PropertyDescriptor.Builder().name("capture-change-mysql-max-wait-time").displayName("Max Wait Time").description("The maximum amount of time allowed for a connection to be established, zero means there is effectively no limit.").defaultValue("30 seconds").required(true).addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
        HOSTS = new PropertyDescriptor.Builder().name("capture-change-mysql-hosts").displayName("MySQL Hosts").description("A list of hostname/port entries corresponding to nodes in a MySQL cluster. The entries should be comma separated using a colon such as host1:port,host2:port,....  For example mysql.myhost.com:3306. This processor will attempt to connect to the hosts in the list in order. If one node goes down and failover is enabled for the cluster, then the processor will connect to the active node (assuming its host entry is specified in this property.  The default port for MySQL connections is 3306.").required(true).addValidator(StandardValidators.HOSTNAME_PORT_LIST_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
        DRIVER_NAME = new PropertyDescriptor.Builder().name("capture-change-mysql-driver-class").displayName("MySQL Driver Class Name").description("The class name of the MySQL database driver class").defaultValue("com.mysql.jdbc.Driver").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
        DRIVER_LOCATION = new PropertyDescriptor.Builder().name("capture-change-mysql-driver-locations").displayName("MySQL Driver Location(s)").description("Comma-separated list of files/folders and/or URLs containing the MySQL driver JAR and its dependencies (if any). For example '/var/tmp/mysql-connector-java-5.1.38-bin.jar'").defaultValue(null).required(false).identifiesExternalResource(ResourceCardinality.MULTIPLE, ResourceType.FILE, new ResourceType[]{ResourceType.DIRECTORY, ResourceType.URL}).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
        USERNAME = new PropertyDescriptor.Builder().name("capture-change-mysql-username").displayName("Username").description("Username to access the MySQL cluster").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
        PASSWORD = new PropertyDescriptor.Builder().name("capture-change-mysql-password").displayName("Password").description("Password to access the MySQL cluster").required(false).sensitive(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
        SERVER_ID = new PropertyDescriptor.Builder().name("capture-change-mysql-server-id").displayName("Server ID").description("The client connecting to the MySQL replication group is actually a simplified replica (server), and the Server ID value must be unique across the whole replication group (i.e. different from any other Server ID being used by any primary or replica). Thus, each instance of CaptureChangeMySQL must have a Server ID unique across the replication group. If the Server ID is not specified, it defaults to 65535.").required(false).addValidator(StandardValidators.POSITIVE_LONG_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
        DIST_CACHE_CLIENT = new PropertyDescriptor.Builder().name("capture-change-mysql-dist-map-cache-client").displayName("Distributed Map Cache Client").description("Identifies a Distributed Map Cache Client controller service to be used for keeping information about the various tables, columns, etc. needed by the processor. If a client is not specified, the generated events will not include column type or name information.").identifiesControllerService(DistributedMapCacheClient.class).required(false).build();
        RETRIEVE_ALL_RECORDS = new PropertyDescriptor.Builder().name("capture-change-mysql-retrieve-all-records").displayName("Retrieve All Records").description("Specifies whether to get all available CDC events, regardless of the current binlog filename and/or position. If binlog filename and position values are present in the processor's State, this property's value is ignored. This allows for 4 different configurations: 1) If binlog data is available in processor State, that is used to determine the start location and the value of Retrieve All Records is ignored. 2) If no binlog data is in processor State, then Retrieve All Records set to true means start at the beginning of the binlog history. 3) If no binlog data is in processor State and Initial Binlog Filename/Position are not set, then Retrieve All Records set to false means start at the end of the binlog history. 4) If no binlog data is in processor State and Initial Binlog Filename/Position are set, then Retrieve All Records set to false means start at the specified initial binlog file/position. To reset the behavior, clear the processor state (refer to the State Management section of the processor's documentation).").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("true").addValidator(StandardValidators.BOOLEAN_VALIDATOR).build();
        INCLUDE_BEGIN_COMMIT = new PropertyDescriptor.Builder().name("capture-change-mysql-include-begin-commit").displayName("Include Begin/Commit Events").description("Specifies whether to emit events corresponding to a BEGIN or COMMIT event in the binary log. Set to true if the BEGIN/COMMIT events are necessary in the downstream flow, otherwise set to false, which suppresses generation of these events and can increase flow performance.").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("false").addValidator(StandardValidators.BOOLEAN_VALIDATOR).build();
        INCLUDE_DDL_EVENTS = new PropertyDescriptor.Builder().name("capture-change-mysql-include-ddl-events").displayName("Include DDL Events").description("Specifies whether to emit events corresponding to Data Definition Language (DDL) events such as ALTER TABLE, TRUNCATE TABLE, e.g. in the binary log. Set to true if the DDL events are desired/necessary in the downstream flow, otherwise set to false, which suppresses generation of these events and can increase flow performance.").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("false").addValidator(StandardValidators.BOOLEAN_VALIDATOR).build();
        STATE_UPDATE_INTERVAL = new PropertyDescriptor.Builder().name("capture-change-mysql-state-update-interval").displayName("State Update Interval").description("DEPRECATED. This property is no longer used and exists solely for backward compatibility purposes. Indicates how often to update the processor's state with binlog file/position values. A value of zero means that state will only be updated when the processor is stopped or shutdown. If at some point the processor state does not contain the desired binlog values, the last flow file emitted will contain the last observed values, and the processor can be returned to that state by using the Initial Binlog File, Initial Binlog Position, and Initial Sequence ID properties.").defaultValue("0 seconds").required(true).addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
        INIT_SEQUENCE_ID = new PropertyDescriptor.Builder().name("capture-change-mysql-init-seq-id").displayName("Initial Sequence ID").description("Specifies an initial sequence identifier to use if this processor's State does not have a current sequence identifier. If a sequence identifier is present in the processor's State, this property is ignored. Sequence identifiers are monotonically increasing integers that record the order of flow files generated by the processor. They can be used with the EnforceOrder processor to guarantee ordered delivery of CDC events.").required(false).addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
        INIT_BINLOG_FILENAME = new PropertyDescriptor.Builder().name("capture-change-mysql-init-binlog-filename").displayName("Initial Binlog Filename").description("Specifies an initial binlog filename to use if this processor's State does not have a current binlog filename. If a filename is present in the processor's State or \"Use GTID\" property is set to false, this property is ignored. This can be used along with Initial Binlog Position to \"skip ahead\" if previous events are not desired. Note that NiFi Expression Language is supported, but this property is evaluated when the processor is configured, so FlowFile attributes may not be used. Expression Language is supported to enable the use of the Variable Registry and/or environment properties.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
        INIT_BINLOG_POSITION = new PropertyDescriptor.Builder().name("capture-change-mysql-init-binlog-position").displayName("Initial Binlog Position").description("Specifies an initial offset into a binlog (specified by Initial Binlog Filename) to use if this processor's State does not have a current binlog filename. If a filename is present in the processor's State or \"Use GTID\" property is false, this property is ignored. This can be used along with Initial Binlog Filename to \"skip ahead\" if previous events are not desired. Note that NiFi Expression Language is supported, but this property is evaluated when the processor is configured, so FlowFile attributes may not be used. Expression Language is supported to enable the use of the Variable Registry and/or environment properties.").required(false).addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
        USE_BINLOG_GTID = new PropertyDescriptor.Builder().name("capture-change-mysql-use-gtid").displayName("Use Binlog GTID").description("Specifies whether to use Global Transaction ID (GTID) for binlog tracking. If set to true, processor's state of binlog file name and position is ignored. The main benefit of using GTID is to have much reliable failover than using binlog filename/position.").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("false").addValidator(StandardValidators.BOOLEAN_VALIDATOR).build();
        INIT_BINLOG_GTID = new PropertyDescriptor.Builder().name("capture-change-mysql-init-gtid").displayName("Initial Binlog GTID").description("Specifies an initial GTID to use if this processor's State does not have a current GTID. If a GTID is present in the processor's State or \"Use GTID\" property is set to false, this property is ignored. This can be used to \"skip ahead\" if previous events are not desired. Note that NiFi Expression Language is supported, but this property is evaluated when the processor is configured, so FlowFile attributes may not be used. Expression Language is supported to enable the use of the Variable Registry and/or environment properties.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
        SSL_MODE = new PropertyDescriptor.Builder().name("SSL Mode").displayName("SSL Mode").description("SSL Mode used when SSL Context Service configured supporting certificate verification options").required(true).defaultValue(SSLMode.DISABLED.toString()).allowableValues(new AllowableValue[]{SSL_MODE_DISABLED, SSL_MODE_PREFERRED, SSL_MODE_REQUIRED, SSL_MODE_VERIFY_IDENTITY}).build();
        SSL_CONTEXT_SERVICE = new PropertyDescriptor.Builder().name("SSL Context Service").displayName("SSL Context Service").description("SSL Context Service supporting encrypted socket communication").required(false).identifiesControllerService(SSLContextService.class).dependsOn(SSL_MODE, new AllowableValue[]{SSL_MODE_PREFERRED, SSL_MODE_REQUIRED, SSL_MODE_VERIFY_IDENTITY}).build();
        HashSet<Relationship> r = new HashSet<Relationship>();
        r.add(REL_SUCCESS);
        relationships = Collections.unmodifiableSet(r);
        ArrayList<PropertyDescriptor> pds = new ArrayList<PropertyDescriptor>();
        pds.add(HOSTS);
        pds.add(DRIVER_NAME);
        pds.add(DRIVER_LOCATION);
        pds.add(USERNAME);
        pds.add(PASSWORD);
        pds.add(SERVER_ID);
        pds.add(DATABASE_NAME_PATTERN);
        pds.add(TABLE_NAME_PATTERN);
        pds.add(CONNECT_TIMEOUT);
        pds.add(DIST_CACHE_CLIENT);
        pds.add(RETRIEVE_ALL_RECORDS);
        pds.add(INCLUDE_BEGIN_COMMIT);
        pds.add(INCLUDE_DDL_EVENTS);
        pds.add(STATE_UPDATE_INTERVAL);
        pds.add(INIT_SEQUENCE_ID);
        pds.add(INIT_BINLOG_FILENAME);
        pds.add(INIT_BINLOG_POSITION);
        pds.add(USE_BINLOG_GTID);
        pds.add(INIT_BINLOG_GTID);
        pds.add(SSL_MODE);
        pds.add(SSL_CONTEXT_SERVICE);
        propDescriptors = Collections.unmodifiableList(pds);
    }

    private static class DriverShim
    implements Driver {
        private final Driver driver;

        DriverShim(Driver d) {
            this.driver = d;
        }

        @Override
        public boolean acceptsURL(String u) throws SQLException {
            return this.driver.acceptsURL(u);
        }

        @Override
        public Connection connect(String u, Properties p) throws SQLException {
            return this.driver.connect(u, p);
        }

        @Override
        public int getMajorVersion() {
            return this.driver.getMajorVersion();
        }

        @Override
        public int getMinorVersion() {
            return this.driver.getMinorVersion();
        }

        @Override
        public DriverPropertyInfo[] getPropertyInfo(String u, Properties p) throws SQLException {
            return this.driver.getPropertyInfo(u, p);
        }

        @Override
        public boolean jdbcCompliant() {
            return this.driver.jdbcCompliant();
        }

        @Override
        public Logger getParentLogger() throws SQLFeatureNotSupportedException {
            return this.driver.getParentLogger();
        }
    }

    private class JDBCConnectionHolder {
        private final String connectionUrl;
        private final Properties connectionProps = new Properties();
        private final long connectionTimeoutMillis;
        private Connection connection;

        private JDBCConnectionHolder(InetSocketAddress host, String username, String password, Map<String, String> customProperties, long connectionTimeoutMillis) {
            this.connectionUrl = "jdbc:mysql://" + host.getHostString() + ":" + host.getPort();
            this.connectionProps.putAll(customProperties);
            this.connectionProps.put("user", username);
            this.connectionProps.put("password", password);
            this.connectionTimeoutMillis = connectionTimeoutMillis;
        }

        private Connection getConnection() throws SQLException {
            if (this.connection != null && this.connection.isValid((int)(this.connectionTimeoutMillis / 1000L))) {
                CaptureChangeMySQL.this.getLogger().trace("Returning the pooled JDBC connection.");
                return this.connection;
            }
            this.close();
            CaptureChangeMySQL.this.getLogger().trace("Creating a new JDBC connection.");
            this.connection = DriverManager.getConnection(this.connectionUrl, this.connectionProps);
            return this.connection;
        }

        private void close() {
            if (this.connection != null) {
                try {
                    CaptureChangeMySQL.this.getLogger().trace("Closing the pooled JDBC connection.");
                    this.connection.close();
                }
                catch (SQLException e) {
                    CaptureChangeMySQL.this.getLogger().warn("Failed to close JDBC connection due to " + e, (Throwable)e);
                }
            }
        }
    }
}

