/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cdc.mysql.processors.ssl;

import com.github.shyiko.mysql.binlog.network.SSLSocketFactory;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import javax.net.ssl.SSLSocket;

public class BinaryLogSSLSocketFactory
implements SSLSocketFactory {
    private static final boolean AUTO_CLOSE_ENABLED = true;
    private final javax.net.ssl.SSLSocketFactory sslSocketFactory;

    public BinaryLogSSLSocketFactory(javax.net.ssl.SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
    }

    public SSLSocket createSocket(Socket socket) throws SocketException {
        String hostAddress = socket.getInetAddress().getHostAddress();
        int port = socket.getPort();
        try {
            return (SSLSocket)this.sslSocketFactory.createSocket(socket, hostAddress, port, true);
        }
        catch (IOException e) {
            String message = String.format("Create SSL Socket Failed for Host Address [%s] Port [%d]: %s", hostAddress, port, e.getMessage());
            throw new SocketException(message);
        }
    }
}

