/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cdc.mysql.event;

import com.github.shyiko.mysql.binlog.BinaryLogClient;
import com.github.shyiko.mysql.binlog.event.Event;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.nifi.cdc.mysql.event.RawBinlogEvent;

public class BinlogEventListener
implements BinaryLogClient.EventListener {
    protected final AtomicBoolean stopNow = new AtomicBoolean(false);
    private static final int QUEUE_OFFER_TIMEOUT_MSEC = 100;
    private final BlockingQueue<RawBinlogEvent> queue;
    private final BinaryLogClient client;

    public BinlogEventListener(BinaryLogClient client, BlockingQueue<RawBinlogEvent> q) {
        this.client = client;
        this.queue = q;
    }

    public void start() {
        this.stopNow.set(false);
    }

    public void stop() {
        this.stopNow.set(true);
    }

    public void onEvent(Event event) {
        if (!this.stopNow.get()) {
            RawBinlogEvent ep = new RawBinlogEvent(event, this.client.getBinlogFilename());
            try {
                if (this.queue.offer(ep, 100L, TimeUnit.MILLISECONDS)) {
                    return;
                }
                throw new RuntimeException("Unable to add event to the queue");
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Interrupted while adding event to the queue");
            }
        }
    }
}

