/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.box.controllerservices;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxConfig;
import com.box.sdk.BoxDeveloperEditionAPIConnection;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.box.controllerservices.BoxClientService;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.components.resource.ResourceCardinality;
import org.apache.nifi.components.resource.ResourceType;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.JsonValidator;
import org.apache.nifi.processor.util.StandardValidators;

@CapabilityDescription(value="Provides Box client objects through which Box API calls can be used.")
@Tags(value={"box", "client", "provider"})
public class JsonConfigBasedBoxClientService
extends AbstractControllerService
implements BoxClientService {
    public static final PropertyDescriptor ACCOUNT_ID = new PropertyDescriptor.Builder().name("box-account-id").displayName("Account ID").description("The ID of the Box account who owns the accessed resource. Same as 'User Id' under 'App Info' in the App 'General Settings'.").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    public static final PropertyDescriptor APP_CONFIG_FILE = new PropertyDescriptor.Builder().name("app-config-file").displayName("App Config File").description("Full path of an App config JSON file. See Additional Details for more information.").required(false).identifiesExternalResource(ResourceCardinality.SINGLE, ResourceType.FILE, new ResourceType[0]).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    public static final PropertyDescriptor APP_CONFIG_JSON = new PropertyDescriptor.Builder().name("app-config-json").displayName("App Config JSON").description("The raw JSON containing an App config. See Additional Details for more information.").required(false).sensitive(true).addValidator((Validator)JsonValidator.INSTANCE).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    private static final List<PropertyDescriptor> PROPERTIES = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID, APP_CONFIG_FILE, APP_CONFIG_JSON));
    private volatile BoxAPIConnection boxAPIConnection;

    public final List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTIES;
    }

    @OnEnabled
    public void onEnabled(ConfigurationContext context) {
        this.boxAPIConnection = this.createBoxApiConnection(context);
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>(super.customValidate(validationContext));
        if (validationContext.getProperty(APP_CONFIG_FILE).isSet() && validationContext.getProperty(APP_CONFIG_JSON).isSet()) {
            validationResults.add(new ValidationResult.Builder().subject("App configuration").valid(false).explanation(String.format("'%s' and '%s' cannot be configured at the same time", APP_CONFIG_FILE.getDisplayName(), APP_CONFIG_JSON.getDisplayName())).build());
        }
        if (!validationContext.getProperty(APP_CONFIG_FILE).isSet() && !validationContext.getProperty(APP_CONFIG_JSON).isSet()) {
            validationResults.add(new ValidationResult.Builder().subject("App configuration").valid(false).explanation(String.format("either '%s' or '%s' must be configured", APP_CONFIG_FILE.getDisplayName(), APP_CONFIG_JSON.getDisplayName())).build());
        }
        return validationResults;
    }

    public BoxAPIConnection getBoxApiConnection() {
        return this.boxAPIConnection;
    }

    private BoxAPIConnection createBoxApiConnection(ConfigurationContext context) {
        BoxConfig boxConfig;
        String accountId;
        block9: {
            accountId = context.getProperty(ACCOUNT_ID).evaluateAttributeExpressions().getValue();
            if (context.getProperty(APP_CONFIG_FILE).isSet()) {
                String appConfigFile = context.getProperty(APP_CONFIG_FILE).evaluateAttributeExpressions().getValue();
                try (FileReader reader = new FileReader(appConfigFile);){
                    boxConfig = BoxConfig.readFrom((Reader)reader);
                    break block9;
                }
                catch (FileNotFoundException e) {
                    throw new ProcessException("Couldn't find Box config file", (Throwable)e);
                }
                catch (IOException e) {
                    throw new ProcessException("Couldn't read Box config file", (Throwable)e);
                }
            }
            String appConfig = context.getProperty(APP_CONFIG_JSON).evaluateAttributeExpressions().getValue();
            boxConfig = BoxConfig.readFrom((String)appConfig);
        }
        BoxDeveloperEditionAPIConnection api = BoxDeveloperEditionAPIConnection.getAppEnterpriseConnection((BoxConfig)boxConfig);
        api.asUser(accountId);
        return api;
    }
}

