/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.azure.storage.utils;

import com.azure.core.credential.AzureSasCredential;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.ProxyOptions;
import com.azure.core.http.netty.NettyAsyncHttpClientBuilder;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.HttpClientOptions;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.azure.identity.ManagedIdentityCredentialBuilder;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.azure.storage.common.StorageSharedKeyCredential;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processors.azure.storage.utils.AbstractStorageClientFactory;
import org.apache.nifi.services.azure.storage.AzureStorageCredentialsDetails_v12;
import reactor.core.publisher.Mono;

public class BlobServiceClientFactory
extends AbstractStorageClientFactory<AzureStorageCredentialsDetails_v12, BlobServiceClient> {
    public BlobServiceClientFactory(ComponentLog logger, ProxyOptions proxyOptions) {
        super(logger, proxyOptions);
    }

    @Override
    protected BlobServiceClient createStorageClient(AzureStorageCredentialsDetails_v12 credentialsDetails, ProxyOptions proxyOptions) {
        BlobServiceClientBuilder clientBuilder = new BlobServiceClientBuilder();
        clientBuilder.endpoint(String.format("https://%s.%s", credentialsDetails.getAccountName(), credentialsDetails.getEndpointSuffix()));
        HttpClientOptions clientOptions = new HttpClientOptions().setProxyOptions(proxyOptions);
        clientBuilder.clientOptions((ClientOptions)clientOptions);
        this.configureCredential(clientBuilder, credentialsDetails);
        return clientBuilder.buildClient();
    }

    private void configureCredential(BlobServiceClientBuilder clientBuilder, AzureStorageCredentialsDetails_v12 credentialsDetails) {
        switch (credentialsDetails.getCredentialsType()) {
            case ACCOUNT_KEY: {
                clientBuilder.credential(new StorageSharedKeyCredential(credentialsDetails.getAccountName(), credentialsDetails.getAccountKey()));
                break;
            }
            case SAS_TOKEN: {
                clientBuilder.credential(new AzureSasCredential(credentialsDetails.getSasToken()));
                break;
            }
            case MANAGED_IDENTITY: {
                clientBuilder.credential((TokenCredential)((ManagedIdentityCredentialBuilder)new ManagedIdentityCredentialBuilder().clientId(credentialsDetails.getManagedIdentityClientId()).httpClient(new NettyAsyncHttpClientBuilder().proxy(credentialsDetails.getProxyOptions()).build())).build());
                break;
            }
            case SERVICE_PRINCIPAL: {
                clientBuilder.credential((TokenCredential)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().tenantId(credentialsDetails.getServicePrincipalTenantId())).clientId(credentialsDetails.getServicePrincipalClientId())).clientSecret(credentialsDetails.getServicePrincipalClientSecret()).httpClient(new NettyAsyncHttpClientBuilder().proxy(credentialsDetails.getProxyOptions()).build())).build());
                break;
            }
            case ACCESS_TOKEN: {
                TokenCredential credential = tokenRequestContext -> Mono.just((Object)credentialsDetails.getAccessToken());
                clientBuilder.credential(credential);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unhandled credentials type: " + credentialsDetails.getCredentialsType());
            }
        }
    }
}

