/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.azure.storage.utils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.processor.util.list.ListableEntity;
import org.apache.nifi.serialization.SimpleRecordSchema;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;

public class ADLSFileInfo
implements Comparable<ADLSFileInfo>,
Serializable,
ListableEntity {
    private static final RecordSchema SCHEMA;
    private static final String FILESYSTEM = "filesystem";
    private static final String FILE_PATH = "filePath";
    private static final String DIRECTORY = "directory";
    private static final String FILENAME = "filename";
    private static final String LENGTH = "length";
    private static final String LAST_MODIFIED = "lastModified";
    private static final String ETAG = "etag";
    private static final Comparator<ADLSFileInfo> COMPARATOR;
    private final String fileSystem;
    private final String filePath;
    private final long length;
    private final long lastModified;
    private final String etag;

    private ADLSFileInfo(Builder builder) {
        this.fileSystem = builder.fileSystem;
        this.filePath = builder.filePath;
        this.length = builder.length;
        this.lastModified = builder.lastModified;
        this.etag = builder.etag;
    }

    public String getFileSystem() {
        return this.fileSystem;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public long getLength() {
        return this.length;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public String getEtag() {
        return this.etag;
    }

    public String getDirectory() {
        return this.filePath.contains("/") ? StringUtils.substringBeforeLast((String)this.filePath, (String)"/") : "";
    }

    public String getFilename() {
        return this.filePath.contains("/") ? StringUtils.substringAfterLast((String)this.filePath, (String)"/") : this.filePath;
    }

    public String getName() {
        return this.getFilePath();
    }

    public String getIdentifier() {
        return this.getFilePath();
    }

    public long getTimestamp() {
        return this.getLastModified();
    }

    public long getSize() {
        return this.getLength();
    }

    public static RecordSchema getRecordSchema() {
        return SCHEMA;
    }

    public Record toRecord() {
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put(FILESYSTEM, this.getFileSystem());
        values.put(FILE_PATH, this.getFilePath());
        values.put(DIRECTORY, this.getDirectory());
        values.put(FILENAME, this.getFilename());
        values.put(LENGTH, this.getLength());
        values.put(LAST_MODIFIED, this.getLastModified());
        values.put(ETAG, this.getEtag());
        return new MapRecord(SCHEMA, values);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ADLSFileInfo otherFileInfo = (ADLSFileInfo)other;
        return Objects.equals(this.fileSystem, otherFileInfo.fileSystem) && Objects.equals(this.filePath, otherFileInfo.filePath);
    }

    public int hashCode() {
        return Objects.hash(this.fileSystem, this.filePath);
    }

    @Override
    public int compareTo(ADLSFileInfo other) {
        return COMPARATOR.compare(this, other);
    }

    static {
        ArrayList<RecordField> recordFields = new ArrayList<RecordField>();
        recordFields.add(new RecordField(FILESYSTEM, RecordFieldType.STRING.getDataType(), false));
        recordFields.add(new RecordField(FILE_PATH, RecordFieldType.STRING.getDataType(), false));
        recordFields.add(new RecordField(DIRECTORY, RecordFieldType.STRING.getDataType(), false));
        recordFields.add(new RecordField(FILENAME, RecordFieldType.STRING.getDataType(), false));
        recordFields.add(new RecordField(LENGTH, RecordFieldType.LONG.getDataType(), false));
        recordFields.add(new RecordField(LAST_MODIFIED, RecordFieldType.TIMESTAMP.getDataType(), false));
        recordFields.add(new RecordField(ETAG, RecordFieldType.STRING.getDataType()));
        SCHEMA = new SimpleRecordSchema(recordFields);
        COMPARATOR = Comparator.comparing(ADLSFileInfo::getFileSystem).thenComparing(ADLSFileInfo::getFilePath);
    }

    public static class Builder {
        private String fileSystem;
        private String filePath;
        private long length;
        private long lastModified;
        private String etag;

        public Builder fileSystem(String fileSystem) {
            this.fileSystem = fileSystem;
            return this;
        }

        public Builder filePath(String filePath) {
            this.filePath = filePath;
            return this;
        }

        public Builder length(long length) {
            this.length = length;
            return this;
        }

        public Builder lastModified(long lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public ADLSFileInfo build() {
            return new ADLSFileInfo(this);
        }
    }
}

