/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.azure.storage.queue;

import com.microsoft.azure.storage.OperationContext;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.queue.CloudQueue;
import com.microsoft.azure.storage.queue.CloudQueueClient;
import com.microsoft.azure.storage.queue.CloudQueueMessage;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.DeprecationNotice;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.azure.storage.queue.AbstractAzureQueueStorage;
import org.apache.nifi.processors.azure.storage.queue.GetAzureQueueStorage;
import org.apache.nifi.processors.azure.storage.queue.PutAzureQueueStorage_v12;
import org.apache.nifi.processors.azure.storage.utils.AzureStorageUtils;

@SeeAlso(value={GetAzureQueueStorage.class})
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"azure", "microsoft", "cloud", "storage", "queue", "enqueue"})
@CapabilityDescription(value="Writes the content of the incoming FlowFiles to the configured Azure Queue Storage.")
@DeprecationNotice(alternatives={PutAzureQueueStorage_v12.class})
public class PutAzureQueueStorage
extends AbstractAzureQueueStorage {
    public static final PropertyDescriptor TTL = new PropertyDescriptor.Builder().name("time-to-live").displayName("TTL").description("Maximum time to allow the message to be in the queue. If left empty, the default value of 7 days will be used.").required(false).defaultValue("7 days").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).build();
    public static final PropertyDescriptor VISIBILITY_DELAY = new PropertyDescriptor.Builder().name("visibility-delay").displayName("Visibility Delay").description("The length of time during which the message will be invisible, starting when it is added to the queue. This value must be greater than or equal to 0 and less than the TTL value.").required(false).defaultValue("0 secs").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).build();
    private static final List<PropertyDescriptor> properties = Collections.unmodifiableList(Arrays.asList(AzureStorageUtils.STORAGE_CREDENTIALS_SERVICE, AzureStorageUtils.ACCOUNT_NAME, AzureStorageUtils.ACCOUNT_KEY, AzureStorageUtils.PROP_SAS_TOKEN, AzureStorageUtils.ENDPOINT_SUFFIX, TTL, QUEUE, VISIBILITY_DELAY, AzureStorageUtils.PROXY_CONFIGURATION_SERVICE));

    public List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return properties;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        CloudQueue cloudQueue;
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        long startNanos = System.nanoTime();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        session.exportTo(flowFile, (OutputStream)baos);
        String flowFileContent = baos.toString();
        CloudQueueMessage message = new CloudQueueMessage(flowFileContent);
        int ttl = context.getProperty(TTL).asTimePeriod(TimeUnit.SECONDS).intValue();
        int delay = context.getProperty(VISIBILITY_DELAY).asTimePeriod(TimeUnit.SECONDS).intValue();
        String queue = context.getProperty(QUEUE).evaluateAttributeExpressions(flowFile).getValue().toLowerCase();
        try {
            CloudQueueClient cloudQueueClient = this.createCloudQueueClient(context, flowFile);
            cloudQueue = cloudQueueClient.getQueueReference(queue);
            OperationContext operationContext = new OperationContext();
            AzureStorageUtils.setProxy(operationContext, context);
            cloudQueue.addMessage(message, ttl, delay, null, operationContext);
        }
        catch (StorageException | URISyntaxException e) {
            this.getLogger().error("Failed to write the message to Azure Queue Storage", e);
            flowFile = session.penalize(flowFile);
            session.transfer(flowFile, REL_FAILURE);
            return;
        }
        session.transfer(flowFile, REL_SUCCESS);
        long transmissionMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanos);
        session.getProvenanceReporter().send(flowFile, cloudQueue.getUri().toString(), transmissionMillis);
    }

    @Override
    public Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        int delay;
        ArrayList<ValidationResult> problems = new ArrayList<ValidationResult>(super.customValidate(validationContext));
        boolean ttlSet = validationContext.getProperty(TTL).isSet();
        boolean delaySet = validationContext.getProperty(VISIBILITY_DELAY).isSet();
        int ttl = validationContext.getProperty(TTL).asTimePeriod(TimeUnit.SECONDS).intValue();
        if (ttlSet) {
            int SEVEN_DAYS_TIMEPERIOD_IN_SECS = 604800;
            if (ttl > 604800) {
                problems.add(new ValidationResult.Builder().subject(TTL.getDisplayName()).valid(false).explanation(TTL.getDisplayName() + " exceeds the allowed limit of 7 days. Set a value less than 7 days").build());
            }
        }
        if (delaySet && ((delay = validationContext.getProperty(VISIBILITY_DELAY).asTimePeriod(TimeUnit.SECONDS).intValue()) > ttl || delay < 0)) {
            problems.add(new ValidationResult.Builder().subject(VISIBILITY_DELAY.getDisplayName()).valid(false).explanation(VISIBILITY_DELAY.getDisplayName() + " should be greater than or equal to 0 and less than " + TTL.getDisplayName()).build());
        }
        AzureStorageUtils.validateProxySpec(validationContext, problems);
        return problems;
    }
}

