/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.services.azure.storage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.azure.storage.utils.AzureStorageUtils;
import org.apache.nifi.services.azure.storage.ADLSCredentialsDetails;
import org.apache.nifi.services.azure.storage.ADLSCredentialsService;

@Tags(value={"azure", "microsoft", "cloud", "storage", "adls", "credentials"})
@CapabilityDescription(value="Defines credentials for ADLS processors.")
public class ADLSCredentialsControllerService
extends AbstractControllerService
implements ADLSCredentialsService {
    public static final PropertyDescriptor ACCOUNT_NAME = new PropertyDescriptor.Builder().fromPropertyDescriptor(AzureStorageUtils.ACCOUNT_NAME).description("The storage account name. There are certain risks in allowing the account name to be stored as a flowfile attribute. While it does provide for a more flexible flow by allowing the account name to be fetched dynamically from a flowfile attribute, care must be taken to restrict access to the event provenance data (e.g., by strictly controlling the policies governing provenance for this processor). In addition, the provenance repositories may be put on encrypted disk partitions.").required(true).build();
    public static final PropertyDescriptor ENDPOINT_SUFFIX = new PropertyDescriptor.Builder().fromPropertyDescriptor(AzureStorageUtils.ENDPOINT_SUFFIX).displayName("Endpoint Suffix").description("Storage accounts in public Azure always use a common FQDN suffix. Override this endpoint suffix with a different suffix in certain circumstances (like Azure Stack or non-public Azure regions).").required(true).defaultValue("dfs.core.windows.net").expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    public static final PropertyDescriptor USE_MANAGED_IDENTITY = new PropertyDescriptor.Builder().name("storage-use-managed-identity").displayName("Use Azure Managed Identity").description("Choose whether or not to use the managed identity of Azure VM/VMSS").required(false).defaultValue("false").allowableValues(new String[]{"true", "false"}).addValidator(StandardValidators.BOOLEAN_VALIDATOR).build();
    public static final PropertyDescriptor MANAGED_IDENTITY_CLIENT_ID = AzureStorageUtils.MANAGED_IDENTITY_CLIENT_ID;
    public static final PropertyDescriptor SERVICE_PRINCIPAL_TENANT_ID = AzureStorageUtils.SERVICE_PRINCIPAL_TENANT_ID;
    public static final PropertyDescriptor SERVICE_PRINCIPAL_CLIENT_ID = AzureStorageUtils.SERVICE_PRINCIPAL_CLIENT_ID;
    public static final PropertyDescriptor SERVICE_PRINCIPAL_CLIENT_SECRET = AzureStorageUtils.SERVICE_PRINCIPAL_CLIENT_SECRET;
    public static final PropertyDescriptor PROXY_CONFIGURATION_SERVICE = AzureStorageUtils.PROXY_CONFIGURATION_SERVICE;
    private static final List<PropertyDescriptor> PROPERTIES = Collections.unmodifiableList(Arrays.asList(ACCOUNT_NAME, ENDPOINT_SUFFIX, AzureStorageUtils.ACCOUNT_KEY, AzureStorageUtils.PROP_SAS_TOKEN, USE_MANAGED_IDENTITY, MANAGED_IDENTITY_CLIENT_ID, SERVICE_PRINCIPAL_TENANT_ID, SERVICE_PRINCIPAL_CLIENT_ID, SERVICE_PRINCIPAL_CLIENT_SECRET, PROXY_CONFIGURATION_SERVICE));
    private ConfigurationContext context;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTIES;
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        boolean accountKeySet = StringUtils.isNotBlank((CharSequence)validationContext.getProperty(AzureStorageUtils.ACCOUNT_KEY).getValue());
        boolean sasTokenSet = StringUtils.isNotBlank((CharSequence)validationContext.getProperty(AzureStorageUtils.PROP_SAS_TOKEN).getValue());
        boolean useManagedIdentitySet = validationContext.getProperty(USE_MANAGED_IDENTITY).asBoolean();
        boolean servicePrincipalTenantIdSet = StringUtils.isNotBlank((CharSequence)validationContext.getProperty(SERVICE_PRINCIPAL_TENANT_ID).getValue());
        boolean servicePrincipalClientIdSet = StringUtils.isNotBlank((CharSequence)validationContext.getProperty(SERVICE_PRINCIPAL_CLIENT_ID).getValue());
        boolean servicePrincipalClientSecretSet = StringUtils.isNotBlank((CharSequence)validationContext.getProperty(SERVICE_PRINCIPAL_CLIENT_SECRET).getValue());
        boolean servicePrincipalSet = servicePrincipalTenantIdSet || servicePrincipalClientIdSet || servicePrincipalClientSecretSet;
        String managedIdentityClientId = validationContext.getProperty(MANAGED_IDENTITY_CLIENT_ID).getValue();
        if (!this.onlyOneSet(accountKeySet, sasTokenSet, useManagedIdentitySet, servicePrincipalSet)) {
            results.add(new ValidationResult.Builder().subject(((Object)((Object)this)).getClass().getSimpleName()).valid(false).explanation("one and only one authentication method of [Account Key, SAS Token, Managed Identity, Service Principal] should be used").build());
        } else {
            if (servicePrincipalSet) {
                String template = "'%s' must be set when Service Principal authentication is being configured";
                if (!servicePrincipalTenantIdSet) {
                    results.add(new ValidationResult.Builder().subject(((Object)((Object)this)).getClass().getSimpleName()).valid(false).explanation(String.format("'%s' must be set when Service Principal authentication is being configured", SERVICE_PRINCIPAL_TENANT_ID.getDisplayName())).build());
                }
                if (!servicePrincipalClientIdSet) {
                    results.add(new ValidationResult.Builder().subject(((Object)((Object)this)).getClass().getSimpleName()).valid(false).explanation(String.format("'%s' must be set when Service Principal authentication is being configured", SERVICE_PRINCIPAL_CLIENT_ID.getDisplayName())).build());
                }
                if (!servicePrincipalClientSecretSet) {
                    results.add(new ValidationResult.Builder().subject(((Object)((Object)this)).getClass().getSimpleName()).valid(false).explanation(String.format("'%s' must be set when Service Principal authentication is being configured", SERVICE_PRINCIPAL_CLIENT_SECRET.getDisplayName())).build());
                }
            }
            if (!useManagedIdentitySet && StringUtils.isNotEmpty((CharSequence)managedIdentityClientId)) {
                results.add(new ValidationResult.Builder().subject(((Object)((Object)this)).getClass().getSimpleName()).valid(false).explanation(String.format("'%s' can only be configured when '%s' is set to true", MANAGED_IDENTITY_CLIENT_ID.getDisplayName(), USE_MANAGED_IDENTITY.getDisplayName())).build());
            }
        }
        return results;
    }

    private boolean onlyOneSet(Boolean ... checks) {
        long nrOfSet = Arrays.stream(checks).filter(check -> check).count();
        return nrOfSet == 1L;
    }

    @OnEnabled
    public void onEnabled(ConfigurationContext context) {
        this.context = context;
    }

    public ADLSCredentialsDetails getCredentialsDetails(Map<String, String> attributes) {
        ADLSCredentialsDetails.Builder credentialsBuilder = ADLSCredentialsDetails.Builder.newBuilder();
        this.setValue(credentialsBuilder, ACCOUNT_NAME, PropertyValue::getValue, ADLSCredentialsDetails.Builder::setAccountName, attributes);
        this.setValue(credentialsBuilder, AzureStorageUtils.ACCOUNT_KEY, PropertyValue::getValue, ADLSCredentialsDetails.Builder::setAccountKey, attributes);
        this.setValue(credentialsBuilder, AzureStorageUtils.PROP_SAS_TOKEN, PropertyValue::getValue, ADLSCredentialsDetails.Builder::setSasToken, attributes);
        this.setValue(credentialsBuilder, ENDPOINT_SUFFIX, PropertyValue::getValue, ADLSCredentialsDetails.Builder::setEndpointSuffix, attributes);
        this.setValue(credentialsBuilder, USE_MANAGED_IDENTITY, PropertyValue::asBoolean, ADLSCredentialsDetails.Builder::setUseManagedIdentity, attributes);
        this.setValue(credentialsBuilder, MANAGED_IDENTITY_CLIENT_ID, PropertyValue::getValue, ADLSCredentialsDetails.Builder::setManagedIdentityClientId, attributes);
        this.setValue(credentialsBuilder, SERVICE_PRINCIPAL_TENANT_ID, PropertyValue::getValue, ADLSCredentialsDetails.Builder::setServicePrincipalTenantId, attributes);
        this.setValue(credentialsBuilder, SERVICE_PRINCIPAL_CLIENT_ID, PropertyValue::getValue, ADLSCredentialsDetails.Builder::setServicePrincipalClientId, attributes);
        this.setValue(credentialsBuilder, SERVICE_PRINCIPAL_CLIENT_SECRET, PropertyValue::getValue, ADLSCredentialsDetails.Builder::setServicePrincipalClientSecret, attributes);
        credentialsBuilder.setProxyOptions(AzureStorageUtils.getProxyOptions((PropertyContext)this.context));
        return credentialsBuilder.build();
    }

    private <T> void setValue(ADLSCredentialsDetails.Builder credentialsBuilder, PropertyDescriptor propertyDescriptor, Function<PropertyValue, T> getPropertyValue, BiConsumer<ADLSCredentialsDetails.Builder, T> setBuilderValue, Map<String, String> attributes) {
        PropertyValue property = this.context.getProperty(propertyDescriptor);
        if (property.isSet()) {
            if (propertyDescriptor.isExpressionLanguageSupported()) {
                property = propertyDescriptor.getExpressionLanguageScope() == ExpressionLanguageScope.FLOWFILE_ATTRIBUTES ? property.evaluateAttributeExpressions(attributes) : property.evaluateAttributeExpressions();
            }
            T value = getPropertyValue.apply(property);
            setBuilderValue.accept(credentialsBuilder, (ADLSCredentialsDetails.Builder)value);
        }
    }
}

