/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.azure.storage;

import com.microsoft.azure.storage.OperationContext;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.blob.BlobRequestOptions;
import com.microsoft.azure.storage.blob.CloudBlob;
import com.microsoft.azure.storage.blob.CloudBlobClient;
import com.microsoft.azure.storage.blob.CloudBlobContainer;
import com.microsoft.azure.storage.blob.CloudBlockBlob;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.codec.DecoderException;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.DeprecationNotice;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.azure.AbstractAzureBlobProcessor;
import org.apache.nifi.processors.azure.storage.DeleteAzureBlobStorage;
import org.apache.nifi.processors.azure.storage.FetchAzureBlobStorage_v12;
import org.apache.nifi.processors.azure.storage.ListAzureBlobStorage;
import org.apache.nifi.processors.azure.storage.PutAzureBlobStorage;
import org.apache.nifi.processors.azure.storage.utils.AzureBlobClientSideEncryptionUtils;
import org.apache.nifi.processors.azure.storage.utils.AzureStorageUtils;

@Tags(value={"azure", "microsoft", "cloud", "storage", "blob"})
@CapabilityDescription(value="Retrieves contents of an Azure Storage Blob, writing the contents to the content of the FlowFile")
@SeeAlso(value={ListAzureBlobStorage.class, PutAzureBlobStorage.class, DeleteAzureBlobStorage.class})
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@WritesAttributes(value={@WritesAttribute(attribute="azure.length", description="The length of the blob fetched")})
@DeprecationNotice(alternatives={FetchAzureBlobStorage_v12.class}, reason="Processor depends on legacy Microsoft Azure SDK")
public class FetchAzureBlobStorage
extends AbstractAzureBlobProcessor {
    public static final PropertyDescriptor RANGE_START = new PropertyDescriptor.Builder().name("range-start").displayName("Range Start").description("The byte position at which to start reading from the blob. An empty value or a value of zero will start reading at the beginning of the blob.").addValidator(StandardValidators.DATA_SIZE_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(false).build();
    public static final PropertyDescriptor RANGE_LENGTH = new PropertyDescriptor.Builder().name("range-length").displayName("Range Length").description("The number of bytes to download from the blob, starting from the Range Start. An empty value or a value that extends beyond the end of the blob will read to the end of the blob.").addValidator(StandardValidators.createDataSizeBoundsValidator((long)1L, (long)Long.MAX_VALUE)).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(false).build();

    @Override
    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>(super.customValidate(validationContext));
        results.addAll(AzureBlobClientSideEncryptionUtils.validateClientSideEncryptionProperties(validationContext));
        return results;
    }

    @Override
    public List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>(super.getSupportedPropertyDescriptors());
        properties.add(RANGE_START);
        properties.add(RANGE_LENGTH);
        properties.add(AzureBlobClientSideEncryptionUtils.CSE_KEY_TYPE);
        properties.add(AzureBlobClientSideEncryptionUtils.CSE_KEY_ID);
        properties.add(AzureBlobClientSideEncryptionUtils.CSE_SYMMETRIC_KEY_HEX);
        return properties;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        long startNanos = System.nanoTime();
        String containerName = context.getProperty(AzureStorageUtils.CONTAINER).evaluateAttributeExpressions(flowFile).getValue();
        String blobPath = context.getProperty(BLOB).evaluateAttributeExpressions(flowFile).getValue();
        long rangeStart = context.getProperty(RANGE_START).isSet() ? context.getProperty(RANGE_START).evaluateAttributeExpressions(flowFile).asDataSize(DataUnit.B).longValue() : 0L;
        Long rangeLength = context.getProperty(RANGE_LENGTH).isSet() ? Long.valueOf(context.getProperty(RANGE_LENGTH).evaluateAttributeExpressions(flowFile).asDataSize(DataUnit.B).longValue()) : null;
        AtomicReference storedException = new AtomicReference();
        try {
            CloudBlobClient blobClient = AzureStorageUtils.createCloudBlobClient(context, this.getLogger(), flowFile);
            CloudBlobContainer container = blobClient.getContainerReference(containerName);
            OperationContext operationContext = new OperationContext();
            AzureStorageUtils.setProxy(operationContext, context);
            HashMap<String, String> attributes = new HashMap<String, String>();
            CloudBlockBlob blob = container.getBlockBlobReference(blobPath);
            BlobRequestOptions blobRequestOptions = this.createBlobRequestOptions(context);
            flowFile = session.write(flowFile, arg_0 -> FetchAzureBlobStorage.lambda$onTrigger$0((CloudBlob)blob, rangeStart, rangeLength, blobRequestOptions, operationContext, storedException, arg_0));
            long length = blob.getProperties().getLength();
            attributes.put("azure.length", String.valueOf(length));
            if (!attributes.isEmpty()) {
                flowFile = session.putAllAttributes(flowFile, attributes);
            }
            session.transfer(flowFile, REL_SUCCESS);
            long transferMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanos);
            session.getProvenanceReporter().fetch(flowFile, blob.getSnapshotQualifiedUri().toString(), transferMillis);
        }
        catch (StorageException | IllegalArgumentException | URISyntaxException | DecoderException | ProcessException e) {
            if (e instanceof ProcessException && storedException.get() == null) {
                throw (ProcessException)e;
            }
            Exception failureException = Optional.ofNullable((Exception)storedException.get()).orElse((Exception)e);
            this.getLogger().error("Failure to fetch Azure blob {}", new Object[]{blobPath, failureException});
            flowFile = session.penalize(flowFile);
            session.transfer(flowFile, REL_FAILURE);
        }
    }

    private static /* synthetic */ void lambda$onTrigger$0(CloudBlob blob, long rangeStart, Long rangeLength, BlobRequestOptions blobRequestOptions, OperationContext operationContext, AtomicReference storedException, OutputStream os) throws IOException {
        try {
            blob.downloadRange(rangeStart, rangeLength, os, null, blobRequestOptions, operationContext);
        }
        catch (StorageException e) {
            storedException.set(e);
            throw new IOException(e);
        }
    }
}

