/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.azure.storage;

import com.microsoft.azure.storage.OperationContext;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.blob.BlobProperties;
import com.microsoft.azure.storage.blob.BlobRequestOptions;
import com.microsoft.azure.storage.blob.CloudBlob;
import com.microsoft.azure.storage.blob.CloudBlobClient;
import com.microsoft.azure.storage.blob.CloudBlobContainer;
import com.microsoft.azure.storage.blob.CloudBlockBlob;
import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.codec.DecoderException;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.DeprecationNotice;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.azure.AbstractAzureBlobProcessor;
import org.apache.nifi.processors.azure.storage.DeleteAzureBlobStorage;
import org.apache.nifi.processors.azure.storage.FetchAzureBlobStorage;
import org.apache.nifi.processors.azure.storage.ListAzureBlobStorage;
import org.apache.nifi.processors.azure.storage.PutAzureBlobStorage_v12;
import org.apache.nifi.processors.azure.storage.utils.AzureBlobClientSideEncryptionUtils;
import org.apache.nifi.processors.azure.storage.utils.AzureStorageUtils;

@Tags(value={"azure", "microsoft", "cloud", "storage", "blob"})
@SeeAlso(value={ListAzureBlobStorage.class, FetchAzureBlobStorage.class, DeleteAzureBlobStorage.class})
@CapabilityDescription(value="Puts content into an Azure Storage Blob")
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@WritesAttributes(value={@WritesAttribute(attribute="azure.container", description="The name of the Azure container"), @WritesAttribute(attribute="azure.blobname", description="The name of the Azure blob"), @WritesAttribute(attribute="azure.primaryUri", description="Primary location for blob content"), @WritesAttribute(attribute="azure.etag", description="Etag for the Azure blob"), @WritesAttribute(attribute="azure.length", description="Length of the blob"), @WritesAttribute(attribute="azure.timestamp", description="The timestamp in Azure for the blob")})
@DeprecationNotice(alternatives={PutAzureBlobStorage_v12.class}, reason="Processor depends on legacy Microsoft Azure SDK")
public class PutAzureBlobStorage
extends AbstractAzureBlobProcessor {
    public static final PropertyDescriptor BLOB_NAME = new PropertyDescriptor.Builder().name("blob").displayName("Blob").description("The filename of the blob").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(true).build();
    public static final PropertyDescriptor CREATE_CONTAINER = new PropertyDescriptor.Builder().name("azure-create-container").displayName("Create Container").expressionLanguageSupported(ExpressionLanguageScope.NONE).required(true).addValidator(StandardValidators.BOOLEAN_VALIDATOR).allowableValues(new String[]{"true", "false"}).defaultValue("false").description("Specifies whether to check if the container exists and to automatically create it if it does not. Permission to list containers is required. If false, this check is not made, but the Put operation will fail if the container does not exist.").build();

    @Override
    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>(super.customValidate(validationContext));
        results.addAll(AzureBlobClientSideEncryptionUtils.validateClientSideEncryptionProperties(validationContext));
        return results;
    }

    @Override
    public List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>(super.getSupportedPropertyDescriptors());
        properties.remove(BLOB);
        properties.add(BLOB_NAME);
        properties.add(CREATE_CONTAINER);
        properties.add(AzureBlobClientSideEncryptionUtils.CSE_KEY_TYPE);
        properties.add(AzureBlobClientSideEncryptionUtils.CSE_KEY_ID);
        properties.add(AzureBlobClientSideEncryptionUtils.CSE_SYMMETRIC_KEY_HEX);
        return properties;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        long startNanos = System.nanoTime();
        String containerName = context.getProperty(AzureStorageUtils.CONTAINER).evaluateAttributeExpressions(flowFile).getValue();
        String blobPath = context.getProperty(BLOB_NAME).evaluateAttributeExpressions(flowFile).getValue();
        boolean createContainer = context.getProperty(CREATE_CONTAINER).asBoolean();
        AtomicReference storedException = new AtomicReference();
        try {
            CloudBlobClient blobClient = AzureStorageUtils.createCloudBlobClient(context, this.getLogger(), flowFile);
            CloudBlobContainer container = blobClient.getContainerReference(containerName);
            if (createContainer) {
                container.createIfNotExists();
            }
            CloudBlockBlob blob = container.getBlockBlobReference(blobPath);
            OperationContext operationContext = new OperationContext();
            AzureStorageUtils.setProxy(operationContext, context);
            BlobRequestOptions blobRequestOptions = this.createBlobRequestOptions(context);
            HashMap attributes = new HashMap();
            long length = flowFile.getSize();
            session.read(flowFile, arg_0 -> this.lambda$onTrigger$0((CloudBlob)blob, operationContext, blobRequestOptions, attributes, containerName, length, storedException, arg_0));
            if (!attributes.isEmpty()) {
                flowFile = session.putAllAttributes(flowFile, attributes);
            }
            session.transfer(flowFile, REL_SUCCESS);
            long transferMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanos);
            session.getProvenanceReporter().send(flowFile, blob.getSnapshotQualifiedUri().toString(), transferMillis);
        }
        catch (StorageException | IllegalArgumentException | URISyntaxException | DecoderException | ProcessException e) {
            if (e instanceof ProcessException && storedException.get() == null) {
                throw (ProcessException)e;
            }
            Exception failureException = Optional.ofNullable((Exception)storedException.get()).orElse((Exception)e);
            this.getLogger().error("Failed to put Azure blob {}", new Object[]{blobPath, failureException});
            flowFile = session.penalize(flowFile);
            session.transfer(flowFile, REL_FAILURE);
        }
    }

    void uploadBlob(CloudBlob blob, OperationContext operationContext, BlobRequestOptions blobRequestOptions, InputStream in) throws StorageException, IOException {
        blob.upload(in, -1L, null, blobRequestOptions, operationContext);
    }

    private /* synthetic */ void lambda$onTrigger$0(CloudBlob blob, OperationContext operationContext, BlobRequestOptions blobRequestOptions, Map attributes, String containerName, long length, AtomicReference storedException, InputStream rawIn) throws IOException {
        InputStream in = rawIn;
        if (!(in instanceof BufferedInputStream)) {
            in = new BufferedInputStream(rawIn);
        }
        if (in.markSupported()) {
            in = new UnmarkableInputStream(in);
        }
        try {
            this.uploadBlob(blob, operationContext, blobRequestOptions, in);
            BlobProperties properties = blob.getProperties();
            attributes.put("azure.container", containerName);
            attributes.put("azure.primaryUri", blob.getSnapshotQualifiedUri().toString());
            attributes.put("azure.etag", properties.getEtag());
            attributes.put("azure.length", String.valueOf(length));
            attributes.put("azure.timestamp", String.valueOf(properties.getLastModified()));
        }
        catch (StorageException | IOException | URISyntaxException e) {
            storedException.set(e);
            throw e instanceof IOException ? (IOException)e : new IOException(e);
        }
    }

    private static class UnmarkableInputStream
    extends FilterInputStream {
        public UnmarkableInputStream(InputStream in) {
            super(in);
        }

        @Override
        public void mark(int readlimit) {
        }

        @Override
        public void reset() throws IOException {
        }

        @Override
        public boolean markSupported() {
            return false;
        }
    }
}

