/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.azure.storage.utils;

import com.azure.core.http.ProxyOptions;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import org.apache.nifi.logging.ComponentLog;

abstract class AbstractStorageClientFactory<CREDENTIAL, CLIENT> {
    private static final long STORAGE_CLIENT_CACHE_SIZE = 10L;
    private final ComponentLog logger;
    private final ProxyOptions proxyOptions;
    private final Cache<CREDENTIAL, CLIENT> clientCache;

    protected AbstractStorageClientFactory(ComponentLog logger, ProxyOptions proxyOptions) {
        this.logger = logger;
        this.proxyOptions = proxyOptions;
        this.clientCache = this.createCache();
    }

    private Cache<CREDENTIAL, CLIENT> createCache() {
        return Caffeine.newBuilder().maximumSize(10L).build();
    }

    public CLIENT getStorageClient(CREDENTIAL credentialsDetails) {
        return (CLIENT)this.clientCache.get(credentialsDetails, __ -> {
            this.logger.debug(credentialsDetails.getClass().getSimpleName() + " is not found in the cache with the given credentials. Creating it.");
            return this.createStorageClient(credentialsDetails, this.proxyOptions);
        });
    }

    protected abstract CLIENT createStorageClient(CREDENTIAL var1, ProxyOptions var2);
}

