/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.azure.storage.utils;

import com.microsoft.azure.keyvault.cryptography.SymmetricKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.azure.storage.utils.AzureBlobClientSideEncryptionMethod;
import org.apache.nifi.util.StringUtils;

public class AzureBlobClientSideEncryptionUtils {
    private static final String DEFAULT_KEY_ID = "nifi";
    public static final PropertyDescriptor CSE_KEY_TYPE = new PropertyDescriptor.Builder().name("cse-key-type").displayName("Client-Side Encryption Key Type").required(true).allowableValues(AzureBlobClientSideEncryptionUtils.buildCseEncryptionMethodAllowableValues()).defaultValue(AzureBlobClientSideEncryptionMethod.NONE.name()).description("Specifies the key type to use for client-side encryption.").build();
    public static final PropertyDescriptor CSE_KEY_ID = new PropertyDescriptor.Builder().name("cse-key-id").displayName("Client-Side Encryption Key ID").description("Specifies the ID of the key to use for client-side encryption.").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(false).addValidator(StandardValidators.NON_BLANK_VALIDATOR).dependsOn(CSE_KEY_TYPE, AzureBlobClientSideEncryptionMethod.SYMMETRIC.name(), new String[0]).build();
    public static final PropertyDescriptor CSE_SYMMETRIC_KEY_HEX = new PropertyDescriptor.Builder().name("cse-symmetric-key-hex").displayName("Symmetric Key").description("When using symmetric client-side encryption, this is the raw key, encoded in hexadecimal").required(false).addValidator(StandardValidators.NON_BLANK_VALIDATOR).dependsOn(CSE_KEY_TYPE, AzureBlobClientSideEncryptionMethod.SYMMETRIC.name(), new String[0]).sensitive(true).build();

    private static AllowableValue[] buildCseEncryptionMethodAllowableValues() {
        return (AllowableValue[])Arrays.stream(AzureBlobClientSideEncryptionMethod.values()).map(v -> new AllowableValue(v.name(), v.name(), v.getDescription())).toArray(AllowableValue[]::new);
    }

    public static Collection<ValidationResult> validateClientSideEncryptionProperties(ValidationContext validationContext) {
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        String cseKeyTypeValue = validationContext.getProperty(CSE_KEY_TYPE).getValue();
        AzureBlobClientSideEncryptionMethod cseKeyType = AzureBlobClientSideEncryptionMethod.valueOf(cseKeyTypeValue);
        String cseKeyId = validationContext.getProperty(CSE_KEY_ID).getValue();
        String cseSymmetricKeyHex = validationContext.getProperty(CSE_SYMMETRIC_KEY_HEX).getValue();
        if (cseKeyType != AzureBlobClientSideEncryptionMethod.NONE && StringUtils.isBlank((String)cseKeyId)) {
            validationResults.add(new ValidationResult.Builder().subject(CSE_KEY_ID.getDisplayName()).explanation("a key ID must be set when client-side encryption is enabled.").build());
        }
        if (cseKeyType == AzureBlobClientSideEncryptionMethod.SYMMETRIC) {
            validationResults.addAll(AzureBlobClientSideEncryptionUtils.validateSymmetricKey(cseSymmetricKeyHex));
        }
        return validationResults;
    }

    private static List<ValidationResult> validateSymmetricKey(String keyHex) {
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        if (StringUtils.isBlank((String)keyHex)) {
            validationResults.add(new ValidationResult.Builder().subject(CSE_SYMMETRIC_KEY_HEX.getDisplayName()).explanation("a symmetric key must not be set when client-side encryption is enabled with symmetric encryption.").build());
        } else {
            try {
                byte[] keyBytes = Hex.decodeHex((char[])keyHex.toCharArray());
                new SymmetricKey(DEFAULT_KEY_ID, keyBytes);
            }
            catch (DecoderException e) {
                validationResults.add(new ValidationResult.Builder().subject(CSE_SYMMETRIC_KEY_HEX.getDisplayName()).explanation("the symmetric key must be a valid hexadecimal string.").build());
            }
            catch (IllegalArgumentException e) {
                validationResults.add(new ValidationResult.Builder().subject(CSE_SYMMETRIC_KEY_HEX.getDisplayName()).explanation(e.getMessage()).build());
            }
        }
        return validationResults;
    }
}

