/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.azure.storage;

import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.models.DeleteSnapshotsOptionType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.azure.AbstractAzureBlobProcessor_v12;
import org.apache.nifi.processors.azure.storage.FetchAzureBlobStorage_v12;
import org.apache.nifi.processors.azure.storage.ListAzureBlobStorage_v12;
import org.apache.nifi.processors.azure.storage.PutAzureBlobStorage_v12;
import org.apache.nifi.processors.azure.storage.utils.AzureStorageUtils;

@Tags(value={"azure", "microsoft", "cloud", "storage", "blob"})
@SeeAlso(value={ListAzureBlobStorage_v12.class, FetchAzureBlobStorage_v12.class, PutAzureBlobStorage_v12.class})
@CapabilityDescription(value="Deletes the specified blob from Azure Blob Storage. The processor uses Azure Blob Storage client library v12.")
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
public class DeleteAzureBlobStorage_v12
extends AbstractAzureBlobProcessor_v12 {
    public static final AllowableValue DELETE_SNAPSHOTS_NONE = new AllowableValue("NONE", "None", "Delete the blob only.");
    public static final AllowableValue DELETE_SNAPSHOTS_ALSO = new AllowableValue(DeleteSnapshotsOptionType.INCLUDE.name(), "Include Snapshots", "Delete the blob and its snapshots.");
    public static final AllowableValue DELETE_SNAPSHOTS_ONLY = new AllowableValue(DeleteSnapshotsOptionType.ONLY.name(), "Delete Snapshots Only", "Delete only the blob's snapshots.");
    public static final PropertyDescriptor DELETE_SNAPSHOTS_OPTION = new PropertyDescriptor.Builder().name("delete-snapshots-option").displayName("Delete Snapshots Option").description("Specifies the snapshot deletion options to be used when deleting a blob.").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).allowableValues(new AllowableValue[]{DELETE_SNAPSHOTS_NONE, DELETE_SNAPSHOTS_ALSO, DELETE_SNAPSHOTS_ONLY}).defaultValue(DELETE_SNAPSHOTS_NONE.getValue()).required(true).build();
    private static final List<PropertyDescriptor> PROPERTIES = Collections.unmodifiableList(Arrays.asList(STORAGE_CREDENTIALS_SERVICE, AzureStorageUtils.CONTAINER, BLOB_NAME, DELETE_SNAPSHOTS_OPTION, AzureStorageUtils.PROXY_CONFIGURATION_SERVICE));

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTIES;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        String containerName = context.getProperty(AzureStorageUtils.CONTAINER).evaluateAttributeExpressions(flowFile).getValue();
        String blobName = context.getProperty(BLOB_NAME).evaluateAttributeExpressions(flowFile).getValue();
        String deleteSnapshotsOption = context.getProperty(DELETE_SNAPSHOTS_OPTION).getValue();
        long startNanos = System.nanoTime();
        try {
            String provenanceMesage;
            BlobServiceClient storageClient = this.getStorageClient();
            BlobContainerClient containerClient = storageClient.getBlobContainerClient(containerName);
            BlobClient blobClient = containerClient.getBlobClient(blobName);
            if (blobClient.exists().booleanValue()) {
                DeleteSnapshotsOptionType deleteSnapshotsOptionType = this.getDeleteSnapshotsOptionType(deleteSnapshotsOption);
                blobClient.deleteWithResponse(deleteSnapshotsOptionType, null, null, null);
                provenanceMesage = this.getProvenanceMessage(deleteSnapshotsOptionType);
            } else {
                provenanceMesage = "Blob does not exist, nothing to delete";
            }
            session.transfer(flowFile, REL_SUCCESS);
            long transferMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanos);
            session.getProvenanceReporter().invokeRemoteProcess(flowFile, blobClient.getBlobUrl(), String.format("%s (%d ms)", provenanceMesage, transferMillis));
        }
        catch (Exception e) {
            this.getLogger().error("Failed to delete the specified blob ({}) from Azure Blob Storage. Routing to failure", new Object[]{blobName, e});
            flowFile = session.penalize(flowFile);
            session.transfer(flowFile, REL_FAILURE);
        }
    }

    private DeleteSnapshotsOptionType getDeleteSnapshotsOptionType(String deleteSnapshotOption) {
        try {
            return DeleteSnapshotsOptionType.valueOf((String)deleteSnapshotOption);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private String getProvenanceMessage(DeleteSnapshotsOptionType deleteSnapshotsOptionType) {
        if (deleteSnapshotsOptionType == null) {
            return "Blob deleted";
        }
        switch (deleteSnapshotsOptionType) {
            case INCLUDE: {
                return "Blob deleted along with its snapshots";
            }
            case ONLY: {
                return "Blob's snapshots deleted";
            }
        }
        throw new IllegalArgumentException("Unhandled DeleteSnapshotsOptionType: " + deleteSnapshotsOptionType);
    }
}

