/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.services.azure.storage;

import java.util.Map;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.service.lookup.AbstractSingleAttributeBasedControllerServiceLookup;
import org.apache.nifi.services.azure.storage.AzureStorageCredentialsDetails;
import org.apache.nifi.services.azure.storage.AzureStorageCredentialsService;

@Tags(value={"azure", "microsoft", "cloud", "storage", "blob", "queue", "credentials"})
@CapabilityDescription(value="Provides an AzureStorageCredentialsService that can be used to dynamically select another AzureStorageCredentialsService. This service requires an attribute named 'azure.storage.credentials.name' to be passed in, and will throw an exception if the attribute is missing. The value of 'azure.storage.credentials.name' will be used to select the AzureStorageCredentialsService that has been registered with that name. This will allow multiple AzureStorageCredentialsServices to be defined and registered, and then selected dynamically at runtime by tagging flow files with the appropriate 'azure.storage.credentials.name' attribute.")
@DynamicProperty(name="The name to register AzureStorageCredentialsService", value="The AzureStorageCredentialsService", description="If 'azure.storage.credentials.name' attribute contains the name of the dynamic property, then the AzureStorageCredentialsService (registered in the value) will be selected.", expressionLanguageScope=ExpressionLanguageScope.NONE)
public class AzureStorageCredentialsControllerServiceLookup
extends AbstractSingleAttributeBasedControllerServiceLookup<AzureStorageCredentialsService>
implements AzureStorageCredentialsService {
    public static final String AZURE_STORAGE_CREDENTIALS_NAME_ATTRIBUTE = "azure.storage.credentials.name";

    protected String getLookupAttribute() {
        return AZURE_STORAGE_CREDENTIALS_NAME_ATTRIBUTE;
    }

    public Class<AzureStorageCredentialsService> getServiceType() {
        return AzureStorageCredentialsService.class;
    }

    public AzureStorageCredentialsDetails getStorageCredentialsDetails(Map<String, String> attributes) {
        return ((AzureStorageCredentialsService)this.lookupService(attributes)).getStorageCredentialsDetails(attributes);
    }
}

