/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.azure;

public class AzureServiceEndpoints {
    private static final String DEFAULT_STORAGE_ENDPOINT_SUFFIX = ".core.windows.net";
    public static final String DEFAULT_BLOB_ENDPOINT_SUFFIX = "blob.core.windows.net";
    public static final String DEFAULT_ADLS_ENDPOINT_SUFFIX = "dfs.core.windows.net";
    public static final String DEFAULT_QUEUE_ENDPOINT_SUFFIX = "queue.core.windows.net";

    private AzureServiceEndpoints() {
    }

    public static String getAzureBlobStorageEndpoint(String accountName, String endpointSuffix) {
        return String.format("https://%s.%s", accountName, endpointSuffix != null ? endpointSuffix : DEFAULT_BLOB_ENDPOINT_SUFFIX);
    }

    public static String getAzureDataLakeStorageEndpoint(String accountName, String endpointSuffix) {
        return String.format("https://%s.%s", accountName, endpointSuffix != null ? endpointSuffix : DEFAULT_ADLS_ENDPOINT_SUFFIX);
    }
}

