/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.aws.schemaregistry.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.SchemaParseException;
import org.apache.nifi.avro.AvroTypeUtil;
import org.apache.nifi.aws.schemaregistry.client.SchemaRegistryClient;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.SchemaIdentifier;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.model.GetSchemaVersionRequest;
import software.amazon.awssdk.services.glue.model.GetSchemaVersionResponse;
import software.amazon.awssdk.services.glue.model.SchemaId;
import software.amazon.awssdk.services.glue.model.SchemaVersionNumber;

public class GlueSchemaRegistryClient
implements SchemaRegistryClient {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final String NAMESPACE_FIELD_NAME = "namespace";
    private final GlueClient client;
    private final String registryName;

    public GlueSchemaRegistryClient(GlueClient client, String registryName) {
        this.client = client;
        this.registryName = registryName;
    }

    @Override
    public RecordSchema getSchema(String schemaName) throws IOException, SchemaNotFoundException {
        SchemaVersionNumber schemaVersionNumber = (SchemaVersionNumber)SchemaVersionNumber.builder().latestVersion(Boolean.valueOf(true)).build();
        GetSchemaVersionResponse schemaVersionResponse = this.getSchemaVersionResponse(schemaName, schemaVersionNumber);
        return this.createRecordSchema(schemaVersionResponse);
    }

    @Override
    public RecordSchema getSchema(String schemaName, long version) throws IOException, SchemaNotFoundException {
        SchemaVersionNumber schemaVersionNumber = (SchemaVersionNumber)SchemaVersionNumber.builder().versionNumber(Long.valueOf(version)).build();
        GetSchemaVersionResponse schemaVersionResponse = this.getSchemaVersionResponse(schemaName, schemaVersionNumber);
        return this.createRecordSchema(schemaVersionResponse);
    }

    private GetSchemaVersionResponse getSchemaVersionResponse(String schemaName, SchemaVersionNumber schemaVersionNumber) {
        SchemaId schemaId = this.buildSchemaId(schemaName);
        GetSchemaVersionRequest request = this.buildSchemaVersionRequest(schemaVersionNumber, schemaId);
        return this.client.getSchemaVersion(request);
    }

    private GetSchemaVersionRequest buildSchemaVersionRequest(SchemaVersionNumber schemaVersionNumber, SchemaId schemaId) {
        return (GetSchemaVersionRequest)GetSchemaVersionRequest.builder().schemaVersionNumber(schemaVersionNumber).schemaId(schemaId).build();
    }

    private SchemaId buildSchemaId(String schemaName) {
        return (SchemaId)SchemaId.builder().registryName(this.registryName).schemaName(schemaName).build();
    }

    private RecordSchema createRecordSchema(GetSchemaVersionResponse schemaVersionResponse) throws SchemaNotFoundException, JsonProcessingException {
        JsonNode schemaNode = OBJECT_MAPPER.readTree(schemaVersionResponse.schemaDefinition());
        String namespace = schemaNode.get(NAMESPACE_FIELD_NAME).asText();
        int version = schemaVersionResponse.versionNumber().intValue();
        String schemaText = schemaVersionResponse.schemaDefinition();
        try {
            Schema avroSchema = new Schema.Parser().parse(schemaText);
            SchemaIdentifier schemaId = SchemaIdentifier.builder().name(namespace).version(Integer.valueOf(version)).build();
            return AvroTypeUtil.createSchema((Schema)avroSchema, (String)schemaText, (SchemaIdentifier)schemaId);
        }
        catch (SchemaParseException spe) {
            throw new SchemaNotFoundException("Obtained Schema with name " + namespace + " from Glue Schema Registry but the Schema Text that was returned is not a valid Avro Schema");
        }
    }
}

