/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.ml;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.regions.Regions;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.aws.AbstractAWSCredentialsProviderProcessor;
import org.apache.nifi.processors.aws.ml.AwsMachineLearningJobStatusProcessor;

public abstract class AwsMachineLearningJobStarter<T extends AmazonWebServiceClient, REQUEST extends AmazonWebServiceRequest, RESPONSE extends AmazonWebServiceResult>
extends AbstractAWSCredentialsProviderProcessor<T> {
    public static final PropertyDescriptor JSON_PAYLOAD = new PropertyDescriptor.Builder().name("json-payload").displayName("JSON Payload").description("JSON request for AWS Machine Learning services. The Processor will use FlowFile content for the request when this property is not specified.").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor MANDATORY_AWS_CREDENTIALS_PROVIDER_SERVICE = new PropertyDescriptor.Builder().fromPropertyDescriptor(AWS_CREDENTIALS_PROVIDER_SERVICE).required(true).build();
    public static final PropertyDescriptor REGION = new PropertyDescriptor.Builder().displayName("Region").name("aws-region").required(true).allowableValues(AwsMachineLearningJobStarter.getAvailableRegions()).defaultValue(AwsMachineLearningJobStarter.createAllowableValue((Regions)Regions.DEFAULT_REGION).getValue()).build();
    public static final Relationship REL_ORIGINAL = new Relationship.Builder().name("original").description("Upon successful completion, the original FlowFile will be routed to this relationship.").autoTerminateDefault(true).build();
    protected static final List<PropertyDescriptor> PROPERTIES = Collections.unmodifiableList(Arrays.asList(MANDATORY_AWS_CREDENTIALS_PROVIDER_SERVICE, REGION, TIMEOUT, JSON_PAYLOAD, SSL_CONTEXT_SERVICE, ENDPOINT_OVERRIDE));
    private static final ObjectMapper MAPPER = ((JsonMapper.Builder)JsonMapper.builder().configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true)).build();
    private static final Set<Relationship> relationships = Collections.unmodifiableSet(new HashSet<Relationship>(Arrays.asList(REL_ORIGINAL, REL_SUCCESS, REL_FAILURE)));

    public Set<Relationship> getRelationships() {
        return relationships;
    }

    public List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTIES;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) {
        FlowFile flowFile = session.get();
        if (flowFile == null && !context.getProperty(JSON_PAYLOAD).isSet()) {
            return;
        }
        try {
            RESPONSE response = this.sendRequest(this.buildRequest(session, context, flowFile), context, flowFile);
            FlowFile childFlowFile = this.writeToFlowFile(session, flowFile, response);
            this.postProcessFlowFile(context, session, childFlowFile, response);
            session.transfer(childFlowFile, REL_SUCCESS);
        }
        catch (Exception e) {
            if (flowFile != null) {
                session.transfer(flowFile, REL_FAILURE);
            }
            this.getLogger().error("Sending AWS ML Request failed", (Throwable)e);
            return;
        }
        if (flowFile != null) {
            session.transfer(flowFile, REL_ORIGINAL);
        }
    }

    protected void postProcessFlowFile(ProcessContext context, ProcessSession session, FlowFile flowFile, RESPONSE response) {
        String awsTaskId = this.getAwsTaskId(context, response, flowFile);
        flowFile = session.putAttribute(flowFile, AwsMachineLearningJobStatusProcessor.TASK_ID.getName(), awsTaskId);
        flowFile = session.putAttribute(flowFile, CoreAttributes.MIME_TYPE.key(), "application/json");
        this.getLogger().debug("AWS ML Task [{}] started", new Object[]{awsTaskId});
    }

    protected REQUEST buildRequest(ProcessSession session, ProcessContext context, FlowFile flowFile) throws JsonProcessingException {
        return (REQUEST)((AmazonWebServiceRequest)MAPPER.readValue(this.getPayload(session, context, flowFile), this.getAwsRequestClass(context, flowFile)));
    }

    protected T createClient(ProcessContext context, AWSCredentials credentials, ClientConfiguration config) {
        throw new UnsupportedOperationException("createClient(ProcessContext, AWSCredentials, ClientConfiguration) is not supported");
    }

    protected FlowFile writeToFlowFile(ProcessSession session, FlowFile flowFile, RESPONSE response) {
        FlowFile childFlowFile = flowFile == null ? session.create() : session.create(flowFile);
        childFlowFile = session.write(childFlowFile, out -> MAPPER.writeValue(out, response));
        return childFlowFile;
    }

    protected String readFlowFile(ProcessSession session, FlowFile flowFile) {
        String string;
        block8: {
            InputStream inputStream = session.read(flowFile);
            try {
                string = new String(IOUtils.toByteArray((InputStream)inputStream));
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ProcessException("Read FlowFile Failed", (Throwable)e);
                }
            }
            inputStream.close();
        }
        return string;
    }

    private String getPayload(ProcessSession session, ProcessContext context, FlowFile flowFile) {
        String payloadPropertyValue = context.getProperty(JSON_PAYLOAD).evaluateAttributeExpressions(flowFile).getValue();
        if (payloadPropertyValue == null) {
            payloadPropertyValue = this.readFlowFile(session, flowFile);
        }
        return payloadPropertyValue;
    }

    protected abstract RESPONSE sendRequest(REQUEST var1, ProcessContext var2, FlowFile var3) throws JsonProcessingException;

    protected abstract Class<? extends REQUEST> getAwsRequestClass(ProcessContext var1, FlowFile var2);

    protected abstract String getAwsTaskId(ProcessContext var1, RESPONSE var2, FlowFile var3);
}

