/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.kinesis.stream.record;

import com.amazonaws.services.kinesis.model.Record;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessSessionFactory;
import org.apache.nifi.processors.aws.kinesis.stream.record.AbstractKinesisRecordProcessor;
import org.apache.nifi.util.StopWatch;

public class KinesisRecordProcessorRaw
extends AbstractKinesisRecordProcessor {
    public KinesisRecordProcessorRaw(ProcessSessionFactory sessionFactory, ComponentLog log, String streamName, String endpointPrefix, String kinesisEndpoint, long checkpointIntervalMillis, long retryWaitMillis, int numRetries, DateTimeFormatter dateTimeFormatter) {
        super(sessionFactory, log, streamName, endpointPrefix, kinesisEndpoint, checkpointIntervalMillis, retryWaitMillis, numRetries, dateTimeFormatter);
    }

    @Override
    void processRecord(List<FlowFile> flowFiles, Record kinesisRecord, boolean lastRecord, ProcessSession session, StopWatch stopWatch) {
        String partitionKey = kinesisRecord.getPartitionKey();
        String sequenceNumber = kinesisRecord.getSequenceNumber();
        Date approximateArrivalTimestamp = kinesisRecord.getApproximateArrivalTimestamp();
        byte[] data = kinesisRecord.getData() != null ? kinesisRecord.getData().array() : new byte[]{};
        FlowFile flowFile = session.create();
        session.write(flowFile, out -> out.write(data));
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Sequence No: {}, Partition Key: {}, Data: {}", new Object[]{sequenceNumber, partitionKey, BASE_64_ENCODER.encodeToString(data)});
        }
        this.reportProvenance(session, flowFile, partitionKey, sequenceNumber, stopWatch);
        Map<String, String> attributes = this.getDefaultAttributes(sequenceNumber, partitionKey, approximateArrivalTimestamp);
        flowFile = session.putAllAttributes(flowFile, attributes);
        flowFiles.add(flowFile);
    }
}

