/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.dynamodb;

import com.amazonaws.services.dynamodbv2.document.Item;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;

final class RecordToItemConverter {
    private RecordToItemConverter() {
    }

    public static void addField(Record record, Item item, RecordFieldType fieldType, String fieldName) {
        switch (fieldType) {
            case BOOLEAN: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case BYTE: 
            case DOUBLE: 
            case STRING: {
                item.with(fieldName, record.getValue(fieldName));
                break;
            }
            case BIGINT: {
                item.withBigInteger(fieldName, new BigInteger(record.getAsString(fieldName)));
                break;
            }
            case DECIMAL: {
                item.withNumber(fieldName, new BigDecimal(record.getAsString(fieldName)));
                break;
            }
            case TIMESTAMP: 
            case DATE: 
            case TIME: {
                item.withString(fieldName, record.getAsString(fieldName));
            }
            case CHAR: {
                item.withString(fieldName, record.getAsString(fieldName));
                break;
            }
            case ENUM: {
                item.withString(fieldName, record.getAsString(fieldName));
                break;
            }
            case ARRAY: {
                item.withList(fieldName, record.getAsArray(fieldName));
                break;
            }
            case RECORD: {
                item.withMap(fieldName, RecordToItemConverter.getRecordFieldAsMap(record.getAsRecord(fieldName, null)));
                break;
            }
            case MAP: {
                item.withMap(fieldName, RecordToItemConverter.getMapFieldAsMap(record.getValue(fieldName)));
                break;
            }
            default: {
                item.withString(fieldName, record.getAsString(fieldName));
            }
        }
    }

    private static Map<String, Object> getRecordFieldAsMap(Record recordField) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (RecordField field : recordField.getSchema().getFields()) {
            result.put(field.getFieldName(), RecordToItemConverter.convertToSupportedType(recordField.getValue(field)));
        }
        return result;
    }

    private static Map<String, Object> getMapFieldAsMap(Object recordField) {
        if (!(recordField instanceof Map)) {
            throw new IllegalArgumentException("Map type is expected");
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        ((Map)recordField).forEach((name, value) -> result.put((String)name, RecordToItemConverter.convertToSupportedType(value)));
        return result;
    }

    private static Object convertToSupportedType(Object value) {
        if (value instanceof Record) {
            return RecordToItemConverter.getRecordFieldAsMap((Record)value);
        }
        if (value instanceof Map) {
            return RecordToItemConverter.getMapFieldAsMap(value);
        }
        if (value instanceof Character || value instanceof Timestamp || value instanceof Date || value instanceof Time) {
            return ((Character)value).toString();
        }
        if (value instanceof Enum) {
            return ((Enum)value).name();
        }
        return value;
    }
}

